<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>

<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

<style>
   thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
        width: 60px !important;
        padding: 1px 1px 1px 1px !important;
        box-shadow: none !important;

    }
    .dt-button{
        color: black !important;
    }
</style>

<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"><?php echo e(__('administrator.history_driver_list')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                <?php echo Form::open(array('route' => 'history_driver_print','method'=>'POST')); ?>

                <div class="form-search">
                    <?php if(\Globals::is_Administrator() == 'Administrator'): ?>
                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::select('drivers', $drivers, null, ['class' => 'form-control']); ?>

                    </div>
                    <?php endif; ?>

                    <div class="form-group col-sm-2 col-xs-2">
                        <select name="status[]" id="" multiple="multiple" class="form-control chosen-select" >
                            <option value=""> <?php echo e(__('administrator.please_choose')); ?> </option>
                            <option value="1">  <?php echo e(__('administrator.processing')); ?></option>
                            <option value="2">  <?php echo e(__('administrator.padding')); ?> </option>
                            <option value="3"> <?php echo e(__('administrator.done')); ?> </option>
                            <option value="4"> <?php echo e(__('administrator.cancel')); ?> </option>
                        </select>
                    </div>
                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')); ?>

                    </div>
                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')); ?>

                    </div>

                    <div class="form-group col-sm-2 col-xs-2">
                        <?php echo Form::text('driver_voucher',null, array('placeholder' => __('administrator.driver_voucher'),'class' => 'form-control')); ?>

                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right " onclick="searching()" type="button"><span class="fa fa-search"></span> <?php echo e(__('administrator.searching')); ?> </button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"  style='display: none'><span class="fa fa-print"></span><?php echo e(__('administrator.print')); ?> </button>
                        </div>
                    </div>

                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th><?php echo e(__('administrator.no')); ?></th>
                    <th><?php echo e(__('administrator.driver')); ?></th>
                    <th><?php echo e(__('administrator.boxs')); ?></th>
                    <th><?php echo e(__('administrator.share_commission')); ?></th>
                    <th><?php echo e(__('administrator.driver_commission')); ?></th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">
    $(document).on('change','select[name="drivers"]',function(){
        if($(this).val() != ''){
            $('.buttons-print').show();
        }
        else{
            $('.buttons-print').hide();

        }
    });



    var table  = $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "<?php echo e(__('administrator.search')); ?>:",
            "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
            "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
            "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
            "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
            "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
            "oPaginate": {
                "sFirst": "<?php echo e(__('administrator.first')); ?>",
                "sLast": "<?php echo e(__('administrator.last')); ?>",
                "sNext": "<?php echo e(__('administrator.next')); ?>",
                "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "<?php echo e(route('datatable.datable_summary_driver')); ?>",
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'pageLength',
                text: 'show', // Label
                className: 'buttons-html5',
            },
            {
                extend: 'excelHtml5',
                title: 'Report Delivery',
                autoFilter: true,
                sheetName: 'Exported data',
                customize: function ( xlsx ){
                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    $('row c[r*="2"]', sheet).attr( 's', '25' );
                    $('row c[r^="C"]', sheet).each( function () {
                        // Get the value
                    });
                }
            },
            {
                extend: 'pdfHtml5',
                title: 'Report Delivery'
            },
            {
                extend: 'copyHtml5',
                title: 'Report Delivery'
            },


        ],
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'driver_name'},
                {data: 'box'},
                {data: 'share_commission'},
                {data: 'driver_commission'}
            ],
            orderCellsTop: true,
            fixedHeader: true,

    });
    function searching()
    {
        var from_date       = $('input[name="from_date"]').val();
        var to_date         = $('input[name="to_date"]').val();
        var drivers         = $('select[name="drivers"]').val();
        var status          = $('select[name="status[]"]').val();
        var driver_voucher  = $('input[name="driver_voucher"]').val();

        var table = '';
        var taxi_fee =0;
        var reason ='';
        var delivery_fee =0;
        var account_name = '';
        $.ajax({
            url: "<?php echo e(Route('datatable.datable_history_driver')); ?>",
            method: "POST",
            dataType: "json",
            data: {
                from_date: from_date,
                to_date: to_date,
                drivers: drivers,
                status: status,
                driver_voucher: driver_voucher,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function (data) {
                    var status ='';
                $.each(data, function(index, val) {
                    str = val.delivery_date;
                    st2 = str.split("-");
                    yr = st2[0];
                    mo = st2[1];
                    dy = st2[2];
                    var new_date = dy+'-'+mo+'-'+yr;
                    if(val.status == 1)  // 1 = Processing,
                        status = ' <strong class="text-primary"><span class=" fa fa-spinner"></span>  <?php echo e(__("administrator.processing")); ?> </strong>';
                    else if(val.status == 2)  // 2 = Padding,
                        status = '  <strong class="text-warning"><span class="fa fa-bullseye"></span>  <?php echo e(__("administrator.padding")); ?></strong>';
                    else if(val.status == 3)  //  3 = Done ,
                        status = ' <strong class="text-info"><span class="fa fa-check"></span> <?php echo e(__("administrator.done" )); ?> </strong>';
                    else if(val.status == 3)   // 4 = Cancel
                        status = ' <strong class="text-danger"><span class="fa fa-ban"></span>  <?php echo e(__("administrator.cancel")); ?>  </strong>';
                    else
                        status = ' <strong class="text-muted"><span class="fa fa-check"></span>  <?php echo e(__("administrator.paid")); ?></strong>';

                    

                    if(val.taxi_status == 1){
                        taxi_fee =   val.taxi_shop_fee  ;
                    } else{
                        taxi_fee =  0  ;
                    }
                    if(val.delivery_status == 0){  //shop
                        total =  val.total_price - val.delivery_fee;
                    }else{   //customer
                        total = val.total_price + val.delivery_fee;
                    }
                    total =  total - taxi_fee ;

                    
                    if(val.delivery_status == 0){
                         delivery_fee = val.delivery_fee ;
                     }
                     else{
                         delivery_fee = val.delivery_fee ;
                     }
                     

                     taxi_fee = 0;
                     if(val.taxi_status == 1){
                         taxi_fee = val.taxi_shop_fee ;
                     }
                     else{
                         taxi_fee = val.taxi_cust_fee;
                     }

                     

                     if(val.reason==null){
                        reason = 'N/A';
                     }
                     else{
                        reason = val.reason;
                     }
                    table += `
                        <tr>
                            <td>${index+1}</td>
                            <td>${new_date}</td>
                            <td>${val.driver_voucher}</td>
                            <td>${val.driver_name}</td>
                            <td>${val.shop_name}</td>
                            <td>${val.box_code}</td>
                            <td>${val.name_location}</td>
                            <td>${val.customer_receive}</td>
                            <td>$ ${ parseFloat(val.total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')} </td>
                            <td>$ ${ parseFloat(taxi_fee).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$ ${ parseFloat(delivery_fee).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$ ${ parseFloat(total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>${reason}</td>
                            <td>${status}</td>

                        </tr>
                    `;
                });
                $('.tbody').empty().append(table);
            }
        });
    }


</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/report/summary-driver.blade.php ENDPATH**/ ?>