<?php $__env->startSection('content'); ?>
    <?php Fun::lang(); ?>
    <div class="top-header">
        <ol class="breadcrumb">
          <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
          <li class="active"><?php echo e(__('administrator.products')); ?></li>
        </ol>
    </div>
    
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> <?php echo e(__('administrator.products')); ?></h3>
                            </div>
                            <div class="pull-right"  style="margin-top: 20px">
                                <?php if(Gate::check('Create Product')): ?>
                                    <a href="<?php echo e(route('product.create')); ?>" class="button_sm button_info"><span class="fa fa-plus"></span> <?php echo e(__('administrator.create_new')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table width="100%" class="table table-striped table-hover datatable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('administrator.image')); ?></th>
                            <th><?php echo e(__('administrator.products_name')); ?></th>
                            <th><?php echo e(__('administrator.price')); ?></th>
                            <th><?php echo e(__('administrator.generate_barcode')); ?></th>
                            <th><?php echo e(__('administrator.category')); ?></th>
                            <th><?php echo e(__('administrator.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal fade" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
            aria-hidden="true" data-backdrop="static">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                        <h4 class="modal-title"><?php echo e(__('administrator.location')); ?></h4>
                    </div>

                    <div class="modal-body">
                        <form id="idForm" method="post" action="<?php echo e(route('locationSave')); ?>" class="form-horizontal">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="pearent_id">
                            <div class="form-group">
                                <label class="col-sm-4"><?php echo e(__('administrator.name_en')); ?></label>
                                <div class="col-sm-8">
                                    <?php echo Form::text('name_en', null, ['placeholder' => __('administrator.name_en'), 'class' => 'form-control', 'required']); ?>

                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-4"><?php echo e(__('administrator.name_km')); ?></label>
                                <div class="col-sm-8">
                                    <?php echo Form::text('name_km', null, ['placeholder' => __('administrator.name_km'), 'class' => 'form-control', 'required']); ?>

                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-4"><?php echo e(__('administrator.price')); ?></label>
                                <div class="col-sm-8">
                                    <?php echo Form::number('price', null, ['placeholder' => __('administrator.price'), 'class' => 'form-control', 'required', 'step' => 'any']); ?>

                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-12 col-xs-12">
                                    <button type="submit" class="button_sm button_primary pull-right"><span
                                            class="fa fa-save"></span> <?php echo e(__('administrator.save')); ?></button>
                                    <button type="button" data-dismiss="modal" aria-hidden="true"
                                        class="button_sm button_danger pull-right">
                                        <span class="fa fa-close"></span> <?php echo e(__('administrator.close')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    <?php $__env->stopSection(); ?>



    <?php $__env->startSection('script'); ?>
        <script type="text/javascript">
            $(function() {
                $('.datatable').DataTable({
                    "oLanguage": {
                        "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                        "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                        "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                        "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                        "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                        "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                        "oPaginate": {
                            "sFirst": "<?php echo e(__('administrator.first')); ?>",
                            "sLast": "<?php echo e(__('administrator.last')); ?>",
                            "sNext": "<?php echo e(__('administrator.next')); ?>",
                            "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                        },
                    },
                    ordering: false,
                    serverSide: true,
                    responsive: true,
                    lengthMenu: [
                        [10,100, 200, 500, 1000, -1],
                        [10,100, 200, 500, 1000, 'All']
                    ],
                    ajax: window.location,
                    columns: [
                        {data: 'DT_RowIndex'},
                        {data: 'image'},
                        {data: 'product_name'},
                        {data: 'price'},
                        {data: 'barcode'},
                        {data: 'category_name'},
                        {data: 'action'},


                    ],

                    "initComplete": function(settings, json) {



                    },
                    "drawCallback": function(settings) {
                        $('.toggle').bootstrapToggle({
                            on: 'Enabled',
                            off: 'Disabled',
                            size: 'small',
                            offstyle: 'danger'
                        });
                        $('.toggle').click(function() {
                            console.log(2);
                            let toggle = $(this).find('.dis_and_en');
                            let value = parseInt(toggle.val()) == 0 ? parseInt(toggle.val()) + 1 :
                                parseInt(toggle.val()) - 1;
                            toggle.val(value);
                            let route = toggle.data('route');
                            let type = toggle.data('type');
                            $.ajax({
                                type: "DELETE",
                                url: route,
                                data: {
                                    _token: '<?php echo e(csrf_token()); ?>',
                                    type: type,
                                    status: value
                                },
                                success: function(response) {

                                }
                            });
                        })
                    }
                });
                $('.select2').select2({
                    theme: 'bootstrap4'
                });
                $(document).on('click', '.button_delete', function() {
                    var id = $(this).data('id');

                    var this_ = $(this);
                    $.confirm({
                        icon: 'fa fa-trash ',
                        title: 'លុប!',
                        closeIcon: true,
                        content: ' ',
                        animation: 'scale',
                        type: 'red ',
                        buttons: {
                            បិទ: function() {

                            },
                            យល់ព្រម: function() {
                                $.ajax({
                                    type: 'POST',
                                    url: '<?php echo e(route('location_delete')); ?>',
                                    dataType: 'text',
                                    data: {
                                        _token: '<?php echo e(csrf_token()); ?>',
                                        id: id,
                                    },
                                    success: function(data) {
                                        location.reload();
                                    }
                                });
                            },
                        }
                    });
                });
                $(document).on('click', '.add_location', function() {
                    var id = $(this).data('id');
                    $('input[name="pearent_id"]').val(id);
                    $('#loginModal').modal('show');
                });
                $("#idForm").submit(function(e) {
                    e.preventDefault();
                    var form = $(this);
                    var url = form.attr('action');
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: form.serialize(),
                        success: function(data)
                        {
                            $('#loginModal').modal('hide');
                            $('#idForm')[0].reset();
                        },
                        error: function (err) {
                                alert('Location Aleady Exist !');
                        }
                    });
                });

            });
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/product/index.blade.php ENDPATH**/ ?>