<?php $branch = \App\BranchModel::find(1); ?>
<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="utf-8">
    <title><?php echo e(@$title_name ? @$title_name  : "ប្រព័ន្ធដឹកជញ្ជូន"); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.5.0-beta4/html2canvas.js"></script>
    <link rel="icon" href="<?php echo e(asset('images/logo.jpg')); ?>"> 
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/styles.css')); ?>">
    <link href="<?php echo e(asset('css/style-pos.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style-stock.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/mobile/css/responsive.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/print_this/pos-invoice.css')); ?>" rel="stylesheet">

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/font-awesome-4.7.0/css/font-awesome.css')); ?>">

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/animate.min.css')); ?>">

    
    <script src="<?php echo e(asset('assets/js/jquery3.4.1.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/bootstrap-toggle/css/bootstrap-toggle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/jquery-confirm/css/jquery-confirm.min.css')); ?>">


    <!-- MMenu -->
    <link rel="stylesheet" href="<?php echo e(asset('css/jquery.mmenu.all.min.css')); ?> ">
</head>

<body>
    <?php Fun::lang()?>
        <?php echo $__env->yieldContent('main'); ?>
        <br>&nbsp;
        <br>&nbsp;
        <br>&nbsp;
        <br>&nbsp;
        <nav class="navbar default navbar-fixed-bottom">
            <div class="container-fluid">
                <div class="navbar-header">
                    <a class="navbar-brand" href="http://netsolution.online/" target="_blank" style="text-shadow: 1px 1px 2px rgba(1,1,1,0.9)">
                        <small>Power by</small>
                        <span class="green">NetSolutionOnline</span></a>
                </div>
                <ul class="nav navbar-nav pull-right">
                    <li><a href="">© 2019 NetSolutionOnline Co,. Ltd.. All Rights Reserved.</a></li>
                </ul>
            </div>
        </nav>

        <style type="text/css">
            .navbar-brand {
                text-transform: uppercase;
                font-weight: 700;
                color: #fff;
                line-height: 50px;
                padding: 3px 15px;
                float: left;
                padding: 15px 15px;
                font-size: 18px;
                line-height: 20px;
            }
            .dropdown-submenu {
                position: relative;
            }

            .dropdown-submenu .dropdown-menu {
                top: 50px;
                left: 100%;
            }
            .swal2-popup.swal2-toast .swal2-title{
                font-size: 1.5rem !important;
            }
            .swal2-popup.swal2-toast .swal2-icon.swal2-success .swal2-success-ring{
                width: 2rem !important;
                height: 2rem !important;
            }

            @media  print{
                .main-menu-toggle{
                    display: none !important;
                }
                .top-header{
                    display: none !important;
                }
            }
        </style>
        <?php if(!@$loading): ?>
            <div class="bg-loading" id="ajax-loading">
                <div class="lds-ring">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>
                <div class="text-loading text-center">
                    <span><b>ប្រព័ន្ធដឹកជញ្ជូន</b></span>
                </div>
            </div>
        <?php endif; ?>
</body>

<link rel="stylesheet" href="//cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css">
<?php if(request()->segment(2) !== 'history-delivery-list' || request()->segment(2) !== 'history-driver-list'  ): ?>
    <script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<?php endif; ?>

<script src="//cdn.datatables.net/buttons/1.6.2/js/buttons.colVis.min.js"></script>

<link rel="stylesheet" type="text/css" href="<?php echo e(asset('js/bootstrap-fileinput/fileinput.css')); ?>">
<script type="text/javascript" src="<?php echo e(asset('js/bootstrap-fileinput/popper.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/bootstrap-fileinput/theme.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/bootstrap-fileinput/mulitple-img.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/bootstrap-fileinput/fileinput.js')); ?>"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('js/select2/select2.css')); ?>">
<script src="<?php echo e(asset('js/select2/select2.min.js')); ?>"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('js/datepicker/datepicker.min.css')); ?>">
<script src="<?php echo e(asset('js/datepicker/datepicker.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/jquery-confirm/js/bootstrap3-typeahead.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/jquery-confirm/js/jquery-confirm.min.js')); ?>"></script>


<script type="text/javascript" src="<?php echo e(asset('assets/bootstrap-toggle/js/bootstrap-toggle.min.js')); ?>"></script>


<script src="<?php echo e(asset('assets/js/barcode/barcode.js')); ?>"></script>
<script src="<?php echo e(asset('js/share.js')); ?>"></script>
<script src="https://cdn.ckeditor.com/4.11.1/standard/ckeditor.js"></script>
<script src="<?php echo e(asset('assets/js/sidebar/collapse.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/print_this/printThis.js')); ?>"></script>
<script src="<?php echo e(asset('assets/mobile/js/jquery-confirm.js')); ?>"></script>

<script src="<?php echo e(asset('assets/sweetalert2/sweetalert2.min.js')); ?>"></script>

<!-- MMenu -->
<script src="<?php echo e(asset('js/jquery.mmenu.min.all.min.js')); ?> "></script>

<?php echo $__env->yieldContent('script'); ?>
<?php if($branch->menu_layout == 'left'): ?>
    <script type="text/javascript">
        $(document).ready(function() {
            setTimeout(function() {
                $('.main-sidebar').removeClass('slide-in');
            }, 500);
            $('.sidebar-toggle').on('click', function() {

                $('.main-sidebar').toggleClass('slide-out');
                setTimeout(function() {
                    $('.main-sidebar').toggleClass('slide-in');
                }, 200);

            });
        });
        $.validator.setDefaults({
            ignore: ":hidden:not(.chosen-select)"
        });
        $("#customer").validate({
            rules: {
                type_of_customer: {
                    required: true,
                },
                name: {
                    required: true,
                },
                phone_number: {
                    required: true,
                },
            },
        });
    </script>
    <script type="text/javascript">
        var loc = window.location.pathname;
        $('#nav').find('a').each(function() {
            $(this).toggleClass('active', $(this).attr('href') == loc);
        });
    </script>
<?php endif; ?>
<script type="text/javascript">
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
        didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
    });
    function copyToClipboard(box_code) {
        var textBox = document.getElementById('cl_'+box_code);
        textBox.select();
        document.execCommand("copy");
    }


    $("#file-1").fileinput({
        theme: 'fa',
        uploadUrl: "/image-view",
        uploadExtraData: function() {
            return {
                _token: $("input[name='_token']").val(),
            };
        },
        allowedFileExtensions: ['jpg', 'png', 'gif'],
        overwriteInitial: false,
        maxFileSize: 2000,
        maxFilesNum: 10,
        slugCallback: function(filename) {
            return filename.replace('(', '_').replace(']', '_');
        }
    });

    $('input[type=text]').prop('autocomplete', 'off');
    // Number Only
    $(document).on('keypress', '.number-only', function(e) {
        if (isNaN(this.value + "" + String.fromCharCode(e.charCode))) return false;
    });

    

    //Datatable
    $('#datatable').DataTable({
        "paging": false,
        'ordering': false
    });

    //Date Picker

    $(".date_picker").datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true,
    });
    $(".date_picker_min_date").datepicker({
        dateFormat: "dd-mm-yy",
        changeMonth: true,
        changeYear: true,
        minDate:0,
    });

    jQuery(function($){
        if("km" == "<?php echo e(Fun::lang()); ?>"){
            $.datepicker.regional['km'] = {
                closeText: 'រួច​រាល់',
                prevText: 'ថយ​ក្រោយ',
                nextText: 'ទៅ​មុខ',
                currentText: 'ថ្ងៃ​នេះ',
                monthNames: ['ខែ​មករា','ខែ​កុម្ភៈ','ខែ​មិនា','ខែ​មេសា','ខែ​ឧសភា','ខែ​មិថុនា',
                'ខែ​កក្កដា','ខែ​សីហា','ខែ​កញ្ញា','ខែ​តុលា','ខែ​វិច្ឆិកា','ខែ​ធ្នូ'],
                monthNamesShort: ['មក', 'កុ', 'មិនា', 'មេ', 'ឧស', 'មិថុ',
                'កក្ក', 'សី', 'កញ្ញា', 'តុលា', 'វិច្ឆិ', 'ធ្នូ'],
                dayNames: ['ថ្ងៃ​អាទិត្យ', 'ថ្ងៃ​ចន្ទ', 'ថ្ងៃ​អង្គារ', 'ថ្ងៃ​ពុធ', 'ថ្ងៃ​ព្រហស្បត្តិ៍', 'ថ្ងៃ​សុក្រ', 'ថ្ងៃ​សៅរ៍'],
                dayNamesShort: ['អា', 'ចន្ទ', 'អង្គ', 'ពុធ', 'ព្រហ', 'សុ', 'សៅរ៍'],
                dayNamesMin: ['អា','ច','អ','ពុ','ព្រ','សុ','ស'],
                weekHeader: 'Wk',
                dateFormat: 'dd/mm/yy',
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ''};
                $.datepicker.setDefaults($.datepicker.regional['km']);
        }
    });

    $('select').select2();
    window.setTimeout(function() {
        $(".alert-message").fadeOut({
            opacity: 0
        }, 15000).hide('slow');
    }, 4000);

    $("div.alert-message").on("click", "button.close", function() {
        $(this).parent().fadeOut({
            opacity: 0
        }, 15000).hide('slow');
    });
    $('.bg-loading').hide();
    // $(document).on({
    //     ajaxStart: function() {
    //         $('.bg-loading').show();
    //     },
    //     ajaxStop: function() {
    //         $('.bg-loading').hide();
    //     }

    // });

    $(document).on('click','#vehicle3',function(){
        var status = 0 ;
        if ($(this).prop('checked')==true){
            status = 1  ;
        }

        $.ajax({
            type: 'POST',
            url: '<?php echo e(route("back_bage")); ?>',
            dataType:'json',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                status: status,
            },
            success: function (data) {
            }
        });
    });
</script>
<script>
    $(document).ready(function(){
        $('.dropdown-submenu a.test').on("click", function(e){
            $('.dropdown-submenu a.test').find('ul').hide();
            $(this).next('ul').toggle();
            e.stopPropagation();
            e.preventDefault();
        });
        $('.dropdown-submenu a.test').on("mouseout",'ul', function(e){
            $(this).next('ul').toggle();
            e.stopPropagation();
            e.preventDefault();
        });
    });
</script>
<script>
    /*===============================================
    =================================================
                    mmenu
    =================================================
    ================================================= */
    $(function() {
        var asset = window.location.href;
        $(".menu li a").each(function() {
            if (asset == (this.href)) {
                $(this).closest(".menu li a").addClass("current-menu");
            }
        });
    });
    // MMenu
    var $menu = $('#my-menu');
    var $btnMenu = $('.btn-menu');
    var $img = $('.btn-menu img');
    $menu.mmenu({
    counters: true,
    navbar: {
      title: "Menu"
    },
    extensions: ["pageshadow", "effect-zoom-menu", "effect-zoom-panels"],
    offCanvas: {
      position  : "left",
      zposition : "back"
    }
    });
    var api = $menu.data("mmenu");

    $btnMenu.click(function() {
    api.open();
    });
    api.bind('opening', function() {
    $img.attr('src', 'https://s3-us-west-2.amazonaws.com/s.cdpn.io/162656/arrows_remove.svg');
    });

    api.bind('closing', function() {
    $img.attr('src', 'https://s3-us-west-2.amazonaws.com/s.cdpn.io/162656/arrows_hamburger.svg');
    });
    $menu.find( ".mm-next" ).addClass("mm-fullsubopen");

    /*-------------end of mmenu---------------
    -----------------------------------------*/

    function KHCurrenc(amount){
        if(amount % 100 >= 50)
            return (amount - amount % 100) + 100;
        else
            return amount - amount % 100;
    }
    function KHCurrencyNeg(amount){
        let amount1 = amount.replace('-','');
        if(parseFloat(amount1) < 50){
            return 0;
        }else if(parseFloat(amount1) >= 50 && parseFloat(amount1) < 100){
            return '-'+100;
        }else{
            return parseFloat(amount1.slice(-2)) < 50 ? '-'+(parseFloat(amount1.slice(0,amount1.length - 2)))+'00' : '-'+(parseFloat(amount1.slice(0,amount1.length - 2)) + 1)+'00';
        }
    }
    function alertErrorFormController(xhr, this_ = '') {
        let error1 = xhr.responseJSON.errors;
        let error2 = xhr.responseJSON.message;
        let text_err = '<ul class="text-left" style="list-style-type: none">';

        $(document).find('input').removeClass('shadow-red');
        $(document).find('select').removeClass('shadow-red');
        $(document).find('.select2-container').removeClass('shadow-red');

        if (error1) {
            $.each(error1, function (i, val) {
                let string = val[0].replace('The ', '');
                let fletter = string.substr(0, 1);
                let store = string.replace(fletter, fletter.toUpperCase());
                store = store.replace('field is required.', 'is required');

                text_err += '<li><span class="fa fa-caret-right text-danger"></span> ' + store + '</li>';
                i = i.split(".").pop();
                let select = $(document).find('select[name=' + i + ']');
                let select_arr = $(document).find('select[name=\'' + i + '[]\']');
                let text = $(document).find('input[name=' + i + ']');
                if (text.val() !== undefined) {
                    text.addClass('shadow-red');
                }
                if (select_arr.val() !== undefined) {
                    select_arr.closest('div').find('.select2-container').addClass('shadow-red');
                }
                if (select.val() !== undefined) {
                    select.addClass('shadow-red');
                    select.closest('div').find('.select2-container').addClass('shadow-red');


                }
            });
        }
        if (error2 && !text_err) {
            error2 = error2.replace('The given data was invalid.', '<?php echo e(__('administrator.The given data was invalid.')); ?>')
            text_err += '<li><span class="fa fa-caret-right text-danger"></span> ' + error2 + '</li>';
        }

        text_err += '</ul>';
        if(xhr.responseJSON.exception == "Exception"){
            text_err = error2;
        }
        $.alert({
            title: '',
            content: text_err,
            icon: 'fa fa-exclamation-triangle',
            type: 'orange',
            useBootstrap: false,
            boxWidth: '25%',
            theme: 'modern',
            buttons: {
                close: {
                    text: '<?php echo e(__('administrator.close')); ?>',
                    btnClass: 'btn btn-warning',
                }
            }
        });
        if (this_) {
            this_.buttons.submit.enable();
        }
        let form_btn = $('.form-button');
        if(form_btn.length){
            form_btn.attr('disabled',false);
        }
    }

</script>



<script>
    $(document).ready(function () {
        $(document).on('click','.bt_pending', function(){
            main_update_to_pendding(this)
        });
        $(document).on('click','.bt_cencel', function(){
            update_to_cancel(this);
        });
        $(document).on('click','.bt_return_to_shop',function(){
            update_return_to_shop(this);
        });
        $(document).on('click','.return_to_inpro',function(){
            update_to_proccess(this);
        });
        $(document).on('click','.bt-delete',function () {
            deleteBox(this);
        });
        $(document).on('click','.approve_return_to_shop',function () {
            approveReturnShop(this);
        });
        $(document).on('click','.bt-print',function () {
            printBox(this);
        });
        $(document).on('click', '.bt_add_to_stock', function() {
            returnToOrder(this);
        });
        $(document).on('keyup','input[name="currency_rial"],input[name="currency_usd"],.aba_pay_to',function(){
            caculate();
        });
        $(document).on('click','.show-history',function(){
            let id = $(this).data('id');
            let box_code = $(this).data('box_code');
            let title = box_code;
            if(!title){
                let data = $('#datatable_history').DataTable();
                let title = data.row($(this).closest('tr')).data().box_code;
            }
            $.confirm({
                columnClass:'col-md-12',
                content: function () {
                    var self = this;
                    return $.ajax({
                        url: '<?php echo e(route('history_box_show')); ?>',
                        method: 'get',
                        data:{
                            id:id
                        }
                    }).done(function (response) {
                        self.setContent(response);
                        self.setTitle('<?php echo e(__('administrator.history')); ?>' + ' '+title);
                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                }
            });
        });
        var price;
        $(document).on('click','.edit_price_of_car', function(){
            let table_id = $(this).closest('table').attr('id');
            var id = $(this).data('export_id');
            price= '';
            price = $(this).data('price');
            var delivery_option = $(this).data('delivery_option');
            var currency = $(this).data('currency');
            var taxi_status = $(this).data('taxi_status');
            var taxi_shop_fee = $(this).data('taxi_shop_fee');
            var taxi_cust_fee = $(this).data('taxi_cust_fee');
            var taxi_number = $(this).data('taxi_number');
            var total_riel = $(this).data('total_riel');
            var total_dollar = $(this).data('total_dollar');
            var extra_fee = $(this).data('extra_fee');
            var user_currency = $(this).data('user_currency');
            var extra_fee_type = $(this).data('extra_fee_type');
            var driver_note = $(this).data('driver_note');
            var amount_pay_to = $(this).data('amount_pay_to');
            var pay_to = $(this).data('pay_to');
            let rate = $(this).data('rate');
            let taxi_fee_symbol = $(this).data('taxi_fee_symbol');
            var option = '';
            var selected = '';
            var taxi_price = '';
            if(taxi_status == 1){
                selected = `
                            <option value="1" selected>ហាងចេញ</option>
                            <option value="2">អតិថិជនចេញ</option>`;
                taxi_price = taxi_shop_fee;
            }else if(taxi_status == 2){
                selected = `
                            <option value="1">ហាងចេញ</option>
                            <option value="2" selected>អតិថិជនចេញ</option>`;
                taxi_price = taxi_cust_fee;
            }else{
                selected = `
                            <option value="1">ហាងចេញ</option>
                            <option value="2">អតិថិជនចេញ</option>`;
                taxi_price = '';
            }
            if(extra_fee_type == 0){
                var total_price  = (parseFloat($(this).data('price')));
                selected1 = `<option value="" selected>ថ្លៃសេវាបន្ថែម</option>
                            <option value="1" >ហាងចេញ</option>
                            <option value="2">អតិថិជនចេញ</option>`;
            }else if(extra_fee_type == 1){
                var total_price  = (parseFloat($(this).data('price')));
                selected1 = `<option value="">ថ្លៃសេវាបន្ថែម</option>
                            <option value="1" selected >ហាងចេញ</option>
                            <option value="2"  >អតិថិជនចេញ</option>`;
            }else{
                var total_price  = ( parseFloat( $(this).data('extra_fee'))+parseFloat($(this).data('price')));
                selected1 = `<option value="">ថ្លៃសេវាបន្ថែម</option>
                            <option value="1">ហាងចេញ</option>
                            <option value="2" selected>អតិថិជនចេញ</option>`;

            }
            console.log((total_price.toFixed(2) * rate));
            console.log(KHCurrenc('11'));
            if( user_currency ){
                user_currency  = "Note: " + user_currency ;
            }
            

            if(delivery_option == 'No') {
                option  = `
                            <div class="col-sm-6 col-xs-6" style="display: none;">
                                <div class="form-group">
                                    <select name="extra_fee_type" class="form-control chosen-select"​>
                                        ${selected1}
                                </select>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-6" style="display: none;">
                                <div class="form-group">
                                    <input type="text" name="extra_fee" value="${extra_fee}" class="form-control" placeholder="ថ្លៃសេវាបូកបន្ថែម">
                                </div>
                            </div>
                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                <input type="hidden" value="${currency}" name="currency">
                                <input type="hidden" value="no_taxi" name="status">
                                <input type="text" name="" class="form-control " value="$${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}" readonly>
                                <input type="hidden"  name="total_price"   value="${parseFloat(total_price)}" >
                                <input type="hidden"  name="rate"   value="${rate}" >
                                &nbsp;${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛
                                    <br>
                                <div class="missing">
                                Missing Dollar :<span class="missing_dor"> $${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</span>
                                Missing KH : <span class="missing_riel">${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛</span>
                                </div
                                </div>


                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <div class="form-group">
                                <input type="text" name="currency_usd" class="form-control number-only " value="${ total_riel == 0  && total_dollar == 0 ? 0 : total_dollar }"    step="any">

                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <div class="form-group">
                                <input type="number" name="currency_rial" value="${total_riel}" class="form-control number-only" placeholder="ទទួលបានលុយខ្មែរ" step="any">
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <span> Pay To :    </span>  <br>
                                        <input type="radio" id="Default" ${pay_to == '' ? ' checked ' : ''} name="pay_to" class="pay_to" value="">
                                        <label for="Default">Cash</label>  &nbsp;&nbsp;&nbsp;
                                        <input style="display:none" type="radio" id="delivery" ${pay_to == 'delivery' ? ' checked ' : ''} name="pay_to" class="pay_to" value="delivery">
                                            <label style="display:none" for="delivery">ABA KL</label>

                                        <!--<input type="radio" id="shop" ${pay_to == 'shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="shop">
                                        <label for="shop">ABA Shop</label> &nbsp;&nbsp;&nbsp;

                                        <input type="radio" id="ac_shop" ${pay_to == 'ac_shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="ac_shop">
                                        <label for="ac_shop">ACLEDA Shop</label><br>-->
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12 amount_pay_to_aba" ${pay_to == '' ? 'style="display: none;"' : ''} >
                                <div class="form-group">
                                    <input type="text" class="form-control number-only aba_pay_to" placeholder="ចំនួនទឹកប្រាក់ ($)" name="amount_pay_to_aba" value="${amount_pay_to}">
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <textarea class="form-control" name="driver_note" rows="2" cols="50" placeholder="note" >${driver_note}</textarea>
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <span> ${user_currency}  </span>
                                </div>
                            </div>
                        `;

            }else{
                option  =`
                            <div class="col-sm-6 col-xs-6" >
                                <div class="form-group">
                                    <select name="taxi_status" class="form-control chosen-select"​>
                                    ${selected}
                                </select>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-6" >
                                <div class="form-group">
                                    <div class="input-group">
                                    <input type="hidden" value="${currency}" name="currency">
                                    <input type="hidden" value="have_taxi" name="status">
                                    <input type="number" name="taxi_fee" value="${taxi_price}" class="form-control" step="any" placeholder="តម្លៃសេវាឡាន">
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${taxi_fee_symbol} <span class="caret"></span></button>
                                    </div>
                                </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-xs-6">
                                <div class="form-group">
                                    <input type="text" name="taxi_number" value="${taxi_number}" class="form-control" placeholder="លេខឡាន">
                                </div>
                            </div>

                            <div class="col-sm-6 col-xs-6">
                                <div class="form-group">
                                    <input type="text" name="" value="${delivery_option}" class="form-control" readonly placeholder="លេខឡាន">
                                </div>
                            </div>


                            <div class="col-sm-6 col-xs-6" style="display: none;">
                                <div class="form-group">
                                    <select name="extra_fee_type" class="form-control chosen-select"​>
                                        ${selected1}
                                </select>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-6" style="display: none;">
                                <div class="form-group">
                                    <input type="text" name="extra_fee" value="${extra_fee}" class="form-control" placeholder="ថ្លៃសេវាបូកបន្ថែម">
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                <input type="hidden" value="${currency}" name="currency">
                                <input type="hidden" value="no_taxi" name="status">
                                <input type="text" name="" class="form-control " value="$${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}" readonly>
                                <input type="hidden"  name="total_price"   value="${parseFloat(total_price)}" >
                                <input type="hidden"  name="rate"   value="${rate}" >
                                &nbsp;${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛
                                    <br>
                                <div class="missing">
                                Missing Dollar :<span class="missing_dor"> $${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</span>
                                Missing KH : <span class="missing_riel">${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛</span>
                                </div
                                </div>


                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <div class="form-group">
                                    <input type="text" name="currency_usd" class="form-control number-only" value="${total_riel == 0  && total_dollar == 0 ? 0 : total_dollar}"    step="any">

                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <div class="form-group">
                                <input type="number" name="currency_rial" value="${total_riel}" class="form-control number-only" placeholder="ទទួលបានលុយខ្មែរ" step="any">
                                </div>
                            </div>
                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <span> Pay To :    </span>  <br>
                                        <input type="radio" id="Default" ${pay_to == '' ? ' checked ' : ''} name="pay_to" class="pay_to" value="">
                                        <label for="Default">Cash</label>  &nbsp;&nbsp;&nbsp;
                                        <input style="display:none" type="radio" id="delivery" ${pay_to == 'delivery' ? ' checked ' : ''} name="pay_to" class="pay_to" value="delivery">
                                            <label style="display:none" for="delivery">ABA KL</label>

                                        <!--<input type="radio" id="shop" ${pay_to == 'shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="shop">
                                        <label for="shop">ABA Shop</label> &nbsp;&nbsp;&nbsp;

                                        <input type="radio" id="ac_shop" ${pay_to == 'ac_shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="ac_shop">
                                        <label for="ac_shop">ACLEDA Shop</label><br>-->

                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12 amount_pay_to_aba" ${pay_to == '' ? 'style="display: none;"' : ''} >
                                <div class="form-group">
                                    <input type="text" class="form-control number-only aba_pay_to" placeholder="ចំនួនទឹកប្រាក់ ($)" name="amount_pay_to_aba" value="${amount_pay_to}">
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <textarea class="form-control" name="driver_note" rows="2" cols="50" placeholder="note" >${driver_note}</textarea>
                                </div>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <span> ${user_currency}   </span>
                                </div>
                            </div>
                            `;

            }

            $.confirm({
                title: 'កែសម្រួលតម្លៃ!',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'purple',
                content: `
                    <form action="" class="formName">
                        <div class="row">
                            <input type="hidden" value="${id}" name="id">
                            ${option}
                        </div>
                    </form>`,
                buttons: {


                    cancel: {
                        text: 'បិទ',
                        btnClass: 'btn-red bt-cancel',
                        function () {
                        },
                    },
                    យល់ព្រម: function () {

                        var status                      = this.$content.find('input[name="status"]').val();
                        var driver_note                 = this.$content.find('textarea[name="driver_note"]').val();
                        var amount_pay_to_aba           = this.$content.find('input[name="amount_pay_to_aba"]').val();
                        let pay_to                      = $('input[name="pay_to"]:checked').val();
                        var taxi_status                 = this.$content.find('select[name="taxi_status"]').val();
                        var taxi_fee                    = this.$content.find('input[name="taxi_fee"]').val();
                        var taxi_number                 = this.$content.find('input[name="taxi_number"]').val();
                        var rate                        = this.$content.find('input[name="rate"]').val();
                        var currency_usd                = this.$content.find('input[name="currency_usd"]').val();
                        var currency_rial               = this.$content.find('input[name="currency_rial"]').val();
                        var extra_fee                   = this.$content.find('input[name="extra_fee"]').val();
                        var extra_fee_type              = this.$content.find('select[name="extra_fee_type"]').val();
                        var id              = this.$content.find('input[name="id"]').val();

                        if(pay_to){
                            if( (pay_to == 'delivery'||pay_to == 'ac_shop') &&  (amount_pay_to_aba < 0 || amount_pay_to_aba == '')){
                                $.alert('provide a valid Amount PayTo');
                                return false;
                            }
                        }
                        let over = false;
                        let overpaid = false;
                        let missing_dor = $('body .missing_dor').text().replace('$','');
                        let missing_riel= $('body .missing_riel').text().replace('៛','');
                        let total_missing = parseFloat(missing_riel);
                        let message = "Sorry You Pay Not Engough";
                        if(total_missing != 0){
                            //Pay less than 10 dollars || ខ្វះ 500 ៛
                            if(total_missing > 1){
                                over = true;
                            }
                            if(total_missing < -1){
                                overpaid = true;
                            }
                        }
                        if(over == true){
                            $.alert({
                                title: 'Pay',
                                content: message,
                                type: 'red',
                            });
                            return false;
                        }
                        if(overpaid == true){
                            $.alert({
                                title: 'Pay',
                                content: 'You have overpaid',
                                type: 'red',
                            });
                            return false;
                        }

                        form = new FormData();
                        form.append('_token', "<?php echo e(csrf_token()); ?>");

                        form.append('status', status);
                        form.append('driver_note', driver_note);
                        form.append('amount_pay_to_aba', amount_pay_to_aba);
                        form.append('pay_to', pay_to);
                        form.append('taxi_status', taxi_status);
                        form.append('taxi_fee', taxi_fee);
                        form.append('taxi_number', taxi_number);
                        form.append('currency_usd', currency_usd);
                        form.append('currency_rial', currency_rial);
                        form.append('extra_fee', extra_fee);
                        form.append('extra_fee_type', extra_fee_type);
                        form.append('id', id);
                        form.append('rate', rate);

                        $.ajax({
                                type: 'POST',
                                url: '<?php echo e(route("deliveryActioneditPrice")); ?>',
                                data: form,
                                cache: false,
                                contentType: false,
                                processData: false,
                                async: false,
                                success: function (response) {

                                    if (response == 200) {
                                        $('#'+table_id).DataTable().ajax.reload();
                                        $(document).find('.bt-cancel').trigger('click');
                                    }
                                },
                                error : function (xhr, status, error) {
                                    alertErrorFormController(xhr);
                                    console.log(xhr);
                                }
                            });
                            return false;
                    },

                },
                onContentReady: function () {
                    // bind to events
                    var jc = this;
                    this.$content.find('form').on('submit', function (e) {
                        // if the user submits the form by pressing enter in the field.
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click'); // reference the button and click it
                    });
                    caculate();
                    if($('input[name="amount_pay_to_aba"]').val()){
                        $('input[name="currency_usd"]').val(0);
                        $('input[name="currency_usd"]').attr('readonly',true);
                    }
                    $(document).on('keypress', '.number-only', function(e) {
                        if (isNaN(this.value + "" + String.fromCharCode(e.charCode))) return false;
                    });

                    $('input[type=radio][name=pay_to]').change(function() {

                        if($(this).val()){
                            $('.amount_pay_to_aba').show();
                            $('input[name="currency_usd"]').val(0);
                            $('input[name="currency_usd"]').attr('readonly',true);
                        }
                        else{
                            $('.amount_pay_to_aba').hide();
                            $('input[name="amount_pay_to_aba"]').val(0);
                            $('input[name="currency_usd"]').val(0);
                            $('input[name="currency_usd"]').attr('readonly',false);
                        }

                    });
                }
            });
        });
    });
    function main_update_to_pendding(obj){
        var export_id = $(obj).data('export_id');
        var from_status = $(obj).data('status');
        let table = $(obj).closest('table').attr('id');
        $.confirm({
            title: 'កញ្ចប់នឹងមិនជោកជ័យ!',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
            content: `
                <form action="" class="formName">
                    <div class="form-group">
                        <div class="row">


                            <div class="col-sm-12 col-xs-12">
                                <?php echo Form::text('other',null, array('placeholder' => 'ផ្សេងៗ','class' => 'form-control')); ?>

                            </div>
                        </div>
                    </div>
                </form>`,
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    var reason = this.$content.find('input[name="reason"]:checked').val();
                    var other = this.$content.find('input[name="other"]').val();
                    if(!reason){
                        reason = '';
                        if(!other){
                            $.alert('មិនយកដោយសារមូលហេតុអ្វី?');
                            other = '';
                            return false;
                        }
                    }
                    var why = reason +' ' + other;
                    update_to_pending(export_id,from_status,why,table);
                },

            },
        });
    }
    function update_to_pending(export_id,from_status,why,table){
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('update-to-pending-ajax')); ?>",
            data: {
                _token:'<?php echo e(csrf_token()); ?>',
                export_id,
                from_status,
                why
            },
            dataType: "JSON",
            success: function (response) {
                if(response.status == 200){
                    $('#'+table).DataTable().ajax.reload(null,false);
                }
            }
        });
    }
    function update_to_cancel(obj){
        var  export_id = $(obj).data('export_id');
        var status = $(obj).data('status');
        let table = $(obj).closest('table').attr('id');
        $.confirm({
            title: 'កញ្ចប់នឹងមិនយកទេ!',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'orange',
            content: `
                <form action="" class="formName">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                <?php echo Form::text('reason',null, array('placeholder' => 'មូលហេតុ','class' => 'form-control')); ?>

                            </div>
                        </div>
                    </div>
                </form>`,
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    var reason = this.$content.find('input[name="reason"]').val();
                    if(!reason){
                        $.alert('មិនយកដោយសារមូលហេតុអ្វី?');
                        return false;
                    }
                    var why = reason;
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('update-to-cancel-ajax')); ?>",
                        data: {
                            _token:'<?php echo e(csrf_token()); ?>',
                            export_id,
                            from_status:status,
                            why
                        },
                        dataType: "JSON",
                        success: function (response) {
                            if(response.status == 200){
                                $('#'+table).DataTable().ajax.reload(null,false);
                            }
                        }
                    });
                },

            },
        });
    }
    function update_return_to_shop(obj){
        var export_id = $(obj).data('export_id');
        let from_status = $(obj).data('status');
        let data = $('#datatable_show').DataTable();
        let table = $(obj).closest('table').attr('id');
        let type = $(obj).data('type');
        let reason = $(obj).data('reason')?$(obj).data('reason'):'';

        $.confirm({
            title: 'ត្រឡប់ទៅកាន់ហាងវិញ',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'purple',
            content: '<textarea class="form-control" id="note" name="note" rows="2">'+reason+'</textarea>',
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    let note = this.$content.find("textarea[name='note']").val();
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('update-to-return-to_shop-ajax')); ?>",
                        data: {
                            _token:'<?php echo e(csrf_token()); ?>',
                            export_id,
                            from_status,
                            note,
                            type,
                        },
                        dataType: "JSON",
                        success: function (response) {
                            if(response.status == 200){
                                if(type == "request"){
                                    $.alert("Request Return to Shop Successfully.")
                                }
                                $('#'+table).DataTable().ajax.reload(null,false);
                            }
                        }
                    });
                },

            },
        });
    }
    function update_to_proccess(obj){
        var export_id = $(obj).data('export_id');
        let from_status = $(obj).data('status');
        let table = $(obj).closest('table').attr('id');
        let data = $('#datatable_show').DataTable();
        $.confirm({
            title: '',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'purple',
            content: 'ត្រឡប់កំពុង​ដំណើរការវិញ​!',
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('update-to-return-proccess-ajax')); ?>",
                        data: {
                            _token:'<?php echo e(csrf_token()); ?>',
                            export_id,
                            from_status,
                        },
                        dataType: "JSON",
                        success: function (response) {
                            if(response.status == 200){
                                $('#'+table).DataTable().ajax.reload(null,false);
                            }
                        }
                    });
                },

            },
        });
    }
    function renderAssignBox(){
        let can_assign = false;
        $.each($('.checkbox'), function (i, v) {
            if($(this).prop('checked')){
                can_assign = true;
                if($(this).data('status') != 1){
                    return can_assign = false;
                }
            }
        });
        if(can_assign){
            $('.assign_to_driver').css('display','');
        }else{
            $('.assign_to_driver').css('display','none');
        }
    }
    function deleteBox(obj){
        var href = $(obj).data('href');
        var this_ = $(obj);
        let table = $(obj).closest('table').attr('id');
        $.confirm({
            icon: 'fa fa-trash',
            theme: 'modern',
            title: 'Delete!',
            closeIcon: true,
            animation: 'scale',
            type: 'red',buttons: {
                cancel: function () {

                },
                confirm: {
                    text: 'Confirm',
                    btnClass: 'btn-red',
                    keys: ['enter', 'shift'],
                    action: function(){
                        $.ajax({
                            url: href,
                            success: function (response) {
                                if (response.success == true) {
                                    $('#'+table).DataTable().ajax.reload(null,false);
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {

                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        });
    }
    function approveReturnShop(obj){
        var href = $(obj).data('href');
        var this_ = $(obj);
        let table = $(obj).closest('table').attr('id');
        $.confirm({
            icon: 'fa fa-check',
            theme: 'modern',
            title: 'Approve',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',buttons: {
                cancel: function () {

                },
                confirm: {
                    text: 'Confirm',
                    btnClass: 'btn-blue',
                    action: function(){
                        $.ajax({
                            url: href,
                            method:"POST",
                            data:{
                                _token:'<?php echo e(csrf_token()); ?>'
                            },
                            success: function (response) {
                                if (response.success == true) {
                                    $('#'+table).DataTable().ajax.reload(null,false);
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Close',
                                                btnClass: 'btn-red',
                                                action: function () {

                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        });
    }
    function printBox(obj){
        var href = $(obj).data('href');
        $.ajax({
            url: href,
            success: function (data) {
                var content_ = (data);
                $.confirm({
                    title: '',
                    content: content_,
                    boxWidth: '50%',
                    useBootstrap: false,
                    buttons: {
                        close: {
                            text: '<?php echo e(__('administrator.close')); ?>',
                            btnClass: 'button_warning',
                            keys: ['esc'],
                            action: function () {

                            }
                        },
                        print_without_fee: {
                            text: '<?php echo e(__('administrator.print_with_out_fee')); ?>',
                            btnClass: 'button_info button_primary',
                            action: function () {
                                $('.container1').printThis({
                                    loadCSS: "<?php echo e(asset('assets/print_this/pos-invoice.css')); ?>",
                                    beforePrint: function () {
                                        $('#delivery_fee').css('display','none');
                                    },
                                    afterPrint: function () {


                                    }
                                });
                            }
                        },
                        print: {
                            text: '<?php echo e(__('administrator.print')); ?>',
                            btnClass: 'button_info button_info_',
                            keys: ['enter'],
                            action: function () {
                                $('.container1').printThis({
                                    loadCSS: "<?php echo e(asset('assets/print_this/pos-invoice.css')); ?>",
                                    beforePrint: function () {
                                        $('#delivery_fee').css('display','');
                                    },
                                    afterPrint: function () {


                                    }
                                });
                            }
                        },
                    }
                });
                $('.loading_btn').hide();
                $('input[type=submit]').show();
                $('button[type=submit]').show();
            }
        });
    }
    function returnToOrder(obj){
        var  export_id = $(obj).data('export_id');
        $('input[name="export_id_1"]').val(export_id);
        let table = $(obj).closest('table').attr('id');
        $.confirm({
            title: false,
            content: '<?php echo e(__('administrator.move_to_stock')); ?> ',
            buttons: {
                yes: {
                    action: function () {
                        $.ajax({
                            type: "POST",
                            url: "<?php echo e(route('add_to_stock')); ?>",
                            data: {
                                _token:'<?php echo e(csrf_token()); ?>',
                                export_id_1:export_id,
                            },
                            success: function (response) {
                                $('#'+table).DataTable().ajax.reload(null,false);
                            }
                        });
                    }
                },
                no: {
                    action: function () {

                    }
                },
            }
        });
    }
    function caculate(){
        let pay_dol = $('input[name="currency_usd"]').val();
        let pay_riel = $('input[name="currency_rial"]').val();
        let aba_pay = $('.aba_pay_to').val() ? $('.aba_pay_to').val() : 0;

        let rate = $('input[name="rate"]').val();
        let convert_to_dol = parseFloat(pay_riel ? pay_riel : 0) / rate;
        let total_paid = parseFloat(pay_dol ? pay_dol : 0) + convert_to_dol + parseFloat(aba_pay ? aba_pay : 0);
        let price = $('input[name="total_price"]').val();
        let missing = price - (total_paid);
        $('.missing_dor').text('$ '+missing.toFixed(2));
        $('.missing_riel').text(KHCurrenc(''+missing.toFixed(2)*rate)+'៛');
    }
    function commasForNumber(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
</script>

</body>

<?php session::put('success',''); session::put('danger',''); session::put('warning',''); ?>

</html>
<?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/layouts/master.blade.php ENDPATH**/ ?>