<?php $__env->startSection('content'); ?>
<style>
    .datatables-exportable th{
        padding: 2px !important;
        vertical-align: middle !important;
    }
    #datatable_ thead th{
        vertical-align: middle;
        text-align: center;
        padding: 3px;
        border: 1px solid white;
    }
</style>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active">Customer Invoice</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                <div class="form-search">
                    <div class="col-md-2">
                        <div class="form-group"><label>Shop Name</label>
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div>
                                <?php echo Form::select('merchant', $merchant, null, ['class' => 'form-control merchant']); ?>


                             </select>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group"><label>Status</label>
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div>
                                <select name="status"   class="form-control status chosen-select">
                                 <option value="pay">  <?php echo e(__('administrator.pay')); ?> </option>
                                 <option value="paid">  <?php echo e(__('administrator.paid')); ?> </option>

                             </select>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group"><label>Verify</label>
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div>
                                <select name="verify" class = 'form-control verify' >
                                    <option value="">All</option>
                                    <option value="verify">Verify</option>
                                    <option value="not_verify">Not Verify</option>
                                  </select>

                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group"><label><?php echo e(__('administrator.from')); ?></label>
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div>
                                <?php echo Form::text('from_date',date('Y-m-d',strtotime("-1 MONTH")), array('placeholder' => __('administrator.from'),'class' => 'form-control from_date date_picker')); ?>


                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group"><label><?php echo e(__('administrator.to')); ?></label>
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div>
                                    <?php echo Form::text('to_date',date('Y-m-d'), array('placeholder' => __('administrator.to'),'class' => 'form-control to_date date_picker')); ?>


                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label style="opacity: 0"><?php echo e(__('administrator.to')); ?></label>
                            <input type="button" value="<?php echo e(__('administrator.search')); ?>" class="btn btn-primary form-control filter-payment">
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <div class="wrapper-table ">
        <table id="datatable_" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 5%"><?php echo e(__('administrator.no')); ?></th>
                    <th rowspan="2"><?php echo e(__('administrator.verify_by')); ?></th>
                    <th rowspan="2"><?php echo e(__('administrator.date')); ?></th>
                    <th rowspan="2"><?php echo e(__('administrator.create_users')); ?></th>
                    <th rowspan="2">Paid Date</th>
                    <th rowspan="2">Paid By</th>
                    <th rowspan="2"><?php echo e(__('administrator.shop_name')); ?></th>
                    <th colspan="2" style="width: 20%"><?php echo e(__('administrator.account_name')); ?> / <?php echo e(__('administrator.bank_account')); ?></th>
                    <th rowspan="2"><?php echo e(__('administrator.invoice_payment')); ?></th>
                    <th rowspan="2"><?php echo e(__('administrator.pay_to_shop')); ?></th>
                    <th rowspan="2"><?php echo e(__('administrator.action')); ?></th>
                </tr>
                <tr>
                    <th>ដុល្លារ</th>
                    <th>រៀល</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/gh/linways/table-to-excel@v1.0.4/dist/tableToExcel.js"></script>
<script type="text/javascript">

    $(document).on('click','.verify_by',function(){
        let href =  $(this).data('href');
        let this_  = $(this);
        $.confirm({
            icon: 'fa fa-check',
            theme: 'modern',
            title:"Verify",
            closeIcon: true,
            animation: 'scale',
            // content:"test",
            type: 'blue',
            buttons: {
                cancel: function () {
                    //close
                },
                formSubmit: {
                    text: 'verify',
                    btnClass: 'btn-blue',
                    action: function () {
                        $.ajax({
                            url: href,
                            type: 'PATCH',
                            dataType: 'json',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                            },
                            success: function (response) {
                                if (response.success == 200) {
                                    $('.' + response.class).html(response.verify_by);
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {

                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                },
            },
        });





    });




    let data_table = '';
    $(document).on('click','.bt-excel',function () {
        let total_dollar = 0;
        let total_riel = 0;
        let tbody = '';
        let tfoot = '';
        let total_dollar_spb = 0;
        $('.tbody  > tr').each(function(index, tr) {
            var tr = $(this).closest('tr');
            var row = data_table.row(tr);
            var data = row.data();
            let riel = (data.pay_amount.split('និង').pop().split('៛')[0].replace(/,/g, ''));
            let dollar = (data.pay_amount.split('$').pop().split('និង')[0].replace(/,/g, ''));
            let dollar_spb = 0;
            total_dollar += parseFloat(dollar);
            if(parseFloat(dollar)<0){
                dollar_spb = Math.abs(parseFloat(dollar));
            }
            total_dollar_spb += dollar_spb;
            total_riel += parseFloat(riel);
            tbody +=
                    `<tr>
                        <td style="font-family:Khmer OS Content;">${index + 1}</td>
                        <td style="font-family:Khmer OS Content;">${data.shop}</td>
                        <td style="font-family:Khmer OS Content;">${data.account_usd}</td>
                        <td style="font-family:Khmer OS Content;">${data.account_kh}</td>
                        <td style="font-family:Khmer OS Content;"> ${dollar>0?'$ '+dollar:''}</td>
                        <td style="font-family:Khmer OS Content;">${riel>0?commasForNumber(riel)+' ៛':''} </td>
                        <td style="font-family:Khmer OS Content;">${dollar_spb?'$ '+dollar_spb:''}</td>
                        <td style="font-family:Khmer OS Content;"></td>
                    </tr>`;
                });

                tfoot +=    `
                    <tr>
                        <th style="font-family:Khmer OS Content;" colspan="4">សរុបលុយត្រូវវេជូនហាង</th>
                        <th style="font-family:Khmer OS Content;">$ ${total_dollar.toFixed(2)}</th>
                        <th style="font-family:Khmer OS Content;">${commasForNumber(total_riel)} ៛</th>
                        <th style="font-family:Khmer OS Content;">$ ${total_dollar_spb}</th>
                    </tr>`;
        var table = `
        <div id="tblData">
            <style>
                #tblData table tr th,#tblData table tr td{
                    text-align:center;
                    font-family: Khmer os content;font-size:13px !important;font-weight: bold;
                }
            </style>
            <span style="font-family:Khmer OS Content;">Date : <?php echo e(date("Y-m-d")); ?></span>
            <table border="1px">
                <tbody>
                    <tr>
                        <th class="font-weight-bold" style="font-family:Khmer OS Content !important;" rowspan="2" width="5%" >ល.រ</th>
                        <th style="font-family:Khmer OS Content !important;" rowspan="2" width="10%">ឈ្មោះហាង</th>
                        <th style="font-family:Khmer OS Content !important;" colspan="2" width="20%">គណនី</th>
                        <th style="font-family:Khmer OS Content !important;" colspan="2" width="20%">ប្រាក់ត្រូវទូទាត់</th>
                        <th style="font-family:Khmer OS Content !important;" rowspan="2" width="10%">ហាងបង់ត្រឡប់</th>
                        <th style="font-family:Khmer OS Content !important;" rowspan="2" width="10%">ហត្ថលេខា</th>
                    </tr>
                    <tr>
                        <th style="font-family:Khmer OS Content;" width="20%">ដុល្លារ</th>
                        <th style="font-family:Khmer OS Content;" width="20%">រៀល</th>
                        <th style="font-family:Khmer OS Content;" width="20%">ដុល្លារ</th>
                        <th style="font-family:Khmer OS Content;" width="20%">រៀល</th>
                    </tr>
                </tbody>

                <tbody>
                    ${tbody}
                </tbody>

                <tbody>
                    ${tfoot}
                </tbody>
            </table>
        </div>

                `;
        let shop_id  = $('.merchant').val();
        let status  = $('.status').val();
        let to_date  = $('.to_date').val();
        let from_date  = $('.from_date').val();
        let verify  = $('.verify').val();
        let per_page = $('select[name=datatable__length] :selected').val();
        let route = '<?php echo e(route('clear-invoice-export')); ?>?shop_id='+shop_id+'&status='+status+'&to_date='+to_date+'&from_date='+from_date+'&verify='+verify+'&per_page='+per_page;
        $.confirm({
            columnClass:'xl',
            title: '',
            content: function () {
                var self = this;
                return $.ajax({
                    url: route,
                    dataType: 'json',
                    method: 'GET'
                }).done(function (response) {
                    self.setContent(response.view);
                }).fail(function(){
                    self.setContent('Something went wrong.');
                });
            },
            buttons: {
                cancel: function () {

                },
                printThis: {
                    text: 'Print',
                    btnClass: 'btn-blue',
                    action: function() {
                        document.title='Report-<?php echo e(date("d-m-Y")); ?>';
                        $('#tblData').printThis({
                            beforePrint: function () {

                            },
                            afterPrint: function () {

                            }
                        });
                    },
                },
                somethingElse: {
                    text: 'Excel',
                    btnClass: 'btn-success',
                    keys: ['enter', 'shift'],
                    action: function() {
                        window.open(route+'&export_excel=export', '_blank');
                    },
                },
            }
        });
        //  $.confirm({
        //     title: '',
        //     content: table,
        //     columnClass:'xl',
        //     buttons: {
        //         cancel: function () {

        //         },
        //         printThis: {
        //             text: 'Print',
        //             btnClass: 'btn-blue',
        //             action: function() {
        //                 document.title='Report-<?php echo e(date("d-m-Y")); ?>';
        //                 $('#tblData').printThis({
        //                     beforePrint: function () {

        //                     },
        //                     afterPrint: function () {

        //                     }
        //                 });
        //             },
        //         },
        //         somethingElse: {
        //             text: 'Excel',
        //             btnClass: 'btn-success',
        //             keys: ['enter', 'shift'],
        //             action: function() {
        //                 let shop_id  = $('.merchant').val();
        //                 let status  = $('.status').val();
        //                 let to_date  = $('.to_date').val();
        //                 let from_date  = $('.from_date').val();
        //                 let verify  = $('.verify').val();
        //                 let per_page = $('select[name=datatable__length] :selected').val();
        //                 let route = '<?php echo e(route('clear-invoice-export')); ?>?shop_id='+shop_id+'&status='+status+'&to_date='+to_date+'&from_date='+from_date+'&verify='+verify+'&per_page='+per_page;
        //                 window.open(route, '_blank');
        //                 // let table = $("#tblData");
        //                 // TableToExcel.convert(table[0], {
        //                 //     name: `Report-<?php echo e(date("d-m-Y")); ?>.xlsx`,
        //                 //     sheet: {
        //                 //         name: 'Report-<?php echo e(date("d-m-Y")); ?>'
        //                 //     },
        //                 // });
        //                 //  tableToExcel('tblData', 'testing');
        //             },
        //         },
        //     }
        // });
    });


    // var tableToExcel = (function() {

    //     var uri = 'data:application/vnd.ms-excel;base64,'
    //       , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table>{table}</table></body></html>'
    //       , base64 = function(s) { return window.btoa(unescape(encodeURIComponent(s))) }
    //       , format = function(s, c) { return s.replace(/{(\w+)}/g, function(m, p) { return c[p]; }) }
    //     return function(table, name) {
    //       if (!table.nodeType) table = document.getElementById(table)
    //       var xlsx = {worksheet: name || 'Worksheet', table: table.innerHTML}
    //       window.location.href = uri + base64(format(template, xlsx))
    //     // var a = document.createElement('a');
    //     // a.href = uri + base64(format(template, xlsx));
    //     // a.download = name+'.xlsx';
    //     // a.click();
    //     }
    //   })()


    $(document).on('click','.bt_done',function(){
        var id  =   $(this).data('id');
        $.confirm({
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
            title: '<?php echo e(__("administrator.successful")); ?>',
            content: '',
            buttons: {

                <?php echo e(__("administrator.cancel")); ?>: function () {

                },
                <?php echo e(__("administrator.done")); ?>: function () {
                    location.href = "/nso/pay-later/"+id;
                },
            }
        });

    });

    // $(document).on('change', ['.merchant','.status'], function(){
    //     dataTableAjax();
    // });
    $(document).on('click','.filter-payment',function(){
        dataTableAjax();
    });

    $(document).ready(function(){
        dataTableAjax();
    });
    function dataTableAjax(){
        let shop_id  = $('.merchant').val();
        let status  = $('.status').val();

        let to_date  = $('.to_date').val();
        let from_date  = $('.from_date').val();

        let verify  = $('.verify').val();

        $('#datatable_').DataTable().destroy();
        data_table = $('#datatable_').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url: "<?php echo e(route('clear-invoice.index')); ?>",
                data:{
                    shop_id:shop_id,
                    status:status,
                    to_date:to_date,
                    from_date:from_date,
                    verify:verify,
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex','searchable':false},
                    {data: 'verify_by1'},
                    {data: 'date',name:'nso007_invoice_payment.date'},
                    {data: 'create_by.name',name:'create_by.name'},
                    {data: 'paid_date',name:'nso007_invoice_payment.paid_date'},
                    {data: 'paid_by',name:'nso007_invoice_payment.paid_by'},
                    {data: 'shop','searchable':false},
                    {data: 'account_usd','searchable':false},
                    {data: 'account_kh','searchable':false},
                    {data: 'invoice_payment',name:'nso007_invoice_payment.invoice_payment'},
                    {data: 'pay_amount','searchable':false},
                    {data: 'action','searchable':false},
                ],
            "initComplete": function (settings, json) {
            }
        });

        $(document).find('.dataTables_filter').prepend(`
                <label >
                    <a href="#" class="btn_sm button_primary bt-excel" data-id="2">Excel <i class="fa fa-file-excel-o" aria-hidden="true"></i> </a>
                </label>&nbsp;&nbsp; `);
    }


</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/clear_inovice/index.blade.php ENDPATH**/ ?>