<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"><?php echo e(__('administrator.income')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> <?php echo e(__('administrator.income')); ?></h3>
	                </div>
	                <div class="pull-right">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Income')): ?>
                            <a href="<?php echo e(route('income.create')); ?>" class="button_sm button_info"><span class="fa fa-plus"></span> <?php echo e(__('administrator.create_new')); ?></a>
                        <?php endif; ?>
                    </div>
	            </div>
	        </div>
	    </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('administrator.date')); ?></th>
                    <th><?php echo e(__('administrator.account_name')); ?></th>
                    <th><?php echo e(__('administrator.description')); ?></th>
                    <th><?php echo e(__('administrator.reference')); ?></th>
                    <th><?php echo e(__('administrator.amount')); ?></th>
                    <th><?php echo e(__('administrator.created_by')); ?></th>
                    <th><?php echo e(__('administrator.modify_by')); ?></th>
                    <th><?php echo e(__('administrator.created_at')); ?></th>
                    <th><?php echo e(__('administrator.updated_at')); ?></th>
                    <th><?php echo e(__('administrator.action')); ?></th>
                </tr>
            </thead>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "<?php echo e(__('administrator.search')); ?>:",
            "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
            "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
            "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
            "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
            "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
            "oPaginate": {
                "sFirst": "<?php echo e(__('administrator.first')); ?>",
                "sLast": "<?php echo e(__('administrator.last')); ?>",
                "sNext": "<?php echo e(__('administrator.next')); ?>",
                "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "<?php echo e(route('income.index')); ?>",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'journal_paydate'},
                {data: 'account_name'},
                {data: 'journal_des'},
                {data: 'journal_invoice'},
                {data: 'amount'},
                {data: 'created_by'},
                {data: 'modify_by'},
                {data: 'created_at'},
                {data: 'updated_at'},
                {data: 'action'},
            ],

        "initComplete": function (settings, json) {
        }
    });

    $(document).on('click','.delete_income',function(){
        var id = $(this).data('id');

        $('#loading').show();

        if ($.confirm({
            title: '<strong style="color:darkcyan;"><?php echo e(__('administrator.are_you_sure')); ?></strong>',
            content: "<b> <?php echo e(__('administrator.are_you_sure')); ?> </b>",
            type: "red",
            buttons: {

                '<?php echo e(__('administrator.cancel')); ?>':
                    {
                        btnClass: 'btn-red',
                        action:
                            function () {
                            }
                    }
                ,
                '<?php echo e(__('administrator.ok')); ?>':
                    {
                        btnClass: 'btn-blue',
                        action:

                            function () {
                                $.ajax({
                                    type: "POST",
                                    dataType: "json",
                                    url: '<?php echo e(route("delete_income")); ?>',
                                    data: {'id': id,  _token: '<?php echo e(csrf_token()); ?>'},
                                    success: function (data) {
                                        $('#loading').hide();
                                        location.reload();

                                    }

                                });
                            }
                    }
            }
        }))

            return false;
    });





</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/accounting/income/index.blade.php ENDPATH**/ ?>