<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#"><?php echo e(__('administrator.dashboard')); ?></a></li>
	  <li class="active"><?php echo e(__('administrator.report_income')); ?></li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                <?php echo Form::open(array('route' => 'reportIncomePrint','method'=>'POST')); ?>

                <div class="form-search">
                    <div class="form-group col-sm-4 col-xs-4">
                            <?php echo Form::text('from_date', date('d-m-Y',strtotime('first day of this month')), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')); ?>

                    </div>
                    <div class="form-group col-sm-4 col-xs-4">
                            <?php echo Form::text('to_date',date('d-m-Y',strtotime('last day of this month')), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')); ?>

                    </div>
                    <div class="form-group col-sm-4 col-xs-4">
                            <?php echo Form::select('account_code', $account_chart, null, ['class' => 'form-control chosen-select']); ?>

                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> Searching</button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> Print</button>
                        </div>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('administrator.date')); ?></th>
                    <th><?php echo e(__('administrator.account_name')); ?></th>
                    <th><?php echo e(__('administrator.description')); ?></th>
                    <th><?php echo e(__('administrator.reference')); ?></th>
                    <th><?php echo e(__('administrator.amount')); ?></th>
                    <th><?php echo e(__('administrator.created_by')); ?></th>
                    <th><?php echo e(__('administrator.modify_by')); ?></th>
                    <th><?php echo e(__('administrator.created_at')); ?></th>
                    <th><?php echo e(__('administrator.updated_at')); ?></th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "<?php echo e(__('administrator.search')); ?>:",
            "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
            "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
            "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
            "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
            "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
            "oPaginate": {
                "sFirst": "<?php echo e(__('administrator.first')); ?>",
                "sLast": "<?php echo e(__('administrator.last')); ?>",
                "sNext": "<?php echo e(__('administrator.next')); ?>",
                "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "<?php echo e(route('getReportIncome')); ?>",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'journal_paydate'},
                {data: 'account_name'},
                {data: 'journal_des'},
                {data: 'journal_invoice'},
                {data: 'amount'},
                {data: 'created_by'},
                {data: 'modify_by'},
                {data: 'created_at'},
                {data: 'updated_at'},
            ],

        "initComplete": function (settings, json) {
        }
    });

    function searching()
    {
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var account_code = $('select[name="account_code"]').val();
        var table = '';
        var account_name = '';
        $.ajax({
            url: "<?php echo e(Route('getReportIncome')); ?>",
            method: "POST",
            dataType: "json",
            data: {
                from_date: from_date,
                to_date: to_date,
                account_code: account_code,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function (data) {
                $.each(data, function(index, val) {

                    str = val.journal_paydate;
                    st2 = str.split("-");
                    yr = st2[0];
                    mo = st2[1];
                    dy = st2[2];
                    var new_date = dy+'-'+mo+'-'+yr;
                    if('<?php echo e(\Globals::check_lang()); ?>' =='en'){
                        account_name = val.account_code+' '+val.acc_name_en;
                    }else{
                        account_name = val.account_code+' '+val.acc_name_km;
                    }
                    table += `
                        <tr>
                            <td>${index+1}</td>
                            <td>${new_date}</td>
                            <td>${account_name}</td>
                            <td>${val.journal_des}</td>
                            <td>${val.journal_invoice}</td>
                            <td>${parseFloat(val.journal_debit).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>${val.created_by}</td>
                            <td>${val.modify_by}</td>
                            <td>${val.created_at}</td>
                            <td>${val.updated_at}</td>
                        </tr>
                    `;
                });
                $('.tbody').empty().append(table);
            }
        });
    }


</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/accounting/report/report-income.blade.php ENDPATH**/ ?>