<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Menu</title>

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css">
	<link rel="stylesheet" href="css/stylemobile.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<style>
    .
	.container{
		background: #f2f2f2;
	}
	.main-Receipt{
		width: 298px;
		height: 215px;
		float: left;
		margin:20px 0px;
		background: #ffffff;
        padding: 8px;
        border: 1px solid #000;
	}
	.main-Receipt .show-Receipt{
		width: 40px;
		float: left;
		margin: 10px;
	}
	.main-Receipt .show-Receipt img{
		margin-bottom: 10px;
		width: 100%;
	}
	.main-Receipt  .desc-logo{
		width: 70%;
		float: right;
		text-align: center;
	}
	.main-Receipt .Receipt-right p,
	.main-Receipt .Receipt-right h4,
	.main-Receipt .desc-logo p,
	.main-Receipt .desc-logo h4{
		margin: 0px;

	}
	.main-Receipt .desc-logo h4{font-size: 10px;font-weight: bold;}
	.border-green{
		width:100%;
		float: left;
		border:1px solid green;
	}
	.main-Receipt .Receipt-right{
		width:35%;
		float: right;
		text-align: right;
		margin-top: 2px;
		margin-right: 10px;
	}
	.main-Receipt .Receipt-left{
		width: 35%;
		float: left;
		margin-top: 6px;
	}
	.main-Receipt  .receipt-img{
		width: 50px;
		height: 50px;
		float: right;
		margin-top: 6px;
	}
	.main-Receipt  .receipt-img img{
		width: 100%;
		height: 100%;
	}
	.main-Receipt .Receipt-left .receipt-desc h4,
	.main-Receipt .Receipt-right h4{margin: 0px;font-size: 10px;font-weight: bold;}
	.main-Receipt .Receipt-left .receipt-desc{
		width: 100%;
		float: left;
		/*margin-left: 10px;*/
	}
	.main-Receipt .desc-logo p,
	.main-Receipt .Receipt-right p,
	.main-Receipt .Receipt-left .receipt-desc h5,
	.main-Receipt .Receipt-left .receipt-desc p{
		margin: 0px;
		font-size: 8.5px;
	}
	.main-Receipt .Receipt-left .receipt-desc h5{font-weight: bold;}
	.main-Receipt .item-product{
		width: 100%;
		float: left;
		margin-top: 2px;
	}
	.main-Receipt .item-product .table{
		margin-bottom: 0px;
	}
	.main-Receipt .item-product .table tbody tr td:last-child,
	.main-Receipt .item-product .table thead tr th:last-child{
		text-align: right;
	}
	.main-Receipt .item-product .table thead tr th,
	.main-Receipt .item-product .table tbody tr th,
	.main-Receipt .item-product .table tbody tr td{
		border-bottom: 1px solid #ddd;
        padding: 0px;
        font-size: 10px;
	}
	.main-Receipt .item-product .table tbody tr th,
	.main-Receipt .item-product .table tbody tr td{font-style: italic;}
	.item-subtotal{
		width: 100%;
		float: left;
	}
	.item-subtotal .item-left{
		width: 50%;
		float: left;
	}
	.item-subtotal .item-right{
		width: 50%;
		float: right ;
		text-align: right;
	}
    .item-subtotal .item-right h5{font-weight: bold;}
    .h5, h5 {
        font-size: 10px;
    }
</style>
<body>
    <?php
    $branch = DB::table('nso007_branch')->find(1);
    $total_price  = 0;
    $total        = 0;
    $delivery_note = '';
?>
<div class="container">
	<div class="main-Receipt">
		<div class="show-Receipt">
            <img src="<?php echo e(asset('images/logo1.png')); ?>" alt="Logo">
		</div>
		<div class="desc-logo">
			<h4><?php echo e($branch->company_name); ?></h4>
			<p> #41,  Sangkat Phnom Penh Thmey,  Khan Sen Sok </p>
			<p><?php echo e($branch->phone); ?></p>
		</div>
		<div class="border-green"></div>
		<div class="receipt-img">
            <?php echo QrCode::size(45)->generate($data[0]->box_code);; ?>


		</div>
		<div class="Receipt-right">
			<h4>នាក់ទូល</h4>
			<p>ទទួល​​​​ : <?php echo e($data[0]->customer_receive); ?></p>
			<p>ទីតាំង​ : <?php echo e($data[0]->location_name); ?></p>
			<p><?php echo e(date('d-m-Y')); ?></p>
		</div>
		<div class="Receipt-left">
			<div class="receipt-desc">
                <h4>ផ្ញើរពី</h4> 
				<h5>ឈ្មោះហាង : <?php echo e($data[0]->shop_name); ?></h5>
				<p>លេខហាង : <?php echo e($data[0]->phone); ?></p>
                <?php
                    if($data[0]->delivery_option != ''){
                        echo  '
                            <p>ផ្ញើរតាម : '.$data[0]->delivery_option.'    </p>
                            ' ;
                    }
                ?> 
				

			</div>
		</div>
		<div class="item-product">
			<table class="table">
			  <thead>
			    <tr>
			      <th scope="col">ល.រ</th>
			      <th scope="col">បរិយាយ</th>
			      <th scope="col">តម្លៃ</th>
			    </tr>
			  </thead>
			  <tbody>

                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $total_price += ($value->price * $value->export_qty )  ;
                ?>
                <tr>
                    <th scope="row"><?php echo e($key+1); ?></th>
                    <td><?php echo e($value->items); ?> (x<?php echo e($value->export_qty); ?>) </td>
                    <td><?php echo e('$'.number_format( $value->price * $value->export_qty,2)); ?></td>
                  </tr>


            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			  </tbody>
			</table>
		</div>
		<div class="item-subtotal">
			<div class="item-left">
				<h5>Delivery Fee: $1.00</h5>
			</div>
			<div class="item-right">
				<h5>Total: $10.00</h5>
			</div>
		</div>
	</div>
</div> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
<script>
	$(document).ready(function(){
		window.print();
	});
	</script>

</body>
</html>
<?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/driver/pick/print-invoice.blade.php ENDPATH**/ ?>