@extends('layouts.master') 
@section('main')
<?php Fun::lang()?>

    @include('layouts.menu-data')
    @php $branch = Auth::user();
        $data = get_data();
    @endphp
        @include('layouts.style-data',['branch'=>$branch])
    @php
       $check = Session::get('chnage'); 
    @endphp
  
    @if($branch->menu_layout == 'top')
    {{--=========================TOP MENU==========================--}}
        <nav class="navbar default " style="{{$check  == 1 ? 'display: none' : ''}} ">
            <div class="container-fluid">
                <div class="navbar-header">
                    <a class="navbar-brand" href="{{asset('/')}}">
                        <img src="{{asset('images/logo.png')}}" height="52px" style="margin-top: -18%;" >
                    </a>
                </div>
                <ul class="nav navbar-nav menu">
                    <li class="dropdown tag-menu
                        {{ request()->routeIs('app_dashboard')? 'active' : '' }}">
                        <a href="{{route('app_dashboard')}}"><span class="header-menu"><i class="fa fa-tachometer" aria-hidden="true"></i>
                            </span>{{__('administrator.dashboard')}}</a>
                    </li>

                    @if(Gate::check('Driver List')||Gate::check('Merchant List')||Gate::check('User List') )
                    <li class="dropdown tag-menu {{ request()->routeIs('driver.*')||request()->routeIs('merchant.*')||request()->routeIs('users.*')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-users" aria-hidden="true"></i>
                            </span>{{__('administrator.people')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Driver List'))
                            <li><a href="{{route('driver.index')}}">{{__('administrator.driver')}}</a></li>
                            @endif
                            @if(Gate::check('Merchant List'))
                            <li><a href="{{route('merchant.index')}}">{{__('administrator.merchant')}}</a></li>
                            @endif
                            @if(Gate::check('User List'))
                            <li><a href="{{route('users.index')}}"><span>{{__('administrator.users')}}</span></a></li>
                            @endif
                        </ul>
                    </li>
                    @endif
                    @if(Gate::check('Location List'))
                    {{-- <li class="dropdown tag-menu
                        {{ request()->routeIs('location.index')? 'active' : '' }}">
                        <a href="{{route('location.index')}}"><span class="header-menu"><i class="fa fa-location-arrow" aria-hidden="true"></i>
                            </span>{{__('administrator.location')}}</a>
                        </li> --}}
                                <li class="dropdown tag-menu {{ request()->routeIs('category.*')||request()->routeIs('product.*')? 'active' : '' }}">
                                    <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-location-arrow" aria-hidden="true"></i>
                                        </span>{{__('administrator.location')}}<span class="caret"></span>
                                    </a>
                                    <ul class="dropdown-menu">

                                        <li><a href="{{route('location.index')}}">{{__('administrator.location')}}</a></li>
                                        <li><a href="{{route('bus.index')}}">{{__('administrator.bus')}}</a></li>

                                    </ul>
                                </li>
                    @endif




                    @if(Gate::check('Category List')||Gate::check('Product List'))
                    <li class="dropdown tag-menu {{ request()->routeIs('category.*')||request()->routeIs('product.*')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-product-hunt" aria-hidden="true"></i>
                            </span>{{__('administrator.products')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Category List'))
                            <li><a href="{{route('category.index')}}">{{__('administrator.category')}}</a></li>
                            @endif
                            @if(Gate::check('Product List'))
                            <li><a href="{{route('product.index')}}">{{__('administrator.products')}}</a></li>
                            @endif
                        </ul>
                    </li>
                    @endif

                    {{--  <li class="dropdown tag-menu {{ request()->routeIs('category.*')||request()->routeIs('product.*')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-product-hunt" aria-hidden="true"></i>
                            </span>{{__('administrator.pickup')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a href="{{route('assign-to-driver.create')}}">{{__('administrator.assign_to_driver')}}</a></li>
                            <li><a href="{{route('assign-to-driver.index')}}">{{__('administrator.assign_list')}}</a></li>
                        </ul>
                    </li>  --}}


                    @if(Gate::check('PickUp Assign to Driver')||Gate::check('PickUp List'))
                        {{-- <li class="dropdown tag-menu {{ request()->routeIs('assign-to-driver-1.*')||request()->routeIs('list-pickup.*')? 'active' : '' }}">
                            <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-product-hunt" aria-hidden="true"></i>
                                </span>{{__('administrator.pickup')}}<span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu">
                            @if(Gate::check('PickUp Assign to Driver'))
                                <li><a href="{{route('assign-to-driver-1.create')}}">{{__('administrator.assign_to_driver')}}</a></li>
                            @endif
                            @if(Gate::check('PickUp List'))
                                <li><a href="{{route('list_pickup')}}">{{__('administrator.list_pickup')}}</a></li>
                            @endif

                            </ul>
                        </li> --}}
                    @endif



                    @if(Gate::check('Import Stock')||Gate::check('Export OutStock')||Gate::check('Export InStock')||Gate::check('Export List'))
                    <li class="dropdown tag-menu {{ request()->routeIs('import_stock.*')||request()->routeIs('out-stock.*')||request()->routeIs('export-stock.*')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-archive" aria-hidden="true"></i>
                            </span>{{__('administrator.stock')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Import Stock'))
                            <li><a href="{{route('import-stock.index')}}">{{__('administrator.import_stock')}}</a></li>
                            @endif
                            @if(\Globals::is_MerchantIn() == 'MerchantOut' || \Globals::is_Administrator() == 'Administrator')
                            @if(Gate::check('Export OutStock'))
                            <li><a href="{{route('out-stock-new.create')}}">{{__('administrator.export_stock')}}</a></li>
                            @endif
                            @else
                            @if(Gate::check('Export InStock'))
                            <li><a href="{{route('export-stock.create')}}">{{__('administrator.export_stock')}}</a></li>
                            @endif
                            @endif
                            @if(Gate::check('Export List'))
                            <li><a href="{{route('export-stock.index')}}">{{__('administrator.export_list')}}</a></li>
                            @endif
                        </ul>
                    </li>
                    @endif
                    @if(Gate::check('New Order')||Gate::check('Driver Voucher')||Gate::check('In Proccessing')||Gate::check('Delivery Complated')||Gate::check('Delivery Pending')||Gate::check('Delivery Concel'))
                    <li class="dropdown tag-menu {{ request()->routeIs('delivery-order.*')||request()->routeIs('in_processing')||request()->routeIs('list_delivery_seccess')||request()->routeIs('list_delivery_padding')||request()->routeIs('list_delivery_cancel')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-truck" aria-hidden="true"></i>
                            </span>{{__('administrator.delivery')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('New Order'))
                            <li><a href="{{route('delivery-order.create')}}">{{__('administrator.new_order')}}</a></li>
                            @endif
                            {{-- @if(Gate::check('Driver Voucher'))
                            <li><a href="{{route('delivery-order.index')}}">{{__('administrator.driver_voucher')}}</a></li> 
                            @endif --}}
                            @if(Gate::check('Driver Voucher'))
                            <li><a href="{{route('delivery-order-new.index')}}">{{__('administrator.driver_voucher')}}</a></li> 
                            @endif
                            @if(Gate::check('In Proccessing'))
                            <li><a href="{{route('in_processing')}}">{{__('administrator.in_processing')}}</a></li>
                            @endif
                            @if(Gate::check('Delivery Complated'))
                            <li><a href="{{route('list_delivery_seccess')}}">{{__('administrator.completed')}}</a></li>
                            @endif
                            @if(Gate::check('Delivery Pending'))
                            <li><a href="{{route('list_delivery_padding')}}">{{__('administrator.pending')}}</a></li>
                            @endif
                            @if(Gate::check('Delivery Concel'))
                            <li><a href="{{route('list_delivery_cancel')}}">{{__('administrator.cancel')}}</a></li>
                            @endif
                        </ul>
                    </li>
                    @endif
                    @if(Gate::check('Report Delivery')||Gate::check('Report Driver')||Gate::check('Report Stock') ||Gate::check('Report Pickup'))
                    <li class="dropdown tag-menu {{ request()->routeIs('history_delivery')||request()->routeIs('history_driver')||request()->routeIs('stock.index')||request()->routeIs('history_pickup')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-area-chart" aria-hidden="true"></i>
                            </span>{{__('administrator.report')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Report Shop'))
                            <li><a href="{{route('report-for-shop-new.index')}}">Report Shop</a></li>
                            @endif
                            @if(Gate::check('Report Delivery'))
                            <li><a href="{{route('history_delivery')}}">{{__('administrator.report_delivery')}}</a></li>
                            @endif
                            @if(Gate::check('Report Driver'))
                                <li><a href="{{route('history_driver')}}">{{__('administrator.report_driver')}}</a></li>
                            @endif
                            @if(Gate::check('Report Driver'))
                                <li><a href="{{route('history_by_driver')}}">Report By Driver</a></li>
                            @endif
                        
                            
                            @if(Gate::check('Summary Driver'))
                                {{-- <li><a href="{{route('summary_driver')}}">{{__('administrator.summary_driver')}}</a></li> --}}
                            @endif

                        
                            @if(Gate::check('Daily Report'))
                            <li><a href="{{route('daily-report.index')}}">Daily Report</a></li>
                            @endif
                            @if(Gate::check('Report Stock'))
                            <li><a href="{{route('stock.index')}}"><span class=""></span>{{__('administrator.report_stock')}}</a></li>
                            @endif
                            {{-- <li><a href="{{route('summary-delivery-list')}}">Summary Delivery</a></li> --}}
                            <li><a href="{{route('clear-data.index')}}">Clear Data</a></li>
                        </ul>
                    </li>
                    @endif
                    @if(Gate::check('Clear Invoice'))
                    <li class="dropdown tag-menu {{ request()->routeIs('clear-invoice.index')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-area-chart" aria-hidden="true"></i>
                            </span>{{__('administrator.payment')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Clear Invoice'))
                                <li><a href="{{route('clear-invoice.index')}}">{{__('administrator.clear_invoice')}}</a></li>
                            @endif
                            {{-- <li><a href="{{route('clear-dirver.index')}}">{{__('administrator.clea_droiver')}}</a></li> --}}
                        </ul>
                    </li>
                    @endif


                    @if(Gate::check('Income List')||Gate::check('Exspens List'))
                    <li class="dropdown tag-menu {{ request()->routeIs('income.*')||request()->routeIs('expense.*')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-calculator" aria-hidden="true"></i>
                            </span>{{__('administrator.accounting')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Income List'))
                            <li><a href="{{route('income.index')}}">{{__('administrator.income')}}</a></li>
                            @endif
                            @if(Gate::check('Exspens List'))
                            <li><a href="{{route('expense.index')}}">{{__('administrator.expense')}}</a></li>
                            @endif
                            <!-- <li><a href="{{route('account-receivable.index')}}">{{__('administrator.account_receivable')}}</a></li>
                            <li><a href="{{route('account-payable.index')}}">{{__('administrator.account_payable')}}</a></li> -->
                        </ul>
                    </li>
                    @endif
                    @if(Gate::check('Report Income')||Gate::check('Report Exspens')||Gate::check('Cash On Hand')||Gate::check('IncomeStatement'))
                    <li class="dropdown tag-menu {{ request()->routeIs('reportIncome')||request()->routeIs('reportExpense')||request()->routeIs('cash-on-hand')||request()->routeIs('IncomeStatement')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-area-chart" aria-hidden="true"></i>
                            </span>{{__('administrator.report_accounting')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            @if(Gate::check('Report Income'))
                                <li><a href="{{route('reportIncome')}}">{{__('administrator.income')}}</a></li>
                            @endif
                            @if(Gate::check('Report Exspens'))
                                <li><a href="{{route('reportExpense')}}">{{__('administrator.expense')}}</a></li>
                            @endif
                            @if(Gate::check('Cash On Hand'))
                                <li><a href="{{route('cash-on-hand')}}">{{__('administrator.cash_on_hand')}}</a></li>
                            @endif
                            @if(Gate::check('IncomeStatement'))
                                <li><a href="{{route('IncomeStatement')}}">{{__('administrator.income_statement')}}</a></li>
                            @endif

                        </ul>
                    </li>
                    @endif
                    <li class="dropdown tag-menu {{ request()->routeIs('admin.appearance')||request()->routeIs('account_profile')||request()->routeIs('roles.*')||request()->routeIs('currency.*')||request()->routeIs('branch.*')||request()->routeIs('account-chart.*')? 'active' : '' }}">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i class="fa fa-cog" aria-hidden="true"></i>
                            </span>{{__('administrator.setting')}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a href="{{route('admin.appearance')}}">{{__('administrator.appearance')}}</a></li>
                            @if(Gate::check('Roles Commitment'))
                                {{-- <li><a href="{{route('roles-commitment.create')}}">{{__('administrator.roles_commission')}}</a></li> --}}
                            @endif
                            {{-- <li><a href="{{route('discount.create')}}">{{__('administrator.discount')}}</a></li> --}}
                            <li><a href="{{route('discount-for-shop')}}">{{__('administrator.discount')}}</a></li>

                            <li><a href="{{route('account_profile')}}">{{__('administrator.security')}}</a></li>
                            <li><a href="{{route('km')}}">ភាសារខ្មែរ</a></li>
                            <li><a href="{{route('en')}}">{{__('administrator.english')}}</a></li>
                            @if(Gate::check('Roles List'))
                                <li><a href="{{route('roles.index')}}">{{__('administrator.roles')}}</a></li>
                            @endif

                            @if(Gate::check('currency'))
                                <li><a href="{{route('currency.index')}}">{{__('administrator.currency')}}</a></li>
                            @endif
                            @if(Gate::check('Account Chart'))
                                <li><a href="{{route('account-chart.index')}}">{{__('administrator.account_chart')}}</a></li>
                            @endif
                            <li><a href="{{route('change-menu')}}" class="change_menu"> To Mobile</a></li>

                        </ul>
                    </li>
                </ul>

                <div id="sound"></div>

                <ul class="nav navbar-nav menu pull-right">
                    @if(Gate::check('PickUp Assign to Driver'))
                    <li class="dropdown tag-menu">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i
                                            class="fa fa-bell"></i></span> <span class="caret"></span>
                                <span class="label label-danger">{{ $requestpickup_count  }}</span>
                            </a>
                        <ul class="dropdown-menu append">
                            @if ($requestpickup_count == 0)
                                <li class="notifi">
                                    <a href="javascript:void(0)" style="font-size: 15px; padding: 3px; color: white;"> Nothing found - sorry</a>
                                </li>
                            @endif
                            @foreach ( $requestpickup as $value)
                                <?php
                                    $data = DB::table('nso007_request_pickup_detail')->where('request_pickup_id', $value->request_pickup_id)->get();
                                    $count = 0;
                                    if( $data->count()){
                                        $count = $data->count() ;
                                    }
                                ?>
                                @if($value->type == 1)              {{--   out Stock  --}}
                                    <li >
                                        <a href="#" style="border: 1px solid #cccccb;">
                                        <i class="fa fa-truck text-yellow"></i> <span style="font-size: 18px;"><b>{{ $value->shop_name }}</b></span>(Stock out) <br>
                                        <span class="pull-left" style="margin-left: 10%;"><b>Qty</b> :{{ $count  }}</span>      <span class="pull-right"><b>Date</b> :{{  date('d-m-Y', strtotime($value->created_at))}}</span>
                                        </a>
                                    </li>
                                @elseif($value->type == 2){         {{-- In stock --}}
                                    <li>
                                        <a href="#" style="border: 1px solid #cccccb;">
                                        <i class="fa fa-truck text-yellow"></i> <span style="font-size: 18px;"><b>{{ $value->shop_name }}</b></span>(Stock in) <br>
                                        <span class="pull-left" style="margin-left: 10%;"><b>Qty</b> :{{ $count  }}</span>      <span class="pull-right"><b>Date</b> :{{  date('d-m-Y', strtotime($value->created_at))}}</span>
                                        </a>
                                    </li>
                                @endif
                            @endforeach
                            <li><a style="text-align: center; color:#337ab7;" href="{{route('assign-to-driver-1.create')}}">See all</a></li>
                        </ul>
                    </li>
                    @endif
                    <li class="dropdown tag-menu">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i
                                            class="fa fa-truck"></i></span> <span class="caret"></span>
                                <span class="label label-danger">{{ $date_delivery->count()  }}</span>
                            </a>
                        <ul class="dropdown-menu append"  style="overflow-y: scroll ; height: 500px;">

                            @if ($date_delivery->count() == 0)
                                <li class="notifi">
                                    <a href="javascript:void(0)" style="font-size: 15px; padding: 3px; color: white;"> Nothing found - sorry</a>
                                </li>
                            @endif
                            @foreach ( $date_delivery as $value)
                                    <li onclick='copyToClipboard("{{ $value->box_code }}")' class="{{ $value->box_code }} box_code_show " >
                                        <a href="#" style="border: 1px solid #cccccb;">
                                        <i class="fa fa-truck text-yellow"></i> <span style="font-size: 18px;"><b>  <input type="text" value="{{ $value->box_code }}" id="cl_{{ $value->box_code }}" readonly style="border: none"></b>  <br>
                                        <span class="pull-left" style="margin-left: 10%;font-size: 14px;"><b>location</b> :{{ $value->name_km }}</span>  <span class="pull-right" style=" font-size: 14px;"><b>Date</b> :{{ date('d-m-Y',strtotime($value->date_delivery))   }}</span>
                                        </a>
                                    </li>
                            @endforeach
                            <li><a style="text-align: center; color:#337ab7;" href="{{route('delivery-order.create')}}">Go New Order</a></li>
                        </ul>
                    </li>
                    <li class="dropdown tag-menu">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                            <span class="header-menu"><i class="fa fa-user-o"></i></span>{{Auth::user()->name}}<span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Sign out</a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                    {{ csrf_field() }}
                                </form>
                            </li>
                        </ul>
                    </li>
                </ul>

            </div>
        </nav>
    @else {{--=========================LEFT MENU==========================--}}
        <div class="wrapper">
            <header class="main-header slide-down">
                <a href="{{asset('/')}}" class="logo">
                    <span class="logo-mini">NSO</span>
                    <span class="logo-sm "><img src="{{asset('images/logo.png')}}" height="50px">
                        </span>
                </a>
                <nav class="navbar navbar-static-top" role="navigation">
                    <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
                        <span class="sr-only">Toggle navigation</span>
                        <i class="fa fa-bars" aria-hidden="true"></i>
                    </a>
                    <div class="navbar-custom-menu hidden-xs">
                        <ul class="nav navbar-nav">
                            <li class="dropdown tag-menu">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="header-menu"><i
                                                    class="fa fa-bell"></i></span> <span class="caret"></span>
                                        <span class="label label-Warning">0</span>
                                    </a>
                                <ul class="dropdown-menu">
                                    <li class="notifi"><a href="javascript:void(0)" style="font-size: 15px; padding: 3px; color: white;"> Notications</a>
                                    </li>
                                    <li><a style="text-align: center; color:#337ab7;" href="javascript:void(0)">See all</a></li>
                                </ul>
                            </li>
                            @if(Fun::lang()=='km')
                            <li class="pt_lang fmgp42">
                                <a href="{{route('en')}}">
                                    <img id="" src="{{asset('images/kh.png')}}" title="Khmer">
                                </a>
                            </li>
                            @else
                            <li class="pt_lang fmgp42">
                                <a href="{{route('km')}}">
                                    <img id="" src="{{asset('images/us.png')}}" title="English">
                                </a>
                            </li>
                            @endif
                            <li class="pt_lang fmgp42">
                                <a href=""><span><img src="{{asset('images/upload')}}/{{Auth::user()->avartar}}"></span> {{Auth::user()->name}}</a>
                            </li>
                            <li class="pt_lang fmgp42">
                                <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><span
                                                class="fa fa-sign-out"></span> Sign out</a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                    {{ csrf_field() }}
                                </form>
                            </li>
                        </ul>
                    </div>
                </nav>
            </header>
            <aside class="main-sidebar slide-in">
                <section class="sidebar">
                    <ul class="sidebar-menu">
                        <li class="treeview ">
                            <a href="{{route('app_dashboard')}}">
                                <i class="fa fa-tachometer"></i>
                                <span>{{__('administrator.dashboard')}}</span>&nbsp;<span class="label label-danger"></span>
                            </a>
                        </i>
                        @if(Gate::check('Driver List')||Gate::check('Merchant List')||Gate::check('User List') )
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-tachometer"></i>
                                <span>{{__('administrator.people')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('Driver List'))
                                <li><a href="{{route('driver.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.driver')}}</a></li>
                                @endif
                                @if(Gate::check('Merchant List'))
                                <li><a href="{{route('merchant.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.merchant')}}</a></li>
                                @endif
                                @if(Gate::check('User List'))
                                <li><a href="{{route('users.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.users')}}</a></li>
                                @endif
                            </ul>
                        </i>
                        @endif
                        @if(Gate::check('Location List'))
                        <li class="treeview ">
                            <a href="{{route('location.index')}}">
                                <i class="fa fa-location-arrow"></i>
                                <span>{{__('administrator.location')}}</span>&nbsp;<span class="label label-danger"></span>
                            </a>
                        </i>
                        @endif
                        @if(Gate::check('Category List')||Gate::check('Product List'))
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-product-hunt"></i>
                                <span>{{__('administrator.products')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('Category List'))
                                <li><a href="{{route('category.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.category')}}</a></li>
                                @endif
                                @if(Gate::check('Product List'))
                                <li><a href="{{route('product.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.products')}}</a></li>
                                @endif
                            </ul>
                        </i>
                        @endif
                        @if(Gate::check('Import Stock')||Gate::check('Export OutStock')||Gate::check('Export InStock')||Gate::check('Export List'))
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-archive"></i>
                                <span>{{__('administrator.stock')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('Import Stock'))
                                <li><a href="{{route('import-stock.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.import_stock')}}</a></li>
                                @endif
                                @if(\Globals::is_MerchantIn() == 'MerchantOut' || \Globals::is_Administrator() == 'Administrator')
                                @if(Gate::check('Export OutStock'))
                                <li><a href="{{route('out-stock.create')}}"><span class="fa fa-circle-o"></span>{{__('administrator.export_stock')}}</a></li>
                                @endif
                                @else
                                @if(Gate::check('Export InStock'))
                                <li><a href="{{route('export-stock.create')}}"><span class="fa fa-circle-o"></span>{{__('administrator.export_stock')}}</a></li>
                                @endif
                                @endif
                                @if(Gate::check('Export List'))
                                <li><a href="{{route('export-stock.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.export_list')}}</a></li>
                                @endif
                            </ul>
                        </i>
                        @endif
                        @if(Gate::check('New Order')||Gate::check('Driver Voucher')||Gate::check('In Proccessing')||Gate::check('Delivery Complated')||Gate::check('Delivery Pending')||Gate::check('Delivery Concel'))
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-truck"></i>
                                <span>{{__('administrator.delivery')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('New Order'))
                                <li><a href="{{route('delivery-order.create')}}"><span class="fa fa-circle-o"></span>{{__('administrator.new_order')}}</a></li>
                                @endif
                                @if(Gate::check('Driver Voucher'))
                                <li><a href="{{route('delivery-order.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.driver_voucher')}}</a></li>
                                @endif
                                @if(Gate::check('In Proccessing'))
                                <li><a href="{{route('in_processing')}}"><span class="fa fa-circle-o"></span>{{__('administrator.in_processing')}}</a></li>
                                @endif
                                @if(Gate::check('Delivery Complated'))
                                <li><a href="{{route('list_delivery_seccess')}}"><span class="fa fa-circle-o"></span>{{__('administrator.completed')}}</a></li>
                                @endif
                                @if(Gate::check('Delivery Pending'))
                                <li><a href="{{route('list_delivery_padding')}}"><span class="fa fa-circle-o"></span>{{__('administrator.pending')}}</a></li>
                                @endif
                                @if(Gate::check('Delivery Concel'))
                                <li><a href="{{route('list_delivery_cancel')}}"><span class="fa fa-circle-o"></span>{{__('administrator.cancel')}}</a></li>
                                @endif
                            </ul>
                        </i>
                        @endif

                        @if(Gate::check('Report Delivery')||Gate::check('Report Driver')||Gate::check('Report Stock'))
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-area-chart"></i>
                                <span>{{__('administrator.report')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('Report Delivery'))
                                <li><a href="{{route('history_delivery')}}"><span class="fa fa-circle-o"></span>{{__('administrator.report_delivery')}}</a></li>
                                @endif
                                @if(Gate::check('Report Driver'))
                                <li><a href="{{route('history_driver')}}"><span class="fa fa-circle-o"></span>{{__('administrator.report_driver')}}</a></li>
                                @endif
                                @if(Gate::check('Report Stock'))
                                <li><a href="{{route('stock.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.report_stock')}}</a></li>
                                @endif
                            </ul>
                        </i>
                        @endif

                        @if(Gate::check('Income List')||Gate::check('Exspens List'))
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-calculator"></i>
                                <span>{{__('administrator.accounting')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('Income List'))
                                <li><a href="{{route('income.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.income')}}</a></li>
                                @endif
                                @if(Gate::check('Exspens List'))
                                <li><a href="{{route('expense.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.expense')}}</a></li>
                                @endif
                                <!-- <li><a href="{{route('account-receivable.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.account_receivable')}}</a></li>
                                <li><a href="{{route('account-payable.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.account_payable')}}</a></li> -->
                            </ul>
                        </i>
                        @endif
                        @if(Gate::check('Report Income')||Gate::check('Report Exspens')||Gate::check('Report Stock'))
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-area-chart"></i>
                                <span>{{__('administrator.report_accounting')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                @if(Gate::check('Report Income'))
                                <li><a href="{{route('reportIncome')}}"><span class="fa fa-circle-o"></span>{{__('administrator.income')}}</a></li>
                                @endif
                                @if(Gate::check('Report Exspens'))
                                <li><a href="{{route('reportExpense')}}"><span class="fa fa-circle-o"></span>{{__('administrator.expense')}}</a></li>
                                @endif
                                @if(Gate::check('Cash On Hand'))
                                <li><a href="{{route('cash-on-hand')}}"><span class="fa fa-circle-o"></span>{{__('administrator.cash_on_hand')}}</a></li>
                                @endif
                                @if(Gate::check('IncomeStatement'))
                                <li><a href="{{route('IncomeStatement')}}"><span class="fa fa-circle-o"></span>{{__('administrator.income_statement')}}</a></li>
                                @endif
                            </ul>
                        </i>
                        @endif
                        <li class="treeview ">
                            <a href="#">
                                <i class="fa fa-cog"></i>
                                <span>{{__('administrator.setting')}}</span><i class="fa fa-angle-right pull-right"></i>
                            </a>
                            <ul class="treeview-menu" id="treeopen">
                                <li><a href="{{route('admin.appearance')}}"><span class="fa fa-circle-o"></span>{{__('administrator.appearance')}}</a></li>
                                <li><a href="{{route('account_profile')}}"><span class="fa fa-circle-o"></span>{{__('administrator.security')}}</a></li>
                                <li><a href="{{route('km')}}"><span class="fa fa-circle-o"></span> ភាសារខ្មែរ</a></li>
                                <li><a href="{{route('en')}}"><span class="fa fa-circle-o"></span>{{__('administrator.english')}}</a></li>
                                @if(Gate::check('Roles List'))
                                <li><a href="{{route('roles.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.roles')}}</a></li>
                                @endif
                                <li><a href="{{route('currency.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.currency')}}</a></li>
                                <li><a href="{{route('account-chart.index')}}"><span class="fa fa-circle-o"></span>{{__('administrator.account_chart')}}</a></li>
                                
                            </ul>
                        </i>
                    </ul>
                </section>
            </aside>
        </div>
    @endif

    @if ($check == 1)
        
    <style>
        .content-wrapper{
            margin-top: 20px;
        }
        .default,
        .sticky{
            display: none !important;
        } 
        /*================MMenu=========================*/
        .main-menu-toggle {
            display: block !important;
            background: #fff;
            border-bottom: 1px solid #eee
        }
        .toggle-mmenu {
            margin-top: 6px;
            float: left;
        }
        .logo-mobile {
            margin-right: 90px;
            margin-top: -10px
        }
        .logo-mobile img {
            width: 85px;
            padding: 15px 5px 5px 0px;
        }
        .btn-menu img {
            width: 40px
        }
    </style>
    @endif

    <div class="main-menu-toggle" style="" >
        <div class="container">
            <div class="row">
                <div class="col-sm-6 col-xs-6">
                    <div class="toggle-mmenu">
                        <a href="#" class="btn-menu">
                            <img src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/162656/arrows_hamburger.svg"/>
                        </a>
                    </div>
                </div>

                <nav id="my-menu">
                    <ul>
                        <li><a href="{{route('app_dashboard')}}">{{__('administrator.dashboard')}}</a></li>
                        @if(Gate::check('Driver List')||Gate::check('Merchant List')||Gate::check('User List') )
                        <li><a href="#">{{__('administrator.people')}}</a>
                            <ul>
                                @if(Gate::check('Driver List'))
                                <li><a href="{{route('driver.index')}}">{{__('administrator.driver')}}</a></li>
                                @endif
                                @if(Gate::check('Merchant List'))
                                <li><a href="{{route('merchant.index')}}">{{__('administrator.merchant')}}</a></li>
                                @endif
                                @if(Gate::check('User List'))
                                <li><a href="{{route('users.index')}}"><span>{{__('administrator.users')}}</span></a></li>
                                @endif
                            </ul>
                        </li>
                        @endif

                        @if(Gate::check('Location List'))
                        <li><a href="#">{{__('administrator.location')}}</a>
                            <ul>
                                <li><a href="{{route('location.index')}}">{{__('administrator.location')}}</a></li>
                                <li><a href="{{route('bus.index')}}">{{__('administrator.bus')}}</a></li>
                            </ul>
                        </li>
                        @endif

                        @if(Gate::check('Category List')||Gate::check('Product List'))
                        <li><a href="#">{{__('administrator.products')}}</a>
                            <ul>
                                @if(Gate::check('Category List'))
                                <li><a href="{{route('category.index')}}">{{__('administrator.category')}}</a></li>
                                @endif
                                @if(Gate::check('Product List'))
                                <li><a href="{{route('product.index')}}">{{__('administrator.products')}}</a></li>
                                @endif
                            </ul>
                        </li>
                        @endif

                        @if(Gate::check('Import Stock')||Gate::check('Export OutStock')||Gate::check('Export InStock')||Gate::check('Export List'))
                        <li><a href="#">{{__('administrator.stock')}}</a>
                            <ul>
                                @if(Gate::check('Import Stock'))
                                <li><a href="{{route('import-stock.index')}}">{{__('administrator.import_stock')}}</a></li>
                                @endif
                                @if(\Globals::is_MerchantIn() == 'MerchantOut' || \Globals::is_Administrator() == 'Administrator')
                                @if(Gate::check('Export OutStock'))
                                <li><a href="{{route('out-stock.create')}}">{{__('administrator.export_stock')}}</a></li>
                                @endif
                                @else
                                @if(Gate::check('Export InStock'))
                                <li><a href="{{route('export-stock.create')}}">{{__('administrator.export_stock')}}</a></li>
                                @endif
                                @endif
                                @if(Gate::check('Export List'))
                                <li><a href="{{route('export-stock.index')}}">{{__('administrator.export_list')}}</a></li>
                                @endif
                            </ul>
                        </li>
                        @endif

                        @if(Gate::check('New Order')||Gate::check('Driver Voucher')||Gate::check('In Proccessing')||Gate::check('Delivery Complated')||Gate::check('Delivery Pending')||Gate::check('Delivery Concel'))
                          <li><a href="#">{{__('administrator.delivery')}}</a>
                            <ul>
                                @if(Gate::check('New Order'))
                                <li><a href="{{route('delivery-order.create')}}">{{__('administrator.new_order')}}</a></li>
                                @endif
                                @if(Gate::check('Driver Voucher'))
                                {{--  <li><a href="{{route('delivery-order.index')}}">{{__('administrator.driver_voucher')}}</a></li>  --}}
                                @endif
                                @if(Gate::check('In Proccessing'))
                                <li><a href="{{route('in_processing')}}">{{__('administrator.in_processing')}}</a></li>
                                @endif
                                @if(Gate::check('Delivery Complated'))
                                <li><a href="{{route('list_delivery_seccess')}}">{{__('administrator.completed')}}</a></li>
                                @endif
                                @if(Gate::check('Delivery Pending'))
                                <li><a href="{{route('list_delivery_padding')}}">{{__('administrator.pending')}}</a></li>
                                @endif
                                @if(Gate::check('Delivery Concel'))
                                <li><a href="{{route('list_delivery_cancel')}}">{{__('administrator.cancel')}}</a></li>
                                @endif
                            </ul>
                        </li>
                        @endif


                        @if(Gate::check('Report Delivery')||Gate::check('Report Driver')||Gate::check('Report Stock') ||Gate::check('Report Pickup'))
                        
                        <li><a href="#">{{__('administrator.report')}}</a>
                          <ul>
                            @if(Gate::check('Report Shop'))
                            <li><a href="{{route('report-for-shop.index')}}">Report Shop</a></li>
                            @endif
                            @if(Gate::check('Report Delivery'))
                            <li><a href="{{route('history_delivery')}}">{{__('administrator.report_delivery')}}</a></li>
                            @endif
                            @if(Gate::check('Report Driver'))
                            <li><a href="{{route('history_driver')}}">{{__('administrator.report_driver')}}</a></li>
                            @endif
                            @if(Gate::check('Summary Driver'))
                                {{-- <li><a href="{{route('summary_driver')}}">{{__('administrator.summary_driver')}}</a></li> --}}
                            @endif

                            @if(Gate::check('Daily Report'))
                            <li><a href="{{route('daily-report.index')}}">Daily Report</a></li>
                            @endif

                            @if(Gate::check('Report Stock'))
                            <li><a href="{{route('stock.index')}}">{{__('administrator.report_stock')}}</a></li>
                            @endif
                            
                            {{-- <li><a href="{{route('summary-delivery-list')}}">Summary Delivery</a></li> --}}
                            <li><a href="{{route('clear-data.index')}}">Clear Data</a></li>
                          </ul>
                      </li>
                      @endif

                        @if(Gate::check('Clear Invoice'))
                        <li><a href="#">{{__('administrator.payment')}}</a>
                            <ul>
                                @if(Gate::check('Clear Invoice'))
                                <li><a href="{{route('clear-invoice.index')}}">{{__('administrator.clear_invoice')}}</a></li>
                                @endif
                            </ul>
                        </li>
                        @endif


                    

                        @if(Gate::check('Income List')||Gate::check('Exspens List'))       
                        <li><a href="#">{{__('administrator.accounting')}}</a>
                            <ul >
                                @if(Gate::check('Income List'))
                                <li><a href="{{route('income.index')}}">{{__('administrator.income')}}</a></li>
                                @endif
                                @if(Gate::check('Exspens List'))
                                <li><a href="{{route('expense.index')}}">{{__('administrator.expense')}}</a></li>
                                @endif
                            </ul>
                        </li>
                        @endif


                        @if(Gate::check('Report Income')||Gate::check('Report Exspens')||Gate::check('Cash On Hand')||Gate::check('IncomeStatement'))

                        <li><a href="#">{{__('administrator.report_accounting')}}</a>
                            <ul >
                                @if(Gate::check('Report Income'))
                                <li><a href="{{route('reportIncome')}}">{{__('administrator.income')}}</a></li>
                                @endif
                                @if(Gate::check('Report Exspens'))
                                    <li><a href="{{route('reportExpense')}}">{{__('administrator.expense')}}</a></li>
                                @endif
                                @if(Gate::check('Cash On Hand'))
                                    <li><a href="{{route('cash-on-hand')}}">{{__('administrator.cash_on_hand')}}</a></li>
                                @endif
                                @if(Gate::check('IncomeStatement'))
                                    <li><a href="{{route('IncomeStatement')}}">{{__('administrator.income_statement')}}</a></li>
                                @endif

                            </ul>
                        </li>
                        @endif



                    
                        <li><a href="#">{{__('administrator.setting')}}</a>
                            <ul >
                                <li><a href="{{route('admin.appearance')}}">{{__('administrator.appearance')}}</a></li>
                                @if(Gate::check('Roles Commitment'))
                                    {{-- <li><a href="{{route('roles-commitment.create')}}">{{__('administrator.roles_commission')}}</a></li> --}}
                                @endif
                                {{-- <li><a href="{{route('discount.create')}}">{{__('administrator.discount')}}</a></li> --}}
                                <li><a href="{{route('discount-for-shop')}}">{{__('administrator.discount')}}</a></li>
        
                                <li><a href="{{route('account_profile')}}">{{__('administrator.security')}}</a></li>
                                <li><a href="{{route('km')}}">ភាសារខ្មែរ</a></li>
                                <li><a href="{{route('en')}}">{{__('administrator.english')}}</a></li>
                                @if(Gate::check('Roles List'))
                                    <li><a href="{{route('roles.index')}}">{{__('administrator.roles')}}</a></li>
                                @endif
        
                                @if(Gate::check('currency'))
                                    <li><a href="{{route('currency.index')}}">{{__('administrator.currency')}}</a></li>
                                @endif
                                @if(Gate::check('Account Chart'))
                                    <li><a href="{{route('account-chart.index')}}">{{__('administrator.account_chart')}}</a></li>
                                @endif
                            </ul>
                        </li>

 
                            @if(Fun::lang()=='km')
                            <li class="pt_lang fmgp42">
                                <a href="{{route('en')}}">
                                    <img id="" src="{{asset('images/kh.png')}}" title="Khmer">
                                </a>
                            </li>
                            @else
                            <li class="pt_lang fmgp42">
                                <a href="{{route('km')}}">
                                    <img id="" src="{{asset('images/us.png')}}" title="English">
                                </a>
                            </li>
                            @endif
                        <li><a href="{{route('change-menu')}}" class="change_menu"> To Desktop</a></li>
                            <li class="pt_lang fmgp42">
                                
                                <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><span
                                                class="fa fa-sign-out"></span> Sign out</a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                    {{ csrf_field() }}
                                </form>
                            </li> 
                    </ul>
                </nav>
            </div>
        </div>
    </div>



    <div style="@if($branch->menu_layout == 'left')margin-top: 50px;@endif" class="content-wrapper">
        @if ($message = Session::get('success'))
        <div class="alert-message alert-success">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <i class="fa fa-check"></i>
            <h3>Success</h3>
            <p>{{$message}}</p>
        </div>
        @endif @if ($message = Session::get('danger'))
        <div class="alert-message alert-danger">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <i class="fa fa-exclamation-triangle"></i>
            <h3>Errors</h3>
            <p>{{$message}}</p>
        </div>
        @endif @if ($message = Session::get('warning'))
        <div class="alert-message alert-warning">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <i class="fa fa-exclamation-triangle"></i>
            <h3>Warning</h3>
            <p>{{$message}}</p>
        </div>
        @endif @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <br>
            <br>
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
         @yield('content')
    </div>

    @endsection

    @section('script')
        @yield('js')
    @endsection





