@extends('layouts.app')
@section('content')
<style>
	form{
		display: inline;
	}
</style>
<?php Fun::lang()?>
<div class="top-header">
  <ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li><a href="{{route('backup.index')}}">{{__('administrator.backup')}}</a></li>
    <li class="active">{{__('administrator.backup_create')}}</li>
  </ol>
</div>
<div class="page">
<div class=container-fluid>
  <div class="top-content">
    <div class="row">
			<div class="col-sm-12 col-xs-12">
				<div class="title-add">
					<div class="pull-left">
						<h3>Backups</h3>
					</div>
					<div class="pull-right">
						<a href="{{route('backup.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> New backup</a>
					</div>
				</div>
			</div>
			<div​ class="col-sm-12 col-xs-12">
				<table class="table">
					<thead>
						<tr>
							<th width="5%">#</th>
							<th>Location</th>
							<th>Name</th>
							<th>File Size</th>
							<th width="15%">Action</th>
						</tr>
					</thead>
					<tbody>
						@if (@$files && $files)
							@foreach ($files as $key => $item)
								<tr>
									<td scope="row">{{ $key + 1 }}</td>
									<td>backups</td>
									<td>{{ $item }}</td>
									<td>{{  number_format(Storage::disk('laravel')->size($item) / 1048576,2) }} MB</td>
									<td>
										<a href="{{ route('backup.show', $item) }}">
											<button class="button_success show_productsinfo"><i class="fa fa-download"></i> Download</button>
										</a>
										<form action="{{ route('backup.destroy', $item) }}" method="POST">
											{{ csrf_field() }}
											<input type="hidden" name="_method" value="DELETE">
											<a href="javascript:void(0)">
												<button class="button_danger show_products"><i class="fa fa-trash"></i> Delete</button>
											</a>
										</form>
									</td>
								</tr>
							@endforeach
						@endif
					</tbody>
				</table>
			</div​>
      </div>
  </div>
</div>
@endsection
<style type="text/css">
  .switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
@section('script')
	<script type="text/javascript">
		$('table').DataTable({
			"ordering": false
		});
	</script>
@endsection
