<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>2U Delivery</title>
    <meta property="og:type" content="website" />
    <meta property="og:title" content="2U Delivery" />
    <meta property="og:image" content="{{ asset('images/logo.png') }}" />
    <!-- Tell the browser to be responsive to screen width -->
    <!-- Favicon Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('images/logo.png') }}">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    {{-- <link rel="stylesheet" href="https://temp-operator.rorean.com/adminlte/bower_components/bootstrap/dist/css/bootstrap.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">

    <!-- Font Awesome -->
    {{-- <link rel="stylesheet" href="https://temp-operator.rorean.com/adminlte/bower_components/font-awesome/css/font-awesome.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('assets/font-awesome-4.7.0/css/font-awesome.css') }}">

    <!-- Ionicons -->
    <link rel="stylesheet"
        href="https://temp-operator.rorean.com/adminlte/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    {{-- <link rel="stylesheet" href="https://temp-operator.rorean.com/adminlte/dist/css/AdminLTE.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('assets/AdminLTE/AdminLTE.min.css') }}">


    {{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"> --}}

    <!-- Google Font -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
 
</head>

<body>

    <style type="text/css">
        body,
        #main-container {
            height: auto;
        }

        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: 1px solid black !important;
        }

    </style>


    <div class="wrapper" id="main-container">
        <!-- Main content -->
        <section class="invoice">
            <!-- title row -->
            {{-- <div class="row" style="margin-bottom: 10px; text-align:right">
        <div class="col-md-12">
            <a hreflang="en" href="https://temp-operator.rorean.com/en/open?id=7EDBA941CE0D781CB47C4CC41A76E97D42C8ABA0598005E61002A7E4F802139C">
                <button class="btn btn-default btn-sm"> <img src="https://temp-operator.rorean.com/img/en.jpg" style="width: 20px; margin:5px;">   English</i></button>
            </a>
            <a hreflang="km" href="https://temp-operator.rorean.com/km/open?id=7EDBA941CE0D781CB47C4CC41A76E97D42C8ABA0598005E61002A7E4F802139C">
                <button class="btn btn-default btn-sm"> <img src="https://temp-operator.rorean.com/img/km.png" style="width: 20px; margin:5px;">  ភាសាខ្មែរ</i></button>
            </a>
        </div>
    </div> --}}
            <div class="row">
                <div class="col-xs-12">
                    <h2 class="page-header">
                        <img src="{{ asset('images/logo.png') }}" width="70px;" height="70px;">2U Delivery
                        <small class="pull-right"> Date: {{ date('d-m-Y', strtotime($id->created_at)) }}</small>
                    </h2>
                </div>
            </div>
            <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                    From
                    <address>
                        <strong>2U Delivery</strong><br>
                        Address: {{ $branch->address }}<br>
                        Phone: {{ $branch->phone }} <br>
                    </address>
                </div>
                <div class="col-sm-4 invoice-col">
                    To
                    <address>
                        <strong> {{ $shop->shop_name }}</strong><br>
                        Address: {{ $shop->address }}<br>
                        Phone: {{ $shop->phone }}
                    </address>
                </div>

            </div>
            <div class="row">
                <div class="col-xs-12 table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th width="50px;"> Status</th>
                                <th> Type</th>
                                <th> Code</th>
                                <th> Remark</th>
                                <th> Phone Number</th>
                                <th> Zone</th>
                                <th> Driver</th>
                                <th style="width: 100px"> Date</th> 
                                <th> Total Itam</th>
                                <th colspan="2"> Collected prices</th>
                                <th> Delivery Fee</th>
                                <th> Extra fee</th> 
                                <th> Car service</th>
                                <th> Arrangement service</th>
                                <th> Other Fee</th>
                                <th> Net Price </th>
                                <th> Paid</th>
                                <th> Description</th>

                            </tr>
                        </thead>
                        <tbody>

                            @php
                                $total_riel                     = 0 ;
                                $total_dollar                   = 0 ;
						        $total_delivery_fee             = 0;
                                $arrangement_service            = 0;
                                $total_item                     = 0;
                                $total_car_service                    = 0;
                                $total_extra_fee                      = 0;
                                $total_service_charge                       = 0;
                                $total_other_fee                      = 0;
                                $សេវាផ្សេងៗ                             = 0;
                                $total_net_price_list                   =0;
                                
                            @endphp

                            @foreach ($data as $key => $value)

                            <?php
                                $Paid  =0;
                                $delivery_fee_shop = 0;
                                if($value->status == 4){
                                    $style = 'background: #f3cccf !important';
                                }else if($value->status == 2){
                                    $style = 'background: #ddd !important';
                                }else if($value->status == 1){
                                    $style = 'background: #fefdf0 !important';
                                }else{
                                    $style = '';
                                }
                            ?>

                            
                                <tr style="{{$style}}" >
                                    <td>{{ $key + 1 }}</td>
                                    <td>
                                        @if ($value->clear_box_code == 1)
                                            {!! ' <span class="label label-default">close</span>' !!}
                                        @endif
                                    </td>
                                    <td>
                                        <span>Delivery</span>
                                    </td>
                                    <td>{{ $value->box_code }}</td>
                                    <td>{{ $value->driver_note }}   {{ $value->detail_reason }}  </td>
                                    <td style="width:120px ;">{{ $value->customer_receive }}</td>
                                    <td>{{ $value->location_name }}</td>
                                    <td>{{ $value->driver_name }}</td>
                                    <td>{{ date('d-m-Y', strtotime($value->export_date)) }}</td>
                                    
                                    <td>{{ number_format($value->total_product, 2) }}

                                    <?php
                                        if($value->total_riel > 0){
                                            echo    '<td>$'. number_format( $value->total_dollar ,2).'</td>  <td>'.number_format(round($value->total_riel, -2,PHP_ROUND_HALF_ODD) ,0).'៛</td>' ;
                                        }
                                        else{
                                            echo    '<td>$'. number_format( $value->total_dollar    ,2).'</td><td></td>';
                                        }
                                    ?>

                                    <td>
                                        <?php
                                            $delivery_fee   = 0;
                                            $discount = 0;
                                            if( $value->discount_id != null)
                                            {
                                                $dis = DB::table('nso007_discount')->find($value->discount_id);
                                                if($dis->discount_type == 1){
                                                    $delivery_fee = $dis->discount;
                                                }
                                                elseif($dis->discount_type == 2){
                                                    $delivery_fee = ( (100 - $dis->discount )* $value->delivery_fee ) / 100;
                                                }
                                                else{
                                                    $delivery_fee =$value->delivery_fee;

                                                    if($value->delivery_status == 1){
                                                        $discount = ($dis->discount/100)*$value->delivery_fee;

                                                    }
                                                    else{
                                                        $discount = 0;
                                                    }
                                                    /* echo $discount; */
                                                }
                                            }
                                            else{
                                                $delivery_fee  =  $value->delivery_fee;
                                            }
                                            if($value->delivery_status == 1)
                                                $delivery_fee_view  =  '$'.number_format( $delivery_fee,2) . ' s';
                                            else
                                                $delivery_fee_view =   '$'.number_format( $delivery_fee,2) . ' c';

                                            if($value->delivery_pay_or_paid == 'paid'){
                                                echo  '  <strike> '.$delivery_fee_view . '  </strike>';
                                                $delivery_fee  = 0;
                                            }else{
                                                if($value->status == 2 || $value->status == 4){
                                                    echo  0 ;
                                                }else{
                                                    echo  $delivery_fee_view  ;

                                                }
                                            }
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                            if($value->extra_fee_type == 1) {
                                                $extra_fee_shop = $value->extra_fee ;
                                                $extra_fee_cus  = 0 ;
                                                    echo  '$'.number_format( $value->extra_fee,2)  . ' s'; }
                                            else if($value->extra_fee_type == 2)   {
                                                $extra_fee_shop = 0;
                                                $extra_fee_cus  = $value->extra_fee ;
                                                    echo  '$'.number_format( $value->extra_fee,2) . ' c';    }
                                            else  {
                                                $extra_fee_shop = 0;
                                                $extra_fee_cus = 0;
                                                    echo '$0';  }
                                        ?>​
                                    </td>

                                    <td>
                                        <?php
                                            if($value->taxi_status == 1){
                                                $taxi_fee_shop 	=   $value->taxi_fee  ;
                                                $taxi_fee_view 	=   number_format($value->taxi_fee,2)   . " s" ;
                                                $taxi_fee_cus	=      0  ;
    
                                            } else if($value->taxi_status == 2){
                                                $taxi_fee_cus=      $value->taxi_fee  ;
                                                $taxi_fee_view 	=    number_format($value->taxi_fee,2) ." c"  ;
                                                $taxi_fee_shop =  0  ;
                                            }
                                            else{
                                                $taxi_fee_cus=   0  ;
                                                $taxi_fee_shop =  0  ;
                                                $taxi_fee_view  = 0 ;
                                            }
    
    
                                            if($value->taxi_pay_or_paid == 'pay'){
                                                echo  $taxi_fee_view ;
                                            }else{
                                                echo  '$ <strike> '.  $taxi_fee_view  . '  </strike>';
                                                $taxi_fee_cus=   0  ;
                                                $taxi_fee_shop =  0  ;
                                            }
                                        ?>
                                    </td>


                                    <td>
                                        ${{number_format($value->service_charge,2)}}
                                    </td>

                                    <td>
                                        <?php
                                            if($value->other_services_type == 1){
                                                if($value->other_services_pay_or_paid == 'pay'){
                                                    echo  '$'.number_format( $value->other_services_fee,2) . ' s';

                                                }else{
                                                    echo  '$ <strike> '.number_format( $value->other_services_fee,2) . ' s </strike>';

                                                }

                                            } else if($value->other_services_type == 2){
                                                if($value->other_services_pay_or_paid == 'pay'){
                                                    echo  '$'.number_format( $value->other_services_fee,2) . ' c';

                                                }else{
                                                    echo  '$ <strike> '.number_format( $value->other_services_fee,2) . ' c </strike>';
                                                }
                                            }
                                        ?>
                                    </td>

                                    <td>
                                        <?php $total_shop =0;?>
                                        @if($value->status == 3)
                                            <?php
                                                if($value->other_services_pay_or_paid == 'pay'){
                                                    $សេវាផ្សេងៗ	 = $value->other_services_fee;
                                                }

                                            $total_net_price    = $value->total_dollar + ($value->total_riel / $value->currency) - $delivery_fee -  $extra_fee_cus  -$extra_fee_shop - $taxi_fee_shop - $value->service_charge - $សេវាផ្សេងៗ + $discount ;
                                            ?>
                                            ${{ number_format($value->total_dollar + ($value->total_riel / $value->currency) - $delivery_fee -  $extra_fee_cus  -$extra_fee_shop - $taxi_fee_shop - $value->service_charge - $សេវាផ្សេងៗ + $discount	,2)}}
    
                                        @else
                                            ${{ number_format( $total_shop,2)}}
                                        @endif

                                        @php
                                            if( $value->other_services_type == 2){
                                                $សេវាផ្សេងៗ   =  0;
                                            }
                                        @endphp
                                       
                                    </td>
                                    
                                    <td>
                                        @if($value->status == 1)
                                            <strong class="text-primary"><span class=" fa fa-spinner"></span> កំពុងដឹក</strong>
                                        @elseif($value->status == 2)
                                            <strong class="text-warning"><span class="fa fa-bullseye"></span> មិនជោគជ័យ   </strong>
                                        @elseif($value->status == 3)
                                            <strong class="text-info"><span class="fa fa-check"></span> ជោគជ័យ </strong>
                                        @else
                                            <strong class="text-danger"><span class="fa fa-ban"></span> មិនយក  </strong>
                                        @endif
                                    </td>
                                    <td>
                                        {{ $value->description }}
                                    </td>

                                </tr>
                                @php
                                 

                                    if($value->delivery_status  == 2){
                                        $delivery_fee = 0 ;
                                    }

                                    
                                    if(  $value->status == 3 && $value->clear_box_code != 1 ){
                                        $total_riel                         +=  $value->total_riel;
                                        $total_dollar                       +=  $value->total_dollar;
                                        $total_delivery_fee                 +=  $delivery_fee   + $extra_fee_shop ;
                                        $total_item                         += $value->total_product ;
                                        $total_car_service                  += $taxi_fee_shop;
                                        $total_service_charge               +=   $value->service_charge;
                                        $total_other_fee                    +=$សេវាផ្សេងៗ;
                                        $total_net_price_list               += $total_net_price;
                                        //$សេវារៀបចំ                          +=   $value->service_charge ;
                                    }

                                @endphp
                            @endforeach

                        </tbody>
                        <tfoot>
                            <tr>

                                <th colspan="9" style="text-align:right">Total:</th>
                                <th>  ${{ number_format( $total_item,2)}}</th>
                                <th>  ${{ number_format( $total_dollar,2)}}</th>
                                <th> {{number_format(round($total_riel, -2,PHP_ROUND_HALF_ODD) ,0).'៛'}}</th>
                                <th colspan="2" style="text-align: center;"> ${{ number_format( $total_delivery_fee,2)}}</th>
                                <th>  ${{ number_format( $total_car_service,2)}} </th>
                                <th>  ${{ number_format( $total_service_charge,2)}} </th>
                                <th>  ${{ number_format( $total_other_fee,2)}} </th>
                                <th>  ${{ number_format( $total_net_price_list,2)}} </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <div class="col-xs-12 col-sm-12 col-md-5 " style="border: 1px solid black; padding-bottom: 5px; ">
                        <p class="lead" style="margin-bottom: 5px;font-weight: bold; font-size: 17px;">Note</p>
                        <span style="white-space: pre-line">{{ $id->note ? $id->note  : 'N/A' }}</span>
                    </div>
                    <div class="col-xs-5">

                    </div>
                </div>
            </div>
        </section>
    </div>
</body>
 