@extends('layouts.app-mobile-merchant')

@section('content')
<?php Fun::lang()?>
<div class="mobile-dashboard">
    <div class="container">
        <div class="shipping-area">
            <div class="main-showdata">
                <div class="col-md-12 col-sm-6 col-xs-12">
                    <div class="show-boxdata">
                        <div class="exchage-rate ">
                            <div class="pull-left">
                                <p>Date : {{date("d-m-Y", strtotime($req->date)) }}</p>
                                <p>Exchange Rate: <span>{{$req->exchange_rate}} riel</span></p>
                                <p>Status : <span> @if ($req->status == 1)
                                        មិនទាត់ឃើញ
                                    @elseif($req->status == 2)
                                        បានឃើញ
                                    @else
                                        ជោគជ័យ
                                    @endif</span>
                                </p>
                            </div>
                            <div class="pull-right">
                                <p>Pickup By: <span>{{$req->name}}</span></p>
                                <p>Phone Number: <span><a href="tel:{{$req->phone}}">{{$req->phone}} </a></span></p>
                                <p>Invoice : <span>{{$req->invoice_pickup}}</span></p>
                            </div>
                        </div>
                        <div class="show-edit" style="display:none;">
                            {!! Form::open() !!}
                                <div class="box-name">
                                        <div class="title-box">
                                            <h4>Box</h4>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                {!!Form::select('category_id', $categories, null, ['class' => 'form-control category_id'])!!}
                                                <input type="hidden" id="" name="id" value=" {{$req->id}}" class="id">
                                            </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                <input type="text" class="form-control customer_receive" id="exampleInputEmail1" aria-describedby="emailHelp" name="customer_receive" placeholder="Customer Receive">
                                            </div>
                                        </div>
                                        {{-- <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                {!!Form::select('zoon_id', $zoon, null, ['class' => 'form-control zone zoon_id'])!!}
                                            </div>
                                        </div> --}}
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                {!!Form::select('location_id', $location, null, ['class' => 'form-control location1 location_id'])!!}
                                            </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                                <div class="form-group">
                                                    {!! Form::text('delivery_fee', null,array('class' => 'form-control delivery_fee','placeholder'=>'Delivery fee' ,'readonly')) !!}
                                                </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                <div class="bt_action toggle btn btn-success btn-xs form-control" data-toggle="toggle" >
                                                    <input data-id="1" data-size="mini" value="1" name="delivery_status" class="toggle-class  delivery_status" type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                                                    <div class="toggle-group">
                                                        <label class= " data-id btn  btn-danger btn-xs  toggle-on" >{{__('administrator.pay_shop')}}</label>
                                                        <label class=" data-id btn btn-success btn-xs active toggle-off" >{{__('administrator.pay_customer')}}</label><span class="toggle-handle btn btn-default btn-xs"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                                <div class="form-group">
                                                    <input type="text" class="form-control price" id="exampleInputEmail1" aria-describedby="emailHelp" name="price" placeholder="Price" >
                                                </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                                <div class="form-group">
                                                    {!!Form::select('bus_id', $bus, null, ['class' => 'form-control bus_id'])!!}
                                                </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                {!! Form::text('taxi_number', null,array('class' => 'form-control taxi_number','placeholder'=>'Taxi number')) !!}
                                            </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                <input type="text" class="form-control description" id="exampleInputEmail1" name="description" aria-describedby="emailHelp" placeholder="Description">
                                            </div>
                                        </div>
                                        <div class="col-xs-6 padd-0">
                                            <div class="form-group">
                                                <input type="text" class="form-control date_delivery date_picker"  value="{{date('d-m-Y')}}" name="date_delivery"   placeholder="date_delivery">
                                            </div>
                                        </div>
                                        <div class="diver-boxadd">
                                            <div class="mobile-button">
                                                <a class="button btn-edit btn-update"> Save</a>
                                            </div>
                                        </div>
                                </div>
                            {!! Form::close() !!}
                        </div>
                        <div class="result">
                            @foreach ($reqdetail as $item)
                                <div class="col-sm-6 col-xs-12 padd-2 {{$item->id}} ">
                                    <div class="mobile-detail">
                                        <div class="mobile-text">
                                            <div class="texted-left">
                                                <li>category Name : <span>@php  $category = DB::table('nso007_category')->where('id',$item->category_id)->first();@endphp
                                                {{$category->name_km}}</span></li>
                                                <li>Customer Receive: <span>{{$item->customer_receive}}</span></li>
                                                <li>Taxi number: <span>{{$item->taxi_number}}</span></li>
                                                <li>បង់ដោយ: <span>
                                                    @php
                                                        if($item->delivery_status==1){
                                                            echo 'ខាងហាង';
                                                        }
                                                        elseif ($item->delivery_status==1) {
                                                            echo 'ខាងអតិថិជន';
                                                        }
                                                    @endphp
                                                </span></li>
                                            </div>
                                            <div class="texted-right">
                                                <li>Location: <span>@php  $location = DB::table('nso007_location')->where('id',$item->location_id)->first();@endphp
                                                    {{$location->name_km}}</span></li>
                                                <li>Price: <span>{{$item->price}}$</span></li>
                                                <li>Delivery:  <span>{{$item->delivery_fee}}$</span></li>
                                            </div>
                                            @if ($req->status == 1)
                                                <div class="diver-boxdelete">
                                                    <div class="mobile-button">
                                                        <button class="btn-edit button-edit" data-id="{{$item->id}}">Edit </button>
                                                        <button class="btn-delete button-delete" data-id="{{$item->id}}">Delete</button>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="button-show">
                            <a href="{{route('merchant_pickup')}}"><button>back</button></a>
                            @if ($req->status == 1)
                                <button class="btn-add">Add New</button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<script>

          $(document).on('change', '.location_id',function(){
              var id = $(this).val();
              var this_ = $(this);

               $.ajax({
                  type: 'GET',
                  url: '{{ route("find_delivery_fee") }}',
                  dataType:'json',
                  data: {
                      _token: '{{ csrf_token() }}',
                      id: id,
                  },
                  success: function (data) {
                    $('.box-name').find('.delivery_fee').val("");
                    $('.box-name').find('.delivery_fee').val(data);
                  }
              });
          });
          $(document).on('click', '.bt_action','.toggle', function() {
              var status = $(this).hasClass( "off" ) == true ? 1 : 2;
              $( $('.box-name').find(".delivery_status").val(status));
              $(this).toggleClass("off");
          });

          $(document).on('click', '.button-edit', function() {
            $('.box-name').find('.btn-edit').removeClass('btn-save ');
            $('.box-name').find('.btn-edit').addClass('btn-update');
            $('.box-name').find('.btn-edit').html('<i class="fa fa-plus"></i>Save');
            $('.show-edit').show();
            $('select').select2();
             var id =$(this).data().id;
             $.ajax({
                  type: 'POST',
                  url: '{{ route("merchant_request_pickup_show.edit") }}',
                  dataType:'json',
                  data: {
                      _token: '{{ csrf_token() }}',
                      id: id,

                  },
                  success: function (data) {
                      $('.box-name').find('.price').val(data.price);
                      $('.box-name').find('.id').val(data.id);

                      $('.box-name').find('.category_id').val(data.category_id).change();
                      $('.box-name').find('.customer_receive').val(data.customer_receive);
                      $('.box-name').find('.location_id').val(data.location_id).change();

                      $('.box-name').find('.delivery_fee').val(data.delivery_fee);
                      $('.box-name').find('.taxi_number').val(data.taxi_number);
                      $('.box-name').find('.description').val(data.description);
                      $('.box-name').find('.bus_id').val(data.delivery_option).change();


                      if(data.delivery_status == 2){
                          $('.box-name').find('.bt_action').addClass('off');
                      }else if(data.delivery_status == 1){
                          $('.box-name').find('.bt_action').removeClass('off');
                      }
                      str = data.date_delivery;
                                        st2 = str.split("-");
                                        yr = st2[0];
                                        mo = st2[1];
                                        dy = st2[2];
                        var date_delivery = dy+'-'+mo+'-'+yr; 
                    $('.box-name').find('.date_delivery').val(date_delivery);
                  }

              });
          });

          $(document).on('click', '.btn-update', function() {
              
           
            var id = $('.box-name').find('.id').val();
            var category_id =$('.box-name').find('.category_id').val();
            var customer_receive =$('.box-name').find('.customer_receive').val();
            // var zoon_id =$('.box-name').find('.zoon_id').val();
            var location_id =$('.box-name').find('.location_id').val();
            var delivery_fee =$('.box-name').find('.delivery_fee').val();
            var delivery_status =$('.box-name').find('.delivery_status').val();
            var price =$('.box-name').find('.price').val();
            var bus_id =$('.box-name').find('.bus_id option:selected').text();
            var taxi_number =$('.box-name').find('.taxi_number').val();
            var description =$('.box-name').find('.description').val();
            var date_delivery =$('.box-name').find('.date_delivery').val();
            if(price == '' && location_id == ''&& customer_receive == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមជ្រើសរើសទីតាំង , បញ្ចូលតម្លៃ នឹង​លេខអ្នកទទួល​ ។',
                });
            }else if(customer_receive == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមបញ្ចូលលេខអ្នកទទួល។',
                });
            }else if(location_id == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមជ្រើសរើសទីតាំង។',
                });
            }
            else if(price == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមបញ្ចូលតម្លៃ។',
                });
            }else if(price != '' && location_id != ''){
                $.ajax({
                type: 'POST',
                url: '{{ route("merchant_request_pickup_show.update") }}',
                dataType:'json',
                data: {
                    _token: '{{ csrf_token() }}',
                    id:id,
                    category_id: category_id,
                    customer_receive: customer_receive,
                    // zoon_id: zoon_id,
                    location_id: location_id,
                    delivery_fee: delivery_fee,
                    delivery_status: delivery_status,
                    price: price,
                    bus_id: bus_id,
                    taxi_number: taxi_number,
                    description: description,
                    date_delivery : date_delivery,

                },
                success: function (data) {
                    if(data.box){
                        $('.result').find('.'+id).replaceWith(data.box);
                    }
                    $('.show-edit').hide();
                }
            });
            }

        });

          $(document).on('click', '.button-delete', function() {
             var id =$(this).data().id;
             $.confirm({
                title: 'Confirm!',
                content: 'Simple confirm!',
                buttons: {
                    confirm: function () {
                           $.ajax({
                            type: 'POST',
                            url: '{{ route("merchant_request_pickup_show.delete") }}',
                            dataType:'json',
                            data: {
                                _token: '{{ csrf_token() }}',
                                id: id,

                            },
                            success: function (data) {
                                $('.result').find('.'+id).remove();
                            }
                        });
                    },
                    cancel: function () {
                        $.alert('Canceled!');
                    }
                }
            });

          });

          $(document).on('click', '.btn-add' , function(){
            $('.box-name').find('.category_id').val('').change();
            $('.box-name').find('.customer_receive').val('');
            // $('.box-name').find('.zoon_id').val('').change();
            $('.box-name').find('.location_id').val('').change();
            $('.box-name').find('.delivery_fee').val('');
            $('.box-name').find('.delivery_status').val(1);
            $('.box-name').find('.bt_action').removeClass('off');
            $('.box-name').find('.price').val('');
            $('.box-name').find('.bus_id').val('No');
            $('.box-name').find('.taxi_number').val('');
            $('.box-name').find('.description').val('');
            $('.box-name').find('.btn-edit').removeClass('btn-update');
            $('.box-name').find('.btn-edit').addClass('btn-save');
            $('.box-name').find('.btn-edit').html('<i class="fa fa-plus"></i> Add New');
            $('.show-edit').show();
            $('select').select2();

          })
          $(document).on('click', '.btn-save',function(){
         
            var id = $('.box-name').find('.id').val();
            var category_id =$('.box-name').find('.category_id').val();
            var customer_receive =$('.box-name').find('.customer_receive').val();
            // var zoon_id =$('.box-name').find('.zoon_id').val();
            var location_id =$('.box-name').find('.location_id').val();
            var delivery_fee =$('.box-name').find('.delivery_fee').val();
            var delivery_status =$('.box-name').find('.delivery_status').val();
            var price =$('.box-name').find('.price').val();
            var bus_id =$('.box-name').find('.bus_id option:selected').text();
            var taxi_number =$('.box-name').find('.taxi_number').val();
            var description =$('.box-name').find('.description').val();
            var date_delivery =$('.box-name').find('.date_delivery').val();
           
            if(price == '' && location_id == ''&& customer_receive == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមជ្រើសរើសទីតាំង , បញ្ចូលតម្លៃ នឹង​លេខអ្នកទទួល​ ។',
                });
            }else if(customer_receive == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមបញ្ចូលលេខអ្នកទទួល។',
                });
            }else if(location_id == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមជ្រើសរើសទីតាំង។',
                });
            }
            else if(price == ''){
                $.alert({
                    title: 'ការព្រមាន!',
                    content: 'សូមបញ្ចូលតម្លៃ។',
                });
            }else if(price != '' && location_id != ''){
                $.ajax({
                type: 'POST',
                url: '{{ route("merchant_request_pickup_show.store") }}',
                dataType:'json',
                data: {
                    _token: '{{ csrf_token() }}',
                    id:id,
                    category_id: category_id,
                    customer_receive: customer_receive,
                    // zoon_id: zoon_id,
                    location_id: location_id,
                    delivery_fee: delivery_fee,
                    delivery_status: delivery_status,
                    price: price,
                    bus_id: bus_id,
                    taxi_number: taxi_number,
                    description: description,
                    date_delivery : date_delivery,
                },
                success: function (data) {
                    if(data.box){
                        $('.result').append(data.box);
                    }
                    $('.box-name').find('.category_id').val('').change();
                    $('.box-name').find('.customer_receive').val('');
                    // $('.box-name').find('.zoon_id').val('').change();
                    $('.box-name').find('.location_id').val('').change();
                    $('.box-name').find('.delivery_fee').val('');
                    $('.box-name').find('.delivery_status').val(1);
                    $('.box-name').find('.bt_action').removeClass('off');
                    $('.box-name').find('.price').val('');
                    $('.box-name').find('.bus_id').val('No');
                    $('.box-name').find('.taxi_number').val('');
                    $('.box-name').find('.description').val('');
                    $('.box-name').find('.date_delivery').val('{{date('d-m-Y')}}');
                    $('.show-edit').hide();
                }
            });
            }
          })


  </script>
@endsection
