@extends('layouts.app-mobile-merchant')

@section('content')
<?php Fun::lang()?>
<div class="mobile-dashboard">
    <div class="container">
        <div class="shipping-area">
            <div class="main-showdata">
                @foreach ($mr as $item)
                    <div class="col-md-6= col-sm-6 col-xs-12">
                        <div class="show-boxdata">
                            <div class="shop-left">
                                <p>Date : {{date('d-m-Y',strtotime($item->date))}}</p>
                            </div>
                            <div class="exchage-rate">
                                <p>Exchange Rate: <span>{{$item->exchange_rate}} riel</span></p>
                                <p>Status : <span>
                                @if ($item->status == 1)
                                    មិនទាត់ឃើញ
                                @elseif ($item->status == 2)
                                    បានឃើញ
                                @elseif ($item->status == 3)
                                    បានទទូល
                                @else
                                    រៀបចំដឹកជញ្ជូន​
                                @endif</span></p>
                                <p>PickUp By: <span>{{$item->driver_name}}</span></p>
                                <p>Phone number: <span><a href="tel:{{$item->phone}}">{{$item->phone}} </span></p>

                            </div>
                            <div class="button-show">
                                @if ($item->status == 1)
                                    <a href="{{route('cancel', ['id' => $item->id])}}"><button>cancel</button></a>
                                @endif
                            <a href="{{route('show', ['id' => $item->id])}}"><button>Show</button></a>
                            </div>
                        </div>
                    </div>
                @endforeach
                <div class="col-md-12">
                    <div class="button-plus">
                        <a href="{{route('merchant_pickup.create')}}"><button type="button" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus-circle"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .main-showdata .button-plus button{
        right: 10px !important;
        bottom: 85px !important;
        position: fixed !important;
    }
</style>
@endsection
