@extends('layouts.app-mobile')

@section('content')
    <?php Fun::lang(); ?>
    <style>
        .mobile-button .btn-edit {
            background: #66d6f4;
            padding: 4px;
            border-radius: 2px;
        }

        .mobile-text .texted-right {
            width: 49%;
            float: left;
            /* margin-top: -24px; */
        }

        .mobile-button {
            width: 100%;
            float: left;
            margin-left: 12%;
        }


    </style>

    <div class="container">
        <form action="{{ route('onDeliveryToDay') }}" method="POST"  enctype="multipart/form-data">
            @csrf
        <div class="form-search">

            <div class="form-group col-sm-6 col-xs-6" style="margin-bottom: 0px!important;
            margin-top: 105px!important;">
                <div class="form-group">
                    <label>Box Code</label>
                    {!! Form::text('box_code', null, array('class' => 'form-control box_code')) !!}
                </div>
            </div>

            <div class="col-sm-6 col-xs-6 float-right" style="margin-top: 131px!important;">
                <div class="form-group footer-save ">
                    <button type="button" class="button_success btn-sm search"><span class="fa fa-search"> Search</span></button>
                </div>
            </div>

        </div>
        </form>
        <div class="shipping-area shipping-detail" style="margin-top: 0px!important;">
            @foreach ($on_proccess as $key => $value)
                <?php

                $delivery_discount = '';
                if ($value->discount_type != null || $value->discount_type != '') {
                    if ($value->discount_type == 1) {
                        $delivery_fee = $value->discount;
                        $delivery_discount = '/  បញ្ចុះតំលៃ : $ ' . number_format($delivery_fee, 2);
                    } elseif ($value->discount_type == 2) {
                        $delivery_fee = ($value->discount * $value->delivery_fee) / 100;
                        $delivery_discount = '/  បញ្ចុះតំលៃ : $ ' . number_format($delivery_fee, 2);
                    } else {
                        $delivery_fee = number_format($value->delivery_fee, 2);
                    }
                } else {
                    $delivery_fee = $value->delivery_fee;
                }
                $delivery_fee = $value->delivery_status == 2 ? $delivery_fee : 0;
                $other_services_fee = 0;
                if ($value->other_services_fee > 0 && $value->other_services_pay_or_paid == 'pay' && $value->other_services_type == 2) {
                    $other_services_fee = $value->other_services_fee;
                }
                ?>
                <div class="col-md-6  col-sm-6 padd-0">
                    <div class="mobile-detail" style="position: relative;">
                        <b
                            style="position: absolute;top: 10px;right: 10px;width:30px;height: 30px;border-radius: 50%;border: 1px solid #2516d7;float: left;text-align: center;line-height: 2em;">{{ $key + 1 }}</b>
                        <div class="mobile-text">
                            <div class="texted-left">
                                <li>លេខកូដ: <span>{{ $value->box_code }} </span></li>
                                <li>ហាង: <span>{{ $value->shop_name }}</span></li>
                                {{-- <li>ទូរស័ព្ទ: <span><a href="tel:{{ $value->phone }}">{{ $value->phone }}</span></a>
                                </li> --}}
                                <li>ទីតាំង: <span>{{ $value->location }}</span></li>
                                <li>
                                    សម្គាល់: <span>{{ $value->description }}</span>
                                </li>
                                @if ($value->delivery_option != 'No')
                                    <li>ទូរស័ព្ទឡាន: <span>{{ $value->delivery_option }} (<a
                                                href="tel:$ }}value->taxi_number}}">{{ $value->phone }})</span></a></li>
                                    <li>ថ្លៃឡាន:
                                        <span>{{ $value->taxi_fee_symbol == "$" ? '$' . number_format($value->taxi_fee, 2) : $value->taxi_fee . ' ៛' }}
                                            {{ $value->taxi_status == 2 ? 'សេវាអ្នកទទួល' : '' }}​</span>
                                    </li>
                                @endif​
                            </div>
                            <div class="texted-right">
                                @if ($other_services_fee > 0)
                                    <li>តម្លៃសេវាផ្សេង: <span>${{ number_format($value->other_services_fee, 2) }}</span>
                                    </li>
                                @endif

                                <li>អ្នកទទួល: <span><a
                                            href="tel:{{ $value->customer_receive }}">{{ $value->customer_receive }}</span></a>
                                </li>
                                <li>តម្លៃ: <span>
                                        @php
                                            if ($value->total_product_status == 1) {
                                                $product_price = $value->total_product / $value->total_product_rate + $delivery_fee / $value->delivery_fee_rate;
                                            } elseif ($value->total_product_status == 2) {
                                                $product_price = $delivery_fee / $value->delivery_fee_rate;
                                            }
                                        @endphp
                                        $ {{ number_format($product_price, 2) }}
                                    </span></li>
                                <li>សេវា: <span>
                                        @php
                                            echo number_format(0, 2);
                                        @endphp
                                    </span></li>
                                <li>ប្រាក់ត្រូវទទូលពីភ្ញៀវសរុប: <span>$
                                        {{ number_format($product_price, 2) }}
                                    </span></li>
                            </div>
                            <div class="mobile-button">
                                <button class="btn-pending pending" data-id="{{ $value->id }}"
                                    data-status="2">មិនជោគជ័យ</button>
                                <button class="btn-cancel cancel" data-id="{{ $value->id }}"
                                    data-status="3">អត់យក</button>
                                @php
                                    $total_product_price = $value->total_product_status == 1 ? $value->price / $value->total_product_rate : 0;
                                    $total_delivery_fee = $value->delivery_fee_symbol == "$" ? $delivery_fee : $delivery_fee / $value->delivery_fee_rate;
                                @endphp
                                <button class="btn-edit edit_price" data-id="{{ $value->id }}"
                                    data-price="{{ $value->delivery_status == 2 ? $total_delivery_fee + $total_product_price + $other_services_fee : $total_product_price + $other_services_fee }}"
                                    data-delivery_option="{{ $value->delivery_option }}"
                                    data-currency="{{ $value->currency }}"
                                    data-taxi_status="{{ $value->taxi_status }}"
                                    data-taxi_shop_fee="{{ $value->taxi_shop_fee }}"
                                    data-taxi_cust_fee="{{ $value->taxi_cust_fee }}"
                                    data-taxi_number="{{ $value->taxi_number }}"
                                    data-total_riel="{{ $value->total_riel }}"
                                    data-total_dollar="{{ $value->total_dollar }}"
                                    data-extra_fee="{{ $value->extra_fee }}"
                                    data-extra_fee_type="{{ $value->extra_fee_type }}"
                                    data-user_currency="{{ $value->rate }}"
                                    data-driver_note="{{ $value->description }}"
                                    data-amount_pay_to="{{ $value->amount_pay_to }}"
                                    data-pay_to="{{ $value->pay_to }}" data-rate="{{ $value->rate }}" >កែរតម្លៃ
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

    </div>

    <script type="text/javascript">
        $('.search').on('click', function () {
            $(this).closest('form').submit();
        });
        $('.done').on('click', function() {
            var id = $(this).data('id');
            var status = $(this).data('status');
            $.confirm({
                icon: 'fa fa-smile-o',
                theme: 'modern',
                title: 'កញ្ចប់នឹងជោកជ័យ!',
                closeIcon: true,
                content: ' ',
                animation: 'scale',
                type: 'green',
                buttons: {
                    close: {
                        text: 'បិទ',
                        action: function() {

                        }
                    },
                    ok: {
                        text: 'យល់ព្រម',
                        action: function() {
                            location.href = "/delivery-action/" + id + "/" + status;
                        }
                    },
                }
            });
        });
        $('.pending').on('click', function() {
            var id = $(this).data('id');
            var status = $(this).data('status');
            $.confirm({
                title: 'កញ្ចប់នឹងមិនជោកជ័យ!',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'blue',
                content: `
            <form action="" class="formName">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-sm-6 col-xs-6">
                                <label for="r1"><input type="radio" name="reason" value="តេអត់លើក"> តេអត់លើក<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r2"><input type="radio" name="reason" value="តេអត់ចូល"> តេអត់ចូល<br></label>
                            </div>
<!--                            <div class="col-sm-6 col-xs-6">-->
<!--                                <label for="r3"><input type="radio" name="reason" value="ទាក់ទងអត់បាន"> ទាក់ទងអត់បាន<br></label>-->
<!--                            </div>-->
                            <div class="col-sm-6 col-xs-6">
                                <label for="r4"><input type="radio" name="reason" value="ចល័តទីតាំង "> ចល័តទីតាំង <br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r5"><input type="radio" name="reason" value="ភ្ញៀវសុំស្អែក"> ភ្ញៀវសុំស្អែក<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r5"><input type="radio" name="reason" value="សុំដឹកស្អែក"> សុំដឹកស្អែក<br></label>
                            </div>

                            <div class="col-sm-12 col-xs-12">
                                <input name="other" placeholder="ផ្សេងៗ" class="form-control note" value="">
                            </div>
                        </div>
                    </div>
                </form>`,
                buttons: {
                    close: {
                        text: 'បិទ',
                        action: function() {

                        }
                    },
                    ok: {
                        text: 'យល់ព្រម',
                        action: function() {
                            var reason = this.$content.find('input[name="reason"]:checked').val();
                            var other = this.$content.find('input[name="other"]').val();
                            if (!reason) {
                                reason = '';
                                if (!other) {
                                    $.alert('មិនយកដោយសារមូលហេតុអ្វី?');
                                    other = '';
                                    return false;
                                }
                            }
                            var why = reason + ' ' + other;
                            location.href = "/delivery-action/" + id + "/" + status + "/" + why;
                        }
                    },


                },
            });
        });
        $('.cancel').on('click', function() {
            var id = $(this).data('id');
            var status = $(this).data('status');
            $.confirm({
                title: 'កញ្ចប់នឹងមិនយកទេ!',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'orange',
                content: `
		    	<form action="" class="formName">
		    		<div class="form-group">
			    		<div class="row">
                            <div class="col-sm-12 col-xs-12">
                                {!! Form::text('reason', null, ['placeholder' => 'មូលហេតុ', 'class' => 'form-control']) !!}
                            </div>
                        </div>
			    	</div>
			    </form>`,
                buttons: {
                    close: {
                        text: 'បិទ',
                        action: function() {

                        }
                    },
                    close: {
                        text: 'យល់ព្រម',
                        action: function() {
                            var reason = this.$content.find('input[name="reason"]').val();
                            if (!reason) {
                                $.alert('មិនយកដោយសារមូលហេតុអ្វី?');
                                return false;
                            }
                            var why = reason;
                            location.href = "/delivery-action/" + id + "/" + status + "/" + why;
                        }
                    },

                },
            });
        });
        var price;




        $(document).on('change', 'select[name="extra_fee_type"]', function() {
            $('input[name="currency_usd"]').val(0);
            $('input[name="currency_rial"]').val(0);
            $('input[name="extra_fee"]').val('');
            $('input[name="total_price"]').val(parseFloat(price));
        });

        $(document).on('keyup', 'input[name="extra_fee"]', function() {

            var extra_fee_type = $('select[name="extra_fee_type"]').val();
            var extra_fee = $(this).val();

            if (extra_fee_type == 2) {
                var total = parseFloat(extra_fee) + parseFloat(price);
                $('input[name="total_price"]').val(total);
                $('input[name="currency_usd"]').val(0);
            }
            if ($(this).val() == '') {
                $('input[name="total_price"]').val(price);
                $('input[name="currency_usd"]').val(0);
                $('input[name="currency_rial"]').val(0);
                $('input[name="extra_fee"]').val('');
            }
            if (extra_fee_type == '') {
                $.confirm({
                    title: 'សូមជ្រើសរើសថ្លៃសេវាបន្ថែម!',
                    theme: 'bootstrap',
                    closeIcon: true,
                    animation: 'scale',
                    type: 'purple',
                    content: '',
                    buttons: {
                        close: function() {

                        }
                    },
                });
            }
        });

        $('.edit_price').on('click', function() {
            var id = $(this).data('id');
            var delivery_option = $(this).data('delivery_option');
            var currency = $(this).data('currency');
            var taxi_status = $(this).data('taxi_status');
            var taxi_shop_fee = $(this).data('taxi_shop_fee');
            var taxi_cust_fee = $(this).data('taxi_cust_fee');
            var taxi_number = $(this).data('taxi_number');
            var total_riel = $(this).data('total_riel');
            var total_dollar = $(this).data('total_dollar');
            var extra_fee = $(this).data('extra_fee');
            var extra_fee_type = $(this).data('extra_fee_type');
            var user_currency = $(this).data('user_currency');
            var driver_note = $(this).data('driver_note');
            var amount_pay_to = $(this).data('amount_pay_to');
            var pay_to = $(this).data('pay_to');
            let rate = $(this).data('rate');
            console.log(rate);

            price = '';
            price = parseFloat($(this).data('price'));
            var option = '';
            var selected = '';
            var taxi_price = '';


            if (taxi_status == 1) {
                selected = `<option value="">សេវាផ្ញើរឡាន</option>
                        <option value="1" selected>ហាងចេញ</option>
                        <option value="2">អតិថិជនចេញ</option>`;
                taxi_price = taxi_shop_fee;
            } else if (taxi_status == 2) {
                selected = `<option value="">សេវាផ្ញើរឡាន</option>
                        <option value="1">ហាងចេញ</option>
                        <option value="2" selected>អតិថិជនចេញ</option>`;
                taxi_price = taxi_cust_fee;
            } else {
                selected = `<option value="">សេវាផ្ញើរឡាន</option>
                        <option value="1">ហាងចេញ</option>
                        <option value="2">អតិថិជនចេញ</option>`;
                taxi_price = '';
            }
            if (extra_fee_type == 0) {
                var total_price = (parseFloat($(this).data('price')));
                selected1 = `<option value="" selected>ថ្លៃសេវាបន្ថែម</option>
                        <option value="1" >ហាងចេញ</option>
                        <option value="2">អតិថិជនចេញ</option>`;
            } else if (extra_fee_type == 1) {
                var total_price = (parseFloat($(this).data('price')));
                selected1 = `<option value="">ថ្លៃសេវាបន្ថែម</option>
                        <option value="1" selected >ហាងចេញ</option>
                        <option value="2"  >អតិថិជនចេញ</option>`;
            } else {
                var total_price = (parseFloat($(this).data('extra_fee')) + parseFloat($(this).data('price')));
                selected1 = `<option value="">ថ្លៃសេវាបន្ថែម</option>
                        <option value="1">ហាងចេញ</option>
                        <option value="2" selected>អតិថិជនចេញ</option>`;
            }


            if (user_currency) {
                user_currency = "Note: " + user_currency;
            }
            console.log(KHCurrenc(''+(total_price.toFixed(2) * rate)));
            console.log(total_price.toFixed(2));
            if (delivery_option == 'No') {
                option = `

                        <div class="col-sm-6 col-xs-6" style="display: none;">
                            <div class="form-group">
                                <select name="extra_fee_type" class="form-control chosen-select"​>
                                    ${selected1}
                            </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6" style="display: none;">
                            <div class="form-group">
                                <input type="text" name="extra_fee" value="${extra_fee}" class="form-control" placeholder="ថ្លៃសេវាបូកបន្ថែម">
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
	                        <div class="form-group">
                                <input type="hidden" value="${currency}" name="currency">
                                <input type="hidden" value="no_taxi" name="status">
                                <input type="text" name="" class="form-control " value="$${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}" readonly>
                                <input type="hidden"  name="total_price"   value="${parseFloat(total_price)}" >
                                <input type="hidden"  name="rate"   value="${rate}" >
                                &nbsp;${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛
                            </div>
                        </div>
                        <div class="col-md-12">
                            Missing USD :<span class="missing_dor"> $${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</span>
                            Missing KH : <span class="missing_riel">${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛</span>
                        </div>


	                    <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="currency_usd" class="form-control number-only" value="${total_riel == 0  && total_dollar == 0 ? 0 : total_dollar }"    step="any">

					    	</div>
                        </div>
	                    <div class="col-sm-6 col-xs-6">
	                        <div class="form-group">
                            <input type="number" name="currency_rial" value="${total_riel}" class="form-control number-only" placeholder="ទទួលបានលុយខ្មែរ" step="any">

					    	</div>
	                    </div>
                        <div class="col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <span> Pay To :    </span>  <br>
                                        <input type="radio" id="Default" ${pay_to == '' ? ' checked ' : ''} name="pay_to" class="pay_to" value="">
                                        <label for="Default">Cash</label>  &nbsp;&nbsp;&nbsp;
                                        <input style="display:none" type="radio" id="delivery" ${pay_to == 'delivery' ? ' checked ' : ''} name="pay_to" class="pay_to" value="delivery">
                                            <label style="display:none" for="delivery">ABA KL</label>

                                        <!--<input type="radio" id="shop" ${pay_to == 'shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="shop">
                                        <label for="shop">ABA Shop</label> &nbsp;&nbsp;&nbsp;

                                        <input type="radio" id="ac_shop" ${pay_to == 'ac_shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="ac_shop">
                                        <label for="ac_shop">ACLEDA Shop</label><br>-->
                                    </div>
                                </div>

                        <div class="col-sm-12 col-xs-12 amount_pay_to_aba" ${pay_to == '' ? 'style="display: none;"' : ''} >
                            <div class="form-group">
                                <input type="text" class="form-control number-only aba_pay_to" placeholder="ចំនួនទឹកប្រាក់ ($)" name="amount_pay_to_aba" value="${amount_pay_to}">
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <textarea class="form-control" name="driver_note" rows="2" cols="50" placeholder="note" >${driver_note}</textarea>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <span> ${user_currency}  </span>
                            </div>
                        </div>

                        `;
            } else {
                option = `


                        <div class="col-sm-6 col-xs-6" >
                            <div class="form-group">
				    			<select name="taxi_status" class="form-control chosen-select"​>
			                       ${selected}
			                   </select>
					    	</div>
                        </div>
                        <div class="col-sm-6 col-xs-6" >
                            <div class="form-group">
                            	<input type="hidden" value="${currency}" name="currency">
                            	<input type="hidden" value="have_taxi" name="status">
				    			<input type="number" name="taxi_fee" value="${taxi_price}" class="form-control" step="any" placeholder="តម្លៃសេវាឡាន">
					    	</div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="taxi_number" value="${taxi_number}" class="form-control" placeholder="លេខឡាន">
                            </div>
                        </div>

                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="" value="${delivery_option}" class="form-control" readonly placeholder="លេខឡាន">
                            </div>
                        </div>

                        <div class="col-sm-6 col-xs-6" style="display: none;">
                            <div class="form-group">
                                <select name="extra_fee_type" class="form-control chosen-select"​>
                                    ${selected1}
                            </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6" style="display: none;">
                            <div class="form-group">
                                <input type="text" name="extra_fee" value="${extra_fee}" class="form-control" placeholder="ថ្លៃសេវាបូកបន្ថែម">
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
	                        <div class="form-group">
                                <input type="hidden" value="${currency}" name="currency">
                                <input type="hidden" value="no_taxi" name="status">
                                <input type="text" name="" class="form-control " value="$${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}" readonly>
                                <input type="hidden"  name="total_price"   value="${parseFloat(total_price)}" >
                                <input type="hidden"  name="rate"   value="${rate}" >
                                &nbsp;${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛
                            </div>
                        </div>
                        <div class="col-md-12">
                            Missing USD :<span class="missing_dor"> $${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</span>
                            Missing KH : <span class="missing_riel">${KHCurrenc(''+(total_price.toFixed(2) * rate))}៛</span>
                        </div>

                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="currency_usd" class="form-control number-only" value="${total_riel == 0  && total_dollar == 0 ? 0 : total_dollar}"    step="any">
					    	</div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="number" name="currency_rial" value="${total_riel}" class="form-control number-only" placeholder="ទទួលបានលុយខ្មែរ" step="any">
					    	</div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <span> Pay To :    </span>  <br>
                                        <input type="radio" id="Default" ${pay_to == '' ? ' checked ' : ''} name="pay_to" class="pay_to" value="">
                                        <label for="Default">Cash</label>  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <input style="display:none" type="radio" id="delivery" ${pay_to == 'delivery' ? ' checked ' : ''} name="pay_to" class="pay_to" value="delivery">
                                            <label style="display:none" for="delivery">ABA KL</label>

                                        <!--<input type="radio" id="shop" ${pay_to == 'shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="shop">
                                        <label for="shop">ABA Shop</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                        <input type="radio" id="ac_shop" ${pay_to == 'ac_shop' ? ' checked ' : ''}  name="pay_to"  class="pay_to" value="ac_shop">
                                        <label for="ac_shop">ACLEDA Shop</label><br>-->
                                    </div>
                                </div>

                        <div class="col-sm-12 col-xs-12 amount_pay_to_aba" ${pay_to == '' ? 'style="display: none;"' : ''} >
                            <div class="form-group">
                                <input type="text" class="form-control number-only aba_pay_to" placeholder="ចំនួនទឹកប្រាក់ ($)" name="amount_pay_to_aba" value="${amount_pay_to}">
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <textarea class="form-control" name="driver_note" rows="2" cols="50" placeholder="note" >${driver_note}</textarea>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <span> ${user_currency}  </span>
                            </div>
                        </div>`;
            }

            $.confirm({
                title: 'កែសម្រួលតម្លៃ!',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'purple',
                content: `
		    	<form action="" class="formName">
			    	<div class="row">
                        <input type="hidden" value="${id}" name="id">
                        ${option}
                    </div>
			    </form>`,
                buttons: {
                    cancel: {
                        text: 'បិទ',
                        btnClass: 'btn-red bt-cancel',
                        action:function() {
                        },
                    },
                    ok: {
                        text: 'យល់ព្រម',
                        btnClass: 'btn-blue',
                        action:function() {
                            var status = this.$content.find('input[name="status"]').val();
                            var driver_note = this.$content.find('textarea[name="driver_note"]').val();
                            var amount_pay_to_aba = this.$content.find('input[name="amount_pay_to_aba"]')
                                .val();
                            let pay_to = $('input[name="pay_to"]:checked').val();
                            var taxi_status = this.$content.find('select[name="taxi_status"]').val();
                            var taxi_fee = this.$content.find('input[name="taxi_fee"]').val();
                            var taxi_number = this.$content.find('input[name="taxi_number"]').val();
                            var currency_usd = this.$content.find('input[name="currency_usd"]').val();
                            var currency_rial = this.$content.find('input[name="currency_rial"]').val();
                            var extra_fee = this.$content.find('input[name="extra_fee"]').val();
                            var extra_fee_type = this.$content.find('select[name="extra_fee_type"]').val();
                            var id = this.$content.find('input[name="id"]').val();
                            if (pay_to) {
                                if (amount_pay_to_aba < 1 || amount_pay_to_aba == '') {
                                    if (!name) {
                                        $.alert('provide a valid Amount PayTo');
                                        return false;
                                    }
                                }
                            }
                            let over = false;
                            let overpaid = false;
                            let missing_dor = $('body .missing_dor').text().replace('$', '');
                            let missing_riel = $('body .missing_riel').text().replace('៛', '');
                            let total_missing = parseFloat(missing_riel);
                            let total_price = $('input[name="total_price"]').val();
                            let rate = $('input[name="rate"]').val();

                            let message = "Sorry You Pay Not Engough";
                            if(total_missing != 0){
                                //Pay less than 10 dollars || ខ្វះ 500 ៛
                                if(total_missing > 1){
                                    over = true;
                                }
                                if(total_missing < -1){
                                    overpaid = true;
                                }
                            }
                            if(over == true){
                                $.alert({
                                    title: 'Pay',
                                    content: message,
                                    type: 'red',
                                });
                                return false;
                            }
                            if(overpaid == true){
                                $.alert({
                                    title: 'Pay',
                                    content: 'You have overpaid',
                                    type: 'red',
                                });
                                return false;
                            }



                            form = new FormData();
                            form.append('_token', "{{ csrf_token() }}");

                            form.append('status', status);
                            form.append('driver_note', driver_note);
                            form.append('amount_pay_to_aba', amount_pay_to_aba);
                            form.append('pay_to', pay_to);
                            form.append('taxi_status', taxi_status);
                            form.append('taxi_fee', taxi_fee);
                            form.append('taxi_number', taxi_number);
                            form.append('currency_usd', currency_usd);
                            form.append('currency_rial', currency_rial);
                            form.append('extra_fee', extra_fee);
                            form.append('extra_fee_type', extra_fee_type);
                            form.append('total_price', total_price);
                            form.append('rate', rate);
                            form.append('id', id);

                            $.ajax({
                                type: 'POST',
                                url: '{{ route('deliveryActionEditPrice1') }}',
                                data: form,
                                cache: false,
                                contentType: false,
                                processData: false,
                                async: false,
                                success: function(response) {
                                    if (response == 200) {
                                        location.reload();
                                    }
                                    if(response.status == 403){
                                        $.alert({
                                            title: 'Pay',
                                            content: response.message,
                                            type: 'red',
                                        });
                                    }
                                },
                                error: function(xhr, status, error) {
                                    alertErrorFormController(xhr);
                                    console.log(xhr)
                                }
                            });
                            return false;
                        },
                    },
                },

                onContentReady: function() {
                    // bind to events
                    var jc = this;
                    this.$content.find('form').on('submit', function(e) {
                        // if the user submits the form by pressing enter in the field.
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click'); // reference the button and click it
                    });
                    caculate();
                    if($('input[name="amount_pay_to_aba"]').val()){
                        $('input[name="currency_usd"]').val(0);
                        $('input[name="currency_usd"]').attr('readonly',true);
                    }
                    $('input[type=radio][name=pay_to]').change(function() {

                        if ($(this).val()) {
                            $('.amount_pay_to_aba').show();
                            $('input[name="currency_usd"]').val(0);
                            $('input[name="currency_usd"]').attr('readonly',true);
                        } else {
                            $('.amount_pay_to_aba').hide();

                            $('input[name="amount_pay_to_aba"]').val(0);
                            $('input[name="currency_usd"]').val(0);
                            $('input[name="currency_usd"]').attr('readonly',false);


                        }

                    });
                }
            });
        });
        $(document).on('keyup', 'input[name="currency_rial"],input[name="currency_usd"],.aba_pay_to', function() {
            caculate();
        });

        function caculate() {
            let pay_dol = $('input[name="currency_usd"]').val();
            let pay_riel = $('input[name="currency_rial"]').val();
            let aba_pay = $('.aba_pay_to').val() ? $('.aba_pay_to').val() : 0;

            let rate = $('input[name="rate"]').val();
            let convert_to_dol = parseFloat(pay_riel ? pay_riel : 0) / rate;
            let total_paid = parseFloat(pay_dol ? pay_dol : 0) + convert_to_dol + parseFloat(aba_pay ? aba_pay : 0);
            let price = $('input[name="total_price"]').val();
            let missing = price - (total_paid);
            $('.missing_dor').text('$ ' + missing.toFixed(2));
            $('.missing_riel').text(KHCurrenc('' + missing.toFixed(2) * rate) + '៛');
        }

    </script>
@endsection
