@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.user')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.user')}}</h3>
	                </div>
	                <div class="pull-right" style="margin-top: 20px">
                        {{-- @if(Gate::check('User create')) --}}
                            <a href="{{route('users.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>
                        {{-- @endif --}}

	                </div>
	            </div>
	        </div>
	    </div>
	</div>
	 <div class="wrapper-table">
		<table width="100%" class="table table-striped table-hover datatable">
			 <thead>
				<tr>
					<th>#</th>
					<th>{{__('administrator.profile')}}</th>
					<th>{{__('administrator.name')}}</th>
					<th>{{__('administrator.email_user_name')}}</th>
					<th>{{__('administrator.phone_number')}}</th>
					<th>{{__('administrator.gender')}}</th>
					<th>{{__('administrator.roles')}}</th>
					<th>{{__('administrator.action')}}</th>
				</tr>
			</thead>
			<tbody>
				{{-- @foreach($users as $key=>$value)
				<tr>
						<td>{{$key+1}}</td>
						<td><img class="img-detail zoom" src="/images/upload/{{$value->avartar}}" width="40"></td>
						<td>{{$value->name}}</td>
						<td>{{$value->email}}</td>
						<td>{{$value->phone}}</td>
						<td>{{$value->gender}}</td>
						<td>{{$value->roles->first() ? ucfirst($value->roles->first()->name) : '' }}</td>
						<td width="25%">
                        @if(Gate::check('User Edit'))
							@if(Auth::user()->id == $value->id)
								<label class="btn btn-success btn-xs">Active</label>
							@else
							    <input data-id="{{$value->id}}" data-size="mini" class="toggle-class " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" {{ $value->status ? 'checked' : '' }}>
							@endif

                            <a href="{{route('users.edit',$value->id)}}" class="button_info">{{__('administrator.edit')}}</a>
                        @endif

						</td>
				</tr>
				@endforeach --}}
			</tbody>
		</table>
	</div>
</div>


@endsection



@section('script')
<script type="text/javascript">
	$(function() {
		// $('.toggle-class').change(function() {
		// 	var status = $(this).prop('checked') == true ? 1 : 0;
		// 	var user_id = $(this).data('id');

		// 	$.ajax({
		// 		type: "GET",
		// 		dataType: "json",
		// 		url: '/nso/user-status',
		// 		data: {'status': status, 'user_id': user_id, "_token": "{{ csrf_token() }}"},
		// 		success: function(data){
		// 		console.log(data.success)
		// 		}
		// 	});
		// })


		$('.datatable').DataTable({
                    "oLanguage": {
                        "sSearch": "{{__('administrator.search')}}:",
                        "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                        "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                        "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                        "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                        "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                        "oPaginate": {
                            "sFirst": "{{__('administrator.first')}}",
                            "sLast": "{{__('administrator.last')}}",
                            "sNext": "{{__('administrator.next')}}",
                            "sPrevious": "{{__('administrator.prevoius')}}"
                        },
                    },
                    ordering: false,
                    serverSide: true,
                    responsive:true,
                    lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
                    ajax: window.location,
                    columns:
                        [
                            {data: 'DT_RowIndex',searchable:false},
                            {data: 'image'},
                            {data: 'name'},
                            {data: 'email'},
                            {data: 'phone'},
                            {data: 'gender'},
                            {data: 'role'},
                            {data: 'action'},


                        ],

                    "initComplete": function (settings, json) {
                        
                        
                        
                    },"drawCallback": function( settings ) {
                        $('.toggle').bootstrapToggle({
                            on: 'Enabled',
                            off: 'Disabled',
                            size : 'small',
                            offstyle : 'danger' 
                        });
                        $('.toggle').click(function(){
                            console.log(2);
                            let toggle = $(this).find('.dis_and_en');
                            let value = parseInt(toggle.val()) == 0 ? parseInt(toggle.val()) + 1 : parseInt(toggle.val()) - 1;
                            toggle.val(value);
                            let route = toggle.data('route');
                            let type = toggle.data('type');
                            $.ajax({
                                type: "DELETE",
                                url: route,
                                data: {
                                    _token:'{{csrf_token()}}',
                                    type:type,
                                    status:value
                                },
                                success: function (response) {
                                    
                                }
                            });
                        })
                    }
                });
            $('.select2').select2({
                theme: 'bootstrap4'
            })
  })
</script>
@stop



