@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('users.index')}}">{{__('administrator.user')}}</a></li>
            <li class="active">{{__('administrator.create_new')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.user')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

             {!! Form::model($user, ['method' => 'PATCH','route' => ['users.update', $user->id],'enctype'=>'multipart/form-data']) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.employee')}} <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.full_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name', null, array('placeholder' => __('administrator.full_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.sex')}} </label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('gender', ['Male'=>'Male','Female'=>'Female'],null, array('class' => 'form-control select2','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.roles')}} </label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control select2','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.email_user_name')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('email', $user->email, array('placeholder' => __('administrator.employee_email'),'class' => 'form-control','required','autocomplete'=>'off')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.phone_number')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('phone', null, array('placeholder' => __('administrator.phone_number'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.password')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::password('password', array('placeholder' => __('administrator.password'),'class' => 'form-control')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">{{__('administrator.confirm_password')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::password('confirm_password', array('placeholder' => __('administrator.confirm_password'),'class' => 'form-control')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.profile')}}</label>

                            </div>
                            <div class="form-group col-sm-9">
                               <input id="input-44" type="file" name="avartar" class="">
                                {{-- @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach --}}
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="arrayImg" value="{{$user->avartar}}" id="{{$user->avartar}}">
            {!! Form::close() !!}
            <input type="hidden" name="src" value="{{asset('/images/upload/')}}">
        </div>
    </div>
@endsection
@section('script')
<script type="text/javascript">

      var src_image = $('input[name="src"]').val();
      $(document).ready(function() {
        var images = [];
        var caption = [];
        $('input[name="arrayImg"]').each(function(i, e){
            var obj = {
                caption: e.id,
                width: '120px'
            };
            images.push(src_image +'/'+e.value);
            caption.push(obj);
        });
        $("#input-44").fileinput({
            initialPreview: images,
            initialPreviewAsData: true,
            initialPreviewConfig: caption,
            uploadUrl: "/",
            maxFilePreviewSize: 10240,
            overwriteInitial: false,
        });
    });
      $(document).on('click', '.kv-file-remove', function(){
        var src = $(this).closest('.kv-preview-thumb').find('img').attr('src');
        $('input[name="arrayImg"]').each(function(){
            var thiss = $(this).val();
            if ( (src_image+'/'+thiss) == src){
                $(this).remove();
            }
        });
        $('input[name="new_arrayImg"]').each(function(){
            var thiss = $(this).val();
            if ( thiss == src){
                $(this).remove();
            }
        });
        $(this).closest('.kv-preview-thumb').remove();
    });

    $(document).on('change', 'input[name="gallery"]', function(){
        readURL(this);
    });
      function readURL(input) {
        for (let i = 0; i < input.files.length; i++) {
            if (input.files) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#appended').append('<input type="text" name="new_arrayImg" value="'+e.target.result+'" id="'+e.target.result+'">')
                }
                reader.readAsDataURL(input.files[i]);
            }
        }


    }
    $(document).on('click', '.fileinput-remove-button', function(){
        $('input[name="arrayImg"]').each(function(){
            $(this).remove();
        });
        $('input[name="new_arrayImg"]').each(function(){
            $(this).remove();
        });
        $('.kv-preview-thumb').each(function(){
            $(this).remove();
        });
    });

</script>
@endsection
