@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.report_stock')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="wrapper center-block">
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                <div class="panel panel-default">
                <div class="panel-heading active" role="tab" id="headingOne">
                    <h4 class="panel-title">
                    <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Filtering
                    </a>
                    <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            <i class="fa fa-arrow-down"></i>
                    </a>
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body" style="padding: 0 !important;border: none !important;">
                        <br>
                        <div class="col-sm-12">
                            {!! Form::open(array('route' => 'stock_balance_print','method'=>'POST')) !!}
                                @if(\Globals::is_Administrator() == 'Administrator')
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for="">{{__('administrator.shop_name')}}</label>
                                    {!! Form::select('merchant', $merchant, null, ['class' => 'form-control' ]) !!}
                                </div>
                                @endif
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for="">{{__('administrator.product_name')}}</label>
                                    {!! Form::select('product', $product, null, ['class' => 'form-control'  ]) !!}
                                </div>
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for="">{{__('administrator.category')}}</label>
                                    {!! Form::select('category', $category, null, ['class' => 'form-control'  ]) !!}
                                </div>
                                <div class="form-group col-sm-3 col-xs-4">
                                    <label for="">{{__('administrator.barcode')}}</label>
                                    {!! Form::text('barcode', null, array('placeholder' => __('administrator.barcode'),'class' => 'form-control  ' )) !!}
                                </div>
                                <div class="col-sm-12 col-xs-12">
                                    <div class="form-group footer-save">
                                        <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span>{{__('administrator.searching')}} </button>
                                        <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> {{__('administrator.print')}} </button>
                                    </div>
                                </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
                </div>
           
          </div>
        </div>
        <div class="row">
            
           
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>{{__('administrator.no')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.phone_number')}}</th>
                    <th>{{__('administrator.product_name')}}</th>
                    <th>{{__('administrator.product_code')}}</th>
                    <th>{{__('administrator.category')}}</th>
                    <th>{{__('administrator.price')}}</th>
                    <th>{{__('administrator.in_stock')}}</th>
                    <th>{{__('administrator.out_stock')}}</th>
                    <th>{{__('administrator.balance_stock')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


@endsection



@section('script')
<script type="text/javascript">
      $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        // ajax: "{{route('datatble_stock_balance')}}",
        ajax:{
            url: "{{route('datatble_stock_balance')}}",
            "data": function ( d ) {
                d.merchant = $('select[name="merchant"]').val(),
                d.category = $('select[name="category"]').val(),
                d.barcode = $('input[name="barcode"]').val(),
                d.product = $('select[name="product"]').val()
            }
           
        },
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'shop_name'},
                {data: 'phone'},
                {data: 'product_name'},
                {data: 'product_code'},
                {data: 'category_name'},
                {data: 'price'},
                {data: 'in_stock'},
                {data: 'out_stock'},
                {data: 'stock_qty'},
            ],

        "initComplete": function (settings, json) {
        }
    });

    function searching()
    {   
        $('#datatable_income').DataTable().ajax.reload();
        return false;
        var merchant = $('select[name="merchant"]').val();
        var category = $('select[name="category"]').val();
        var product = $('select[name="product"]').val();
        var barcode = $('input[name="barcode"]').val();
        var table = '';
        var account_name = '';
        $.ajax({
            url: "{{ Route('datatble_stock_balance') }}",
            method: "POST",
            dataType: "json",
            data: {
                merchant: merchant,
                category: category,
                barcode: barcode,
                product: product,
                _token: '{{ csrf_token() }}',
            },
            success: function (data) {
                $.each(data, function(index, val) {
                    table += `
                        <tr>
                            <td>${ index+1 }</td>
                            <td>${ val.shop_name }</td>
                            <td>${ val.phone }</td>
                            <td>${ val.product_name }</td>
                            <td>${ val.product_code }</td>
                            <td>${ val.category_name }</td>
                            <td> $${ val.price }</td>
                            <td> ${ val.stock_qty }</td>

                        </tr>
                    `;
                });
                $('.tbody').empty().append(table);
            }
        });
    }
</script>
@stop



