@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
<style>
    .a.tab{
        padding: 10px;
        border: 1px solid blue;
    } 
    .a.tab:not(:last-child){
        border-bottom: none !important;
    }
    .a.tab:hover{
        opacity: .4;
        background: gainsboro;
        transition: 0.5s all ease;
    }
    .a.tab.active{
        background: ghostwhite;
    }


    legend {
        display: block;
        padding: 0;
        margin-bottom: 0 !important;
        font-size: 21px;
        line-height: inherit;
        color: #333;
        border: 0;
        width: auto !important;
        /* border-bottom: none !important; */
    }
    fieldset {
        /* min-width: 0; */
        /* padding: 0; */
        /* margin: 0; */
        /* border: 0; */
    }
    fieldset {
        border: 1px solid blue !important;
        margin: 0 2px;
        padding: 0.35em 0.625em 0.75em;
    }

</style>

<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
      <li><a href="#">{{__('administrator.manage_setting')}}</a></li>
            <li><a href="{{route('roles.index')}}">{{__('administrator.roles')}}</a></li>
      <li class="active">{{__('administrator.edit')}}</li>
    </ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <h3>Edit Role </h3>
            </div>
        </div>
    </div>
    {!! Form::model($role, ['method' => 'PATCH','route' => ['roles.update', $role->id]]) !!}
    
    <div class="row">
        <div class="col-md-12" style="padding: 0">
            <div class="form-group col-sm-3 col-xs-12" style="padding: 0">

                <label class="required">Title</label>
                {!! Form::text('name', null, array('placeholder' => 'Title','class' => 'form-control')) !!}
            </div>    
        </div>        
        <div class="col-md-2" style="background: grey;padding: 0;text-align: center">
            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                @foreach ($group_name as $key=>$val)
                    <a style=" float: left;width: 100%" class="a tab nav-link {{$key==0?"active":""}}" id="tab{{$val->group_name}}tab" data-toggle="pill" href="#tab{{$val->group_name}}" role="tab" aria-controls="v-pills-home" aria-selected="true">{{$val->group_name}}</a>
                @endforeach
            </div>
        </div>
        <div class="col-md-10" style="padding: 0;background: rgb(201, 195, 195)">
          <div class="tab-content" id="v-pills-tabContent">
            @foreach ($group_name as $key=>$val)
                <div class="tab-pane fade {{$key==0?"active in":""}}" id="tab{{$val->group_name}}" role="tabpanel" aria-labelledby="tab{{$val->group_name}}tap">
                    <div class="col-xs-12 col-sm-12 col-md-12" style="border: 1px solid white">
                        <label class="col-sm-12  checkbox-list" style="margin-top: 10px">
                            {{ Form::checkbox('check-all', null,allPermission($role->id,$val->group_name)->count() == permmissionByGroupName($val->group_name)->count() ? true : false  , array('class' => 'check-all un-check'.$val->group_name.'','data-checkall'=>''.$val->group_name.'','data-count'=>permmissionByGroupName($val->group_name,1)->count())) }} Select All 
                            <span class="checkmark"></span>
                        </label>
                    
                        <div class="form-group">
                            @foreach (permmissionByGroupName($val->group_name,1) as $per)
                                <label class="col-sm-3  checkbox-list" style="margin-bottom: 10px !important">
                                    {{ Form::checkbox('permission[]', $per->id, in_array($per->id, $rolePermissions) ? true : false, array('class' =>'un-check '.$val->group_name.'','data-un-check'=>''.$val->group_name.'')) }} {{ $per->name }}
                                    <span class="checkmark"></span>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-md-12">
                        @foreach (permmissionByGroupName($val->group_name,1,1) as $per)
                            <fieldset>
                                <legend>{{$per->name}}</legend>
                                
                                <div class="form-group">
                                    <label class="col-sm-12  checkbox-list" style="margin-top: 10px">
                                        {{ Form::checkbox('check-all', null,allPermission($role->id,$per->name,$per->name)->count() == permmissionBySubName($per->name,1)->count() ? true : false  , array('class' => 'check-all un-check'.$per->name.'1','data-checkall'=>''.$per->name.'1','data-count'=>permmissionByGroupName($val->group_name,1)->count())) }} Select All 
                                        <span class="checkmark"></span>
                                        
                                    </label>
                                    @foreach (permmissionBySubName($per->name) as $per1)
                                        <label class="col-sm-3  checkbox-list" style="margin-bottom: 10px !important">
                                            {{ Form::checkbox('permission[]', $per1->id, in_array($per1->id, $rolePermissions) ? true : false, array('class' =>'un-check '.$per->name.'1','data-un-check'=>''.$per->name.'1')) }} {{ $per1->name }} 
                                            <span class="checkmark"></span>
                                        </label>
                                    @endforeach    
                                </div>
                            </fieldset>
                            
                        @endforeach
                        {{--  --}}
                        
                    </div>
                    <div class="col-md-12">
                        <div class="row">
                            @foreach (subGroup($val->group_name) as $key=>$sub)
                                <div class="col-md-12">
                                    <fieldset>
                                        <legend>{{$sub->group_name}}</legend>
                                        <label class="col-sm-12  checkbox-list" style="margin-top: 10px">
                                            {{ Form::checkbox('check-all', null,allPermission($role->id,$sub->group_name)->count() == permmissionByGroupName($sub->group_name,1)->count() ? true : false  , array('class' => 'check-all un-check'.$sub->group_name.'','data-checkall'=>''.$sub->group_name.'','data-count'=>permmissionByGroupName($sub->group_name,1)->count())) }} Select All 
                                            <span class="checkmark"></span>
                                        </label>
                                        <div class="form-group">
                                            @foreach (permmissionByGroupName($sub->group_name,1) as $per_of_sub)
                                                <label class="col-sm-3  checkbox-list" style="margin-bottom: 10px !important">
                                                    {{ Form::checkbox('permission[]', $per_of_sub->id, in_array($per_of_sub->id, $rolePermissions) ? true : false, array('class' =>'un-check '.$per_of_sub->group_name.'','data-un-check'=>''.$per_of_sub->group_name.'')) }} {{ $per_of_sub->name }}
                                                    <span class="checkmark"></span>
                                                </label>
                                            @endforeach
                                        </div>
                                    </fieldset>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endforeach
          </div>
          <div class="col-sm-12 col-xs-12" style="padding: 8px;margin-top: 10px;margin-bottom: 10px">
                <div class="form-group">
                    <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                        <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                </div>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
      
    {{-- <div class="row">
        <div class="col-md-12">
            <div class="form-wrapper">
                {!! Form::model($role, ['method' => 'PATCH','route' => ['roles.update', $role->id]]) !!}
                <div class="form-group col-sm-6 col-xs-12">

                    <label class="required">Title</label>
                    {!! Form::text('name', null, array('placeholder' => 'Title','class' => 'form-control')) !!}
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group">
                        @foreach($permission as $value)
                        <label class="col-sm-3  checkbox-list">
                            {{ Form::checkbox('permission[]', $value->id, in_array($value->id, $rolePermissions) ? true : false, array('class' => 'name')) }} {{ $value->name }}
                            <span class="checkmark"></span>
                        </label>
                        @endforeach
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12">
                    <div class="form-group">


                        <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                       <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
	                        <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div> --}}
</div>

@endsection
@section('script')
<script>
    $(document).ready(function () {
        $('.check-all').click(function (e) { 
            // e.preventDefault();
            let class_check = $(this).data('checkall');
            if($(this).prop('checked') == true){
                $('.'+class_check).prop('checked',true);
            }else{
                $('.'+class_check).prop('checked',false);
            }
        });
        $('.un-check').click(function (e) { 
            let un_check = $('.un-check'+$(this).data('un-check'));
            console.log($(this).data('un-check'));
            let not_all = 1;
            $.each($(this).closest('.form-group').find('.un-check'), function (i, v) { 
                 if($(this).prop('checked') == false){
                    not_all = 0;
                 }
            });
            if(not_all == 0){
                un_check.prop('checked',false);
            }else{
                un_check.prop('checked',true);
            }
                 
        });
        $(document).on('click','.a.tab',function(){
            $('.a.tab').removeClass('active');
            $(this).addClass('active');
        });
    });
</script>
    
@endsection
