@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
      <li><a href="#">{{__('administrator.user')}}</a></li>
      <li class="active">Security</li>
    </ol>
</div>
<div class="page">
<div class=container>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3>{{__('administrator.create_new_roles_commission_pickup')}}</h3>
                    </div>

                </div>
            </div>
        </div>
    </div>
    {!! Form::open(array('route' => 'roles-commitment.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
        <div class="row">
            <div class="col-sm-12">
                <div class="master-form">
                    <div class="title-note">
                        <h3><span class="fa fa-exclamation-triangle"></span>{{__('administrator.packed')}} <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                    </div>
                    <div class="show"> 
                            <div class="show1">
                                <div class="form-group col-sm-5 col-xs-5">
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.packed')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('packed',$data->packed, array('placeholder' => __('administrator.packed'),'class' => 'form-control number-only ' ,'required' )) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-1 col-xs-1">
                                    <div class="col-sm-9">
                                        =>
                                    </div>
                                </div>
                                <div class="form-group col-sm-5 col-xs-5">
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label class="required" for="name">{{__('administrator.commission')}} </label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('commission',$data->commission, array('placeholder' => __('administrator.commission'),'class' => 'form-control number-only','required')) !!}
                                    </div>
                                </div>
                               
                            </div> 
                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                            <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
</div>

<div class=container>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3>{{__('administrator.create_new_roles_commission_delivery')}}</h3>
                    </div>

                </div>
            </div>
        </div>
    </div>
        {!! Form::open(array('route' => 'roles-commitment.delivery_store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span>{{__('administrator.packed')}} <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                        </div>
                        <div class="show_delivery">
                           
                                <div class="show1">
                                    <div class="form-group col-sm-5 col-xs-5">
                                        <div class="col-sm-3 col-xs-12 ">
                                            <label for="name">{{__('administrator.packed')}}</label>
                                        </div>
                                        <div class="col-sm-9">
                                            {!! Form::text('packed',$delivery->packed, array('placeholder' => __('administrator.packed'),'class' => 'form-control number-only ' ,'required' )) !!}
                                        </div>
                                    </div>
                                    <div class="form-group col-sm-1 col-xs-1">
                                        <div class="col-sm-9">
                                         =>
                                        </div>
                                    </div>
                                    <div class="form-group col-sm-5 col-xs-5">
                                        <div class="col-sm-3 col-xs-12 ">
                                            <label class="required" for="name">{{__('administrator.commission')}} </label>
                                        </div>
                                        <div class="col-sm-9">
                                            {!! Form::text('commission',$delivery->commission, array('placeholder' => __('administrator.commission'),'class' => 'form-control number-only','required')) !!}
                                        </div>
                                    </div>
                                      
                                </div>
                           
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    {!! Form::close() !!}
</div>
@endsection

@section('script')
<script type="text/javascript">
    $(document).on('click', '.remove-audio', function () {
            $(this).parent().parent().parent().remove();
        });
    $('.button_add').on('click', function () {
        var packed =   `
        <div class="show1">
            <div class="form-group col-sm-5 col-xs-5">
                <div class="col-sm-3 col-xs-12 ">
                    <label for="name">{{__('administrator.packed')}}</label>
                </div>
                <div class="col-sm-9">
                    {!! Form::text('packed[]',null, array('placeholder' => __('administrator.packed'),'class' => 'form-control number-only ' ,'required' )) !!}
                </div>
            </div>
            <div class="form-group col-sm-1 col-xs-1">
                <div class="col-sm-9">
                   =>
                </div>
            </div>
            <div class="form-group col-sm-5 col-xs-5">
                <div class="col-sm-3 col-xs-12 ">
                    <label class="required" for="name">{{__('administrator.commission')}} </label>
                </div>
                <div class="col-sm-9">
                    {!! Form::text('commission[]',null, array('placeholder' => __('administrator.commission'),'class' => 'form-control number-only','required')) !!}
                </div>
            </div>
            <div class="form-group col-sm-1 col-xs-1">
                <div class="col-sm-3 col-xs-12  " style=" margin-left: -43px;">
                    <button type="button" class="btn btn-danger remove-audio">X</button>
                </div>
            </div>
        </div>
        `;
    $('.show').append(packed);


    });


    $(document).on('click', '.remove-audio-delivery', function () {
            $(this).parent().parent().parent().remove();
        });
    $('.button_add_delivery').on('click', function () {
        var packed =   `
        <div class="show2">
            <div class="form-group col-sm-5 col-xs-5">
                <div class="col-sm-3 col-xs-12 ">
                    <label for="name">{{__('administrator.packed')}}</label>
                </div>
                <div class="col-sm-9">
                    {!! Form::text('packed[]',null, array('placeholder' => __('administrator.packed'),'class' => 'form-control number-only ' ,'required' )) !!}
                </div>
            </div>
            <div class="form-group col-sm-1 col-xs-1">
                <div class="col-sm-9">
                   =>
                </div>
            </div>
            <div class="form-group col-sm-5 col-xs-5">
                <div class="col-sm-3 col-xs-12 ">
                    <label class="required" for="name">{{__('administrator.commission')}} </label>
                </div>
                <div class="col-sm-9">
                    {!! Form::text('commission[]',null, array('placeholder' => __('administrator.commission'),'class' => 'form-control number-only','required')) !!}
                </div>
            </div>
            <div class="form-group col-sm-1 col-xs-1">
                <div class="col-sm-3 col-xs-12  " style=" margin-left: -43px;">
                    <button type="button" class="btn btn-danger remove-audio">X</button>
                </div>
            </div>
        </div>
        `;
    $('.show_delivery').append(packed);


    });


</script>
@stop
