@extends('layouts.app')
@section('content')
<style>
    .datatables-exportable th{
        padding: 2px !important;
        vertical-align: middle !important;
    }
</style>
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">Report Driver</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                <div class="form-search">
                    <div class="col-md-2">
                        <div class="form-group"><label>Shop Name</label> 
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div> 
                                {!! Form::select('merchant', $merchant, null, ['class' => 'form-control merchant']) !!}

                             </select>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group"><label>Status</label> 
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div> 
                                <select name="status"   class="form-control status chosen-select">
                                 <option value="pay">  {{__('administrator.pay')}} </option>
                                 <option value="paid">  {{__('administrator.paid')}} </option>

                             </select>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group"><label>Verify</label> 
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div> 
                                <select name="verify" class = 'form-control verify' >
                                    <option value="">All</option>
                                    <option value="verify">Verify</option>
                                    <option value="not_verify">Not Verify</option>
                                  </select>
                                
                            </div>
                        </div>
                    </div>


                    <div class="col-md-2">
                        <div class="form-group"><label>{{__('administrator.from')}}</label> 
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div> 
                                {!! Form::text('from_date','', array('placeholder' => __('administrator.from'),'class' => 'form-control from_date date_picker')) !!}
                               
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group"><label>{{__('administrator.to')}}</label> 
                            <div class="input-group date">
                                <div   class="input-group-addon" >
                                    <i class="fa fa-stream"> </i>
                                </div> 
                                    {!! Form::text('to_date','', array('placeholder' => __('administrator.to'),'class' => 'form-control to_date date_picker')) !!}
                                
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <div class="wrapper-table ">
        <table id="datatable_" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>{{__('administrator.no')}}</th>
                    <th>{{__('administrator.verify_by')}}</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.create_users')}}</th>
                    <th>Paid Date</th>
                    <th>Paid By</th> 
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.bank_account')}}</th>
                    <th>{{__('administrator.invoice_payment')}}</th>
                    <th>{{__('administrator.pay_to_shop')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>
@endsection

@section('script')
<script type="text/javascript">

    $(document).on('click','.verify_by',function(){
        let href =  $(this).data('href');
        let this_  = $(this);
        $.confirm({
            icon: 'fa fa-check',
            theme: 'modern',
            title:"Verify",
            closeIcon: true,
            animation: 'scale',
            // content:"test",
            type: 'blue',
            buttons: {
                cancel: function () {
                    //close
                },
                formSubmit: {
                    text: 'verify',
                    btnClass: 'btn-blue',
                    action: function () {
                        $.ajax({
                            url: href,
                            type: 'PATCH',
                            dataType: 'json',
                            data: {
                                _token: '{{ csrf_token() }}',
                            },
                            success: function (response) {
                                if (response.success == 200) {
                                    $('.' + response.class).html(response.verify_by);
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                    
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }); 
                    }
                },
            },
        });



       

    });
             



    let data_table = '';
    $(document).on('click','.bt-excel',function () {
        // var table = `
        // <div id="tblData">
        //     <table class="table table-bordered table-striped table-hover datatables-exportable">
        //         <thead>
        //             <th width="5%" >{{__('administrator.no')}}</th> 
        //             <th width="10%" >{{__('administrator.verify_by')}}</th> 
        //             <th width="10%" >{{__('administrator.date')}}</th> 
        //             <th width="20%" >Paid Date</th> 
        //             <th width="15%">{{__('administrator.invoice_payment')}}</th> 
        //             <th width="20%">{{__('administrator.shop_name')}}</th> 
        //             <th width="20%">{{__('administrator.bank_account')}}</th> 
        //             <th width="20%">{{__('administrator.pay')}}</th> 
        //         <tbody>
        //         `;
        let total_dollar = 0;
        let total_riel = 0;
        var table = `
        <div id="tblData">
            <table class="table table-bordered table-striped table-hover datatables-exportable">
                <thead>
                    <tr>
                        <th rowspan="2" width="5%" >ល.រ</th> 
                        <th rowspan="2" width="20%">ឈ្មោះហាង</th> 
                        <th rowspan="2" width="20%">គណនី</th> 
                        <th colspan="2" width="20%">ប្រាក់ត្រូវទូទាត់</th> 
                        <th rowspan="2" width="20%">ទូទាត់ជាប្រាក់ដុល្លារសរុប</th> 
                        <th rowspan="2" width="20%">ហត្ថលេខា</th> 
                    </tr>
                    <tr>
                        <th width="20%">ដុល្លារ</th> 
                        <th width="20%">រៀល</th> 
                    </tr>
                <tbody>
                `;
        $('.tbody  > tr').each(function(index, tr) { 
            var tr = $(this).closest('tr');
            var row = data_table.row(tr);
            var data = row.data();  
            let riel = (data.pay_amount.split('ឬ').pop().split('៛')[0]); 
            let dollar = (data.pay_amount.split('$').pop().split('ឬ')[0]);
            total_dollar += parseFloat(dollar);
            total_riel += parseFloat(riel.replace(',','')); 
            console.log(parseFloat(riel.replace(',','')));
            // table +=    
            //         `<tr>
            //             <td>${index + 1}</td>
            //             <td>${data.verify_by == null ? '' : data.verify_by}</td>
            //             <td>${data.date}</td>
            //             <td>${data.paid_date}</td>
            //             <td>${data.invoice_payment}</td>
            //             <td>${data.shop}</td>
            //             <td>${data.bank_account}</td>
            //             <td>${data.pay_amount}</td>
            //         </tr>`;
            //     });
            table +=    
                    `<tr>
                        <td>${index + 1}</td>
                        <td>${data.shop}</td>
                        <td>${data.bank_account}</td>
                        <td>$ ${dollar}</td>
                        <td>${riel} ៛</td>
                        <td></td>
                        <td></td>
                    </tr>`;
                });

        table +=    `</tbody>
                <tfood>
                    <tr>
                        <th colspan="2">សរុបលុយត្រូវវេជូនហាង</th>  
                        <th></th>  
                        <th>$ ${total_dollar.toFixed(2)}</th>  
                        <th>${total_riel} ៛</th>  
                    </tr>    
                </tfoot>
            </table>
         </div>`;
         $.confirm({
            title: '',
            content: table,
            columnClass:'xl',
            buttons: {
                cancel: function () {

                },
                somethingElse: {
                    text: 'Excel',
                    btnClass: 'btn-blue',
                    keys: ['enter', 'shift'],
                    action: function() {
                         tableToExcel('tblData', 'Report Delivery');
                    },
                },
            }
        });
    });


    var tableToExcel = (function() {

        var uri = 'data:application/vnd.ms-excel;base64,'
          , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table>{table}</table></body></html>'
          , base64 = function(s) { return window.btoa(unescape(encodeURIComponent(s))) }
          , format = function(s, c) { return s.replace(/{(\w+)}/g, function(m, p) { return c[p]; }) }
        return function(table, name) {
  
          if (!table.nodeType) table = document.getElementById(table)
          var xlsx = {worksheet: name || 'Worksheet', table: table.innerHTML}
          window.location.href = uri + base64(format(template, xlsx))
        }
      })()


    $(document).on('click','.bt_done',function(){
        var id  =   $(this).data('id');
        $.confirm({
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
            title: '{{ __("administrator.successful")}}',
            content: '',
            buttons: {

                {{ __("administrator.cancel")}}: function () {

                },
                {{ __("administrator.done")}}: function () {
                    location.href = "/nso/pay-later/"+id;
                },
            }
        });

    });

    $(document).on('change', ['.merchant','.status'], function(){
        dataTableAjax();
    });


    $(document).ready(function(){
        dataTableAjax();
    });
    function dataTableAjax(){
        let shop_id  = $('.merchant').val();
        let status  = $('.status').val();

        let to_date  = $('.to_date').val();
        let from_date  = $('.from_date').val();

        let verify  = $('.verify').val();

        $('#datatable_').DataTable().destroy();
        data_table = $('#datatable_').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url: window.location,
                data:{
                    shop_id:shop_id,
                    status:status,
                    to_date:to_date,
                    from_date:from_date,
                    verify:verify,
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'verify_by1'},
                    {data: 'date'},
                    {data: 'name'},
                    {data: 'paid_date'},
                    {data: 'paid_by'},
                    {data: 'shop'},
                    {data: 'bank_account'},
                    {data: 'invoice_payment'},
                    {data: 'pay_amount'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
            }
        });
        
        $(document).find('.dataTables_filter').prepend(`
                <label > 
                    <a href="#" class="btn_sm button_primary bt-excel" data-id="2">Excel <i class="fa fa-file-excel-o" aria-hidden="true"></i> </a>
                </label>&nbsp;&nbsp; `);
    }


</script>
@stop



