@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<style>
    thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}



    .redClass  td {
        background: #93adf3;
    }



    
 </style>
<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.report_income')}}</li>
</ol>
</div>
<div class="page">
<div class=container-fluid>
<div class="top-content">
    <div class="row">
        <div class="col-sm-12">
            {{--  {!! Form::open(array('route' => 'report_for_shop_print','method'=>'POST','target'=>"_blank")) !!}
           
                @csrf  --}}
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf
            <div class="form-search">
                @if(\Globals::is_Administrator() == 'Administrator')
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::select('merchant', $merchant1, null, ['class' => 'form-control merchant']) !!}
                </div>
                @endif
                <div class="form-group col-sm-3 col-xs-3">
                    <select name="status[]" id="" multiple="multiple" class="form-control chosen-select">
                        <option value="">   {{__('administrator.please_select')}}  {{__('administrator.no')}} </option>
                        <option value="1">   {{__('administrator.processing')}} </option>
                        <option value="2">   {{__('administrator.padding')}} </option>
                        <option value="3">  {{__('administrator.done')}} </option>
                        <option value="4">  {{__('administrator.cancel')}} </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button id='search' class="button_sm button_info pull-right"   type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>
                        <button type="submin" class="button_sm button_info pull-right buttons-print bt_print"><span class="fa fa-print"></span>   {{__('administrator.print')}}</button>
                        <button class="button_sm button_warning pull-right bt_print_with_invoice" type="button" style='display: none'><span class="fa fa-file-text"></span> {{__('administrator.invoice')}} </button>
                     
                    </div>
                </div>
            </div>
        </form>


        </div>
    </div>
</div>

<div class="wrapper-table ">
    <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>
                <th>{{__('administrator.no')}}</th>
                <th>{{__('administrator.date')}}</th>
                <th>{{__('administrator.shop_name')}}</th>
                <th>{{__('administrator.driver')}}</th>
                <th>{{__('administrator.box_code')}}</th>
                <th>{{__('administrator.location')}}</th>
                <th>{{__('administrator.customer_receive')}}</th>
                <th>{{__('administrator.price')}}</th>
                <th>{{__('administrator.price_of_car')}}</th>
                <th>{{__('administrator.price_of_service')}}</th>
                <th>{{__('administrator.total')}}</th>
                <th>{{__('administrator.reason')}}</th>
                <th>{{__('administrator.status')}}</th>
            </tr>
        </thead>
        <tbody class="tbody">

        </tbody>
    </table>
</div>
</div>


@endsection



@section('script')
<script type="text/javascript">

    $(document).on('click','.bt_print',function(){
        $( ".submit" ).submit();
        $('.submit').attr('action', '{{ route("report_for_shop_print",1) }}').submit();
    });

    $(document).on('click','.bt_print_with_invoice',function(){
        $( ".submit" ).submit();
        $('.submit').attr('action', '{{ route("report_for_shop_print",2) }}').submit();
    });


    
    $(document).on('change','.merchant',function(){
        if($(this).val() != ''){
            $('.bt_print_with_invoice').show();
        }
        else{
            $('.bt_print_with_invoice').hide();

        }
    });

    $(document).ready(function(){
        dataTableAjax(); 
    });

    $(document).on('click', '#search', function(){ 
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
 
        $('#datatable_income').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status); 
    });

    function dataTableAjax(from_date= '', to_date= '', merchant= '',status=''){
        
        $('#datatable_income').DataTable({
            "oLanguage": {
            "sSearch":" search :",
            "sLengthMenu": "{{('administrator.display')}} _MENU_ {{('administrator.record_per_page')}}",
            "sZeroRecords": "{{('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{('administrator.showing')}} _START_ {{('administrator.to')}} _END_ {{('administrator.of')}} _TOTAL_ {{('administrator.record')}}",
            "sInfoEmpty": "{{('administrator.showing')}} 0 {{('administrator.to')}} 0 {{('administrator.of')}} 0 {{('administrator.record')}}",
            "sInfoFiltered": "({{('administrator.filter_form')}} _MAX_ {{('administrator.total_records')}})",
            "oPaginate": {
            "sFirst":    "{{('administrator.first')}}",
            "sLast":    "{{('administrator.last')}}",
            "sNext":    "{{('administrator.next')}}",
            "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
            ordering: false,
            processing: false,
            serverSide: true,
            lengthMenu: [20, 30, 50, 100, 200, 500, 1000],
            ajax:{
                url: "{{ route('report_for_shop') }}", 
                data:{                       
                    from_date:from_date, 
                    to_date:to_date, 
                    merchant:merchant,
                    status:status
                }
            },
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    title: 'X Delivery',
                    autoFilter: true,
                    sheetName: 'Exported data',
                    customize: function ( xlsx ){
                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                        $('row c[r*="2"]', sheet).attr( 's', '25' );
                        $('row c[r^="C"]', sheet).each( function () {
                            // Get the value
                        });
                    }
                },
                {
                    extend: 'pdfHtml5',
                    title: 'Report Delivery'
                },
                {
                    extend: 'copyHtml5',
                    title: 'Report Delivery'
                }, 
            ],
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'delivery_date'},
                    {data: 'shop_name'},
                    {data: 'driver_name'},
                    {data: 'box_code'},
                    {data: 'name_location'},
                    {data: 'customer_receive'},
                    {data: 'total_price'},
                    {data: 'taxi_fee'},
                    {data: 'delivery_fee'},
                    {data: 'total'},
                    {data: 'reason'},
                    {data: 'status'},
                ], 
            "initComplete": function (settings, json) {
            }

        });

       

    }

    

   
 
</script>
@stop



