@extends('layouts.app')
@section('content')
    <div class="col-md-12">
        <div class="table-responsive" style="float: left;">
            <table id="datatable_history" width="100%" class="table table-striped hover">
                <thead>
                <tr>
                    <th>{{__('administrator.no')}}</th>
                    {{-- <th width="1%"><input type="checkbox" name="check" class="checkbox_all"></th> --}}
                    <th>{{__('administrator.driver_name')}}</th>
                    {{-- <th>{{__('administrator.created_at')}}</th>
                    <th>{{__('administrator.created_by')}}</th> --}}
                    <th>{{__('administrator.day_delivery')}}</th>
                    <th>{{__('administrator.box_code')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.customer_receive')}}</th>
                    <th>{{__('administrator.location')}}</th>
                    <th>{{__('administrator.price')}}</th>
                    <th>{{__('administrator.delivery_fee')}}</th>
                    <th>{{__('administrator.delivery_option')}}</th>
                    {{-- <th>{{__('administrator.description')}}</th> --}}
                    <th>{{__('administrator.status')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
                <tbody class="tbody">
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(document).ready(function () {
            $('#datatable_history').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.prevoius')}}"
                    },
                },
                ordering: false,
                serverSide: true,
                ajax:{
                    url: window.location,
                    data:{
                        
                    }
                },
            

                lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                columns:
                    [
                        {data: 'DT_RowIndex'            ,  'searchable': false},
                        // {data: 'share_link'             ,  'searchable': false},
                        {data: 'driver_name'             ,  'searchable': false},
                        // {data: 'export_date'            ,  'searchable': false},
                        // {data: 'create_by_name'         , name:  'nso007_export_stock.create_by_name'   ,  'searchable': true},
                        {data: 'delivery_date'          ,  'searchable': false},
                        {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                        {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                        {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                        {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                        {data: 'total_price'            ,  'searchable': false},
                        {data: 'delivery_fee'           ,  'searchable': false},
                        {data: 'delivery_option'        ,  'searchable': false},
                        // {data: 'description'            ,  'searchable': false},
                        {data: 'status'                 ,  'searchable': false},
                        {data: 'action'                 ,  'searchable': false},
                    ],
                "initComplete": function (settings, json) {
                    
                }
            });
        });
    </script>
@endsection