@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
 <script src="{{asset('assets/print_this/printThis.js')}}"></script>
 <script src="{{asset('assets/report/jquery.dataTables.min.js')}}"></script>
 <script src="{{asset('assets/report/jquery-3.5.1.js')}}"></script>

 <style>
   thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
        width: 60px !important;
        padding: 1px 1px 1px 1px !important;
        box-shadow: none !important;

    }
    .dt-button{
        color: black !important;
    }

    table {
        table-layout: inherit !important;
    }
 </style>


<div class="top-header">
<ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.report_delivery')}}</li>
</ol>
</div>
<div class="page">
<div class=container-fluid>
<div class="top-content">
    <div class="row">
        <div class="col-sm-12">
            <form  action="" method="get" class=" submit" enctype="multipart/form-data" target="_blank" >
                @csrf


            <div class="form-search">
                {{-- <div class="form-group col-sm-1 col-xs-3">
                    {!! Form::select("filter_date", filterDuration(), [], ["class" => "form-control select2",]) !!}
                </div> --}}


                @if(\Globals::is_Administrator() == 'Administrator')
                <div class="form-group col-sm-2 col-xs-2">
                    <select name="staff_id" id="" class="staff_id form-control chosen-select">
                        <option value=""> {{__('administrator.staff_name')}} </option>
                        @foreach ($users as $user)
                            <option value="{{$user->id}}">{{$user->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-sm-2 col-xs-3">
                    {!! Form::select('merchant', $merchant, null, ['class' => 'form-control merchant']) !!}
                </div>
                @endif
                <div class="form-group col-sm-2 col-xs-3">
                    <select name="status[]" id="" multiple="multiple" class="form-control chosen-select">
                        <option value="">   {{__('administrator.please_select')}}  {{__('administrator.no')}} </option>
                        <option value="1">   {{__('administrator.processing')}} </option>
                        <option value="2">   {{__('administrator.padding')}} </option>
                        <option value="3">  {{__('administrator.done')}} </option>
                        <option value="4">  {{__('administrator.cancel')}} </option>
                    </select>
                </div>
                <div class="form-group col-sm-2 col-xs-2">
                    {!! Form::text('from_date','', array('placeholder' => __('administrator.from'),'class' => 'form-control date_picker')) !!}
                </div>
                <div class="form-group col-sm-2 col-xs-2">
                    {!! Form::text('to_date','', array('placeholder' => __('administrator.to'),'class' => 'form-control date_picker')) !!}
                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button class="button_sm button_info pull-right  " id="search" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>
                        <button type="button" class="button_sm button_info pull-right buttons-print bt_print"><span class="fa fa-print"></span>   {{__('administrator.print')}}</button>
                        <button class="button_sm button_warning pull-right bt_print_with_invoice" type="button" style='display: none'><span class="fa fa-file-text"></span> {{__('administrator.invoice')}} </button>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>
{{-- <div class="wrapper-table ">
    <table id="datatable_income" width="100%" class="table table-striped table-hover  "> --}}

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
        <thead>
            <tr>
                <th>{{__('administrator.no')}}</th>
                <th width="1%"><input type="checkbox" name="check" class="checkbox_all"></th>
                <th>{{__('administrator.status_driver_clear')}}</th>
                <th width="5%">{{__('administrator.import_date')}}</th>
                <th width="5%">{{__('administrator.export_date')}}</th>
                <th>{{__('administrator.shop_name')}}</th>
                <th>{{__('administrator.driver')}}</th>
                <th>{{__('administrator.box_code')}}</th>
                <th>{{__('administrator.location')}}</th>
                <th>{{__('administrator.customer_receive')}}</th>
                <th>{{__('administrator.price')}}</th>
                <th>{{__('administrator.price_of_car')}}</th>
                <th>{{__('administrator.price_of_service')}}</th>
                {{-- <th>{{__('administrator.extra_fee')}}</th> --}}
                <th>{{__('administrator.total')}}</th>
                <th>{{__('administrator.reason')}}</th>
                <th>{{__('administrator.status')}}</th>
                <th><a class="btn btn-success btn-xs fa fa-check-square-o approve" href="#">  {{__('administrator.approve')}}</a></th>
            </tr>
        </thead>
        <tbody class="tbody">
        </tbody>
    </table>
</div>
</div>
@endsection
@section('script')
<script type="text/javascript">      
    $('.approve').on('click', function(e) {
        var export_id = [];
        var tbody_1 = '';
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });
        export_id = export_id.join(",");

        $.confirm({
            icon: 'fa fa-check-square-o',
            theme: 'modern',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
            title: 'Approve!',
            buttons: {
                cancel: function () {

                },
                confirm: {
                    text: 'Something else',
                    btnClass: 'btn-blue',
                    keys: ['enter', 'shift'],
                    action: function(){

                        $.ajax({
                            url: "{{route('approve')}}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                export_id: export_id,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(data) {
                                {{-- dataTableAjax(); --}}
                                var from_date = $('input[name="from_date"]').val();
                                var to_date = $('input[name="to_date"]').val();
                                var merchant = $('select[name="merchant"]').val();
                                var status = $('select[name="status[]"]').val();
                                var filter_date = $('select[name="filter_date"]').val();
                                $('#datatable_income').DataTable().destroy();
                                dataTableAjax(from_date, to_date, merchant,status,filter_date);
                            }
                        });

                    }
                }
            }
          });
    });

    $('.checkbox_all').on('click', function(e) {
        if ($(this).is(':checked', true)) {
            $(".checkbox").prop('checked', true);
        } else {
            $(".checkbox").prop('checked', false);
        }
    });
    $(document).on('change','.merchant',function(){
        if($(this).val() != ''){
            $('.bt_print_with_invoice').show();
        }
        else{
            $('.bt_print_with_invoice').hide();
        }
    });

    $(document).on('click','.bt_print',function(){
        // $( ".submit" ).submit();
        $('.submit').attr('action', '{{ route("report_for_shop_print",1) }}').submit();
    });

    $(document).on('click','.bt_print_with_invoice',function(){
        // $( ".submit" ).submit();
        // $('.submit').attr('action', '{{ route("report_for_shop_print",2) }}').submit();
        $('.submit').attr('action', '{{ route("report_for_shop_print-new",2) }}').submit();
    });


    $(document).ready(function(){
        dataTableAjax();
    });
    {{-- $(document).on('change', 'select[name="filter_date"]', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var filter_date = $('select[name="filter_date"]').val();
        $('#datatable_income').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status,filter_date);

    }); --}}

    $(document).on('click', '#search', function(){
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();
        var filter_date = $('select[name="filter_date"]').val();
        $('#datatable_income').DataTable().destroy();
        dataTableAjax(from_date, to_date, merchant,status,filter_date);
    });

    function dataTableAjax(from_date= "", to_date= "", merchant= '',status='',filter_date = 1){
        var table  = $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[50, 200, 500, 1000,-1], [50, 200, 500, 1000,'All']],
        ajax:{
            url: "{{ route('datatable.history_delivery') }}",
            data:{
                from_date:from_date,
                to_date:to_date,
                merchant:merchant,
                status:status,
            }
        },

        buttons: [
            {
                extend: 'pageLength',
                text: 'show', // Label
                className: 'buttons-html5',
            },
            {
                extend: 'excelHtml5',
                title: 'Report Delivery',
                autoFilter: true,
                sheetName: 'Exported data',
                customize: function ( xlsx ){
                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    $('row c[r*="2"]', sheet).attr( 's', '25' );
                    $('row c[r^="C"]', sheet).each( function () {
                        // Get the value

                    });
                }
            },
       
        ],
        columns:
            [
                {data: 'DT_RowIndex'                , 'searchable': false},
                {data: 'approve'                , 'searchable': false},
                {data: 'status_clear'                , 'searchable': false},
                {data: 'export_date',          'searchable': false},
                {data: 'delivery_date',     'searchable': false},
                {data: 'shop_name'          ,name:'nso007_export_stock.shop_name'    , 'searchable': true},
                {data: 'driver_name'        ,name:'nso007_delivery_order.driver_name'        , 'searchable': true},
                {data: 'box_code'            ,name:'nso007_export_stock.box_code'   , 'searchable': true},
                {data: 'location_name'          ,name:'nso007_export_stock.location_name'     , 'searchable': true},
                {data: 'customer_receive'               , 'searchable': false},
                {data: 'total_price'                , 'searchable': false},
                {data: 'taxi_fee'               , 'searchable': false},
                {data: 'delivery_fee'               , 'searchable': false},
                // {data: 'extra_fee'              , 'searchable': false},
                {data: 'total'              , 'searchable': false},
                {data: 'reason'             , 'searchable': false},
                {data: 'status'             , 'searchable': false},
                {data: 'status_paid'                , 'searchable': false},
            ],
            orderCellsTop: true,
            fixedHeader: true,
        } );
    }

    $(document).on('change','.staff_id',function(){
        var id =$(this).val();
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var staff = $(this);
        $.ajax({
                type: 'POST',
                dataType: "json",
                url: "{{route('get_merchant_in_report_delivery')}}",
                data: {
                    "id": id,
                    "from_date": from_date,
                    "to_date": to_date,
                    "_token": '{{csrf_token()}}',
                },
                success: function (data) {
                  staff.closest('form').find('.merchant').html(data);

                }
        });

    });
</script>
@stop



