@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.history_driver_list')}}</li>
	</ol>
</div>
<style>
    table#table_2 thead th {
        background: #aec2d7;
    }
    #table_2 {

        width: 98% !important;
        margin-left: 1%;
    }
    table#table_2 tbody th {
        background: #681f29;
    }

    table.dataTable tbody tr {
        background-color: #666060;
    }

    td.details-control {
        background:   url('{{ asset('images/details_open.png')}}')  no-repeat center center;
        cursor: pointer;
    }
    tr.details td.details-control {
        background:     url('{{ asset('images/details_close.png')}}')   no-repeat center center;
    }
</style>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th></th>
                    <th>{{__('administrator.no')}}</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.box_qty')}}</th>
                    <th>{{__('administrator.description')}}</th>
                    <th>{{__('administrator.driver_name')}}</th>
                    <th>{{__('administrator.invoice_pickup')}}</th>
                    <th>{{__('administrator.type_of_pickup')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')
<script type="text/javascript">
    $(document).on('click','.bt_delete_main',function(){
        var id = $(this).data('pickup_id');
        var this_  = $(this);
        $.confirm({
            icon: 'fa fa-trash ',
            title: 'លុប!',
            closeIcon: true,
            content: ' ',
            animation: 'scale',
            type: 'red ',
            buttons: {
                បិទ: function () {
    
                },
                យល់ព្រម: function () {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route("box_pickup_delete_main") }}',
                        dataType:'text',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,
                        },
                        success: function (data) {
                            location.reload();
                        }
                    });
                },
            }
        });
    });
    $(document).on('click','.bt_delete',function(){
        var id = $(this).data('id');
       
        $.confirm({
            icon: 'fa fa-smile-o',
            title: 'លុប!',
            closeIcon: true,
            content: ' ',
            animation: 'scale',
            type: 'green',
            buttons: {
		        បិទ: function () {

		        },
		        យល់ព្រម: function () {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route("box_pickup_delete") }}',
                        dataType:'json',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,
                        },
                        success: function (data) {
                            $('.delete_'+id).remove();
                        }
                    });
		        },
		    }
        });
    });

    function format ( d ) {
        var tbody_1  ='';
        $.ajax({
            url: "{{route('assign_show')}}",
            type: 'GET',
            async: false,
            dataType: 'json',
            data: {
                driver_pick_up_id: d.driver_pick_up_id,
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                $('.tbody_1').empty();
                $total = 0;
                $.each(data, function(index, val) {
                    var delivery_option ='';
                    if(val.delivery_option != null){
                          delivery_option = val.delivery_option ;
                    }

                    var description ='';
                    if(val.description != null){
                        description = val.description ;
                    }
                    var delete1 ='';
                    if(d.status != 3){
                        delete1 =  ' <button class="button_sm button_success bt_delete" data-id="'+val.id+'" type="button"><span class=" "></span> Delete </button> '
                    }

                    tbody_1 += `
                        <tr class="delete_${val.id}">
                            <td>${index+1}</td>
                            <td>${val.customer_receive}</td>
                            <td>${val.location_name}</td>
                            <td>${val.category_name}</td>
                            <td>${val.price}</td>
                            <td>${val.delivery_fee}</td>
                            <td>${delivery_option}</td>
                            <td>${description}</td>
                            <td>${delete1}</td>
                        </tr>
                    `;
                });
            }
        });

        var div = '<table  class="table"  id="table_2" >'+
            '<thead>'+
                '   <tr>'+
                    '  <th>No</th>'+
                    '  <th>{{__('administrator.customer_receive')}}</th>'+
                    '  <th>{{__('administrator.location')}}</th>'+
                    '  <th>{{__('administrator.category')}}</th>'+
                    '  <th>{{__('administrator.price')}}</th>'+
                    '  <th>{{__('administrator.delivery_fee')}}</th>'+
                    '  <th>{{__('administrator.delivery_option')}}</th>'+
                    '  <th>{{__('administrator.description')}}</th>'+
                    '  <th>{{__('administrator.action')}}</th>'+
                ' </tr>'+
            '</thead>'+
            tbody_1+
            '</tbody>'+

        '</table>';
        return div;
    }

    var dt =   $('#datatable_income').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax: "{{route('list_pickup')}}",
            columns:
                [
                {
                    "class":          "details-control",
                    "orderable":      false,
                    "data":           null,
                    "defaultContent": ""
                },
                {data: 'DT_RowIndex'},
                {data: 'date' },
                {data: 'shop_name' },
                {data: 'count_' },
                {data: 'description' },
                {data: 'driver_name' },
                {data: 'invoice_pickup' },
                {data: 'status' }, 
                {data: 'action' }, 


                ],

            "initComplete": function (settings, json) {
            }
    });

    var detailRows = [];
    $('#datatable_income tbody').on( 'click', 'tr td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = dt.row( tr );
        var idx = $.inArray( tr.attr('id'), detailRows );

        if ( row.child.isShown() ) {
            tr.removeClass( 'details' );
            row.child.hide();

            // Remove from the 'open' array
            detailRows.splice( idx, 1 );
        }
        else {
            tr.addClass( 'details' );
            row.child( format( row.data() ) ).show();

            // Add to the 'open' array
            if ( idx === -1 ) {
                detailRows.push( tr.attr('id') );
            }
        }
    } );

    dt.on( 'draw', function () {
        $.each( detailRows, function ( i, id ) {
            $('#'+id+' td.details-control').trigger( 'click' );
        } );
    } ); 
</script>
@stop



