@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.report_income')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                {!! Form::open(array('route' => 'history_delivery_print','method'=>'POST','target'=>"_blank")) !!}
                <div class="form-search">
                    @if(\Globals::is_Administrator() == 'Administrator')
                    <div class="form-group col-sm-3 col-xs-3">
                        {!! Form::select('merchant', $merchant, null, ['class' => 'form-control']) !!}
                    </div>
                    @endif

                    <div class="form-group col-sm-3 col-xs-3">
                        {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                    </div>
                    <div class="form-group col-sm-3 col-xs-3">
                        {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search" ></span> {{__('administrator.searching')}} </button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"style="display: none" ><span class="fa fa-print" ></span>   {{__('administrator.print')}}</button>
                            <button type="button" class="button_sm button_primary pull-right show_payall "style="display: none"><i class="fa fa-dollar" ></i>  Pay All</button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th width= 5px><input type="checkbox" name="check" class="checkbox_all"></th>
                    <th>{{__('administrator.no')}}</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.driver')}}</th>
                    <th>{{__('administrator.box_code')}}</th>
                    <th>{{__('administrator.location')}}</th>
                    <th>{{__('administrator.customer_receive')}}</th>
                    <th>{{__('administrator.price')}}</th>
                    <th>{{__('administrator.price_of_car')}}</th>
                    <th>{{__('administrator.price_of_service')}}</th>
                    <th>{{__('administrator.extra_fee')}}</th>
                    <th>{{__('administrator.service_charge')}}</th>
                    <th>{{__('administrator.total')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


@endsection

@section('script')
<script type="text/javascript">

    $('.show_payall').on('click', function(e) {
        var export_id = [];
        var tbody_1 ='';
        var total = 0;
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });
        export_id = export_id.join(",");

        if(export_id !== ''){
            $.ajax({
                url: "{{route('paymente_show')}}",
                type: 'GET',
                dataType: 'json',
                data: {
                    export_id: export_id,
                    _token: '{{ csrf_token() }}',
                },
                success: function(data) {
                    $('.tbody_1').empty();
                    $.each(data,function(index,val){

                        var total_price = val.total_price;
                        var taxi_fee = 0;
                        var taxi_fee1 = 0;
                        if(val.taxi_status == 1){
                             taxi_fee =   val.taxi_shop_fee  ;
                             taxi_fee1 =   val.taxi_shop_fee  ;
                        }
                        else if(val.taxi_status == 2){
                             taxi_fee =   0;
                             taxi_fee1 =   val.taxi_cust_fee  ;
                        }
                        else{
                             taxi_fee =   0;
                             taxi_fee1 =   0;
                        }

                        if(val.delivery_status == 1){
                             var delivery_fee =  val.delivery_fee ;
                        }
                        else{
                            var delivery_fee =  0;
                        }

                        if(val.extra_fee_type == 1){
                            var extra_fee =  val.extra_fee  ;
                         }
                        else if(val.extra_fee_type == 2) {
                            var extra_fee = 0;
                        }
                        else{
                            var extra_fee = 0;
                        }
                         var service_charge = val.service_charge;
                          total_price  =  total_price -  taxi_fee  - extra_fee  -  delivery_fee-    service_charge ;
                          total += total_price ;

                          str = val.delivery_date;
                          st2 = str.split("-");
                          yr = st2[0];
                          mo = st2[1];
                          dy = st2[2];
                          var new_date = dy+'-'+mo+'-'+yr;

                        tbody_1 += `
                            <tr>
                                <td>&nbsp;&nbsp; ${(index+1)}</td>
                                <td>${new_date}</td>
                                <input type='text' value="${val.export_stock_id}" data-export_id="${val.export_stock_id}" name='export_stock_id'>
                                <td>$ ${ parseFloat(val.total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                <td>$ ${ parseFloat(delivery_fee).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                <td>$ ${ parseFloat(taxi_fee1).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                <td>$ ${ parseFloat(extra_fee).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                </td> <td>$ ${ parseFloat(service_charge).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                <td>$ ${ parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>​
                            </tr>
                        `;

                    });
                    $.confirm({
                        title:  'ការទូទាត់រូចរាល់',
                        theme: 'bootstrap',
                        closeIcon: true,
                        columnClass: 'col-md-12',
                        animation: 'scale',
                        type: 'green',
                        content: `
                            <form  method="POST" action="#">
                                {{csrf_field()}}
                                <div class="modal-body" style="overflow: hidden   ">
                                    <div class="row">
                                        <table class="account-payable table table-bordered table-striped table table-condensed table-hover">
                                            <thead>
                                                <tr>
                                                    <th>    {{__('administrator.no')}}                  </th>
                                                    <th>    {{__('administrator.date')}}                </th>
                                                    <th>    {{__('administrator.product_price')}}       </th>
                                                    <th>    {{__('administrator.delivery_fee')}}        </th>
                                                    <th>    {{__('administrator.price_of_car')}}        </th>
                                                    <th>    {{__('administrator.extra_fee')}}           </th>
                                                    <th>    {{__('administrator.service_charge')}}      </th>
                                                    <th>    {{__('administrator.total')}}               </th>
                                                </tr>
                                            </thead>
                                            <tbody class="tbody_1">
                                                ${tbody_1}
                                            </tbody>
                                            <tfoot class="label-right">
                                                <tr>
                                                    <th colspan="7" class="text-right"><b>  សរុប :</b> </th>
                                                    <th colspan="1" class="text-center"><b> $ ${ parseFloat(total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')} </b></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </form>
                            `,

                        buttons: {
                            បិទ: function () {
                            },
                            យល់ព្រម: function () {
                                var export_id = [];
                                $( "input[name='export_stock_id']" ).each(function() {
                                    export_id.push($(this).attr('data-export_id'));
                                });
                                export_id = export_id.join(",");

                                location.href = "/nso/payment-store/"+export_id;
                            },
                        },
                    });
                }
            });
        }



    });


    function searching(){
        if($( "select[name='merchant']" ).val()  != ""){
            searching1();
        }
        else{
            $.alert({
                title: 'សូមជ្រើសរើសឈ្មោះហាង!!',
                content: '  ',
            });
        }
    }

    $('.checkbox_all').on('click', function(e) {
        if ($(this).is(':checked', true)) {
            $(".checkbox").prop('checked', true);
        } else {
            $(".checkbox").prop('checked', false);
        }
    });

    function searching1()
    {
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var merchant = $('select[name="merchant"]').val();
        var status = $('select[name="status[]"]').val();

        var table = '';
        var taxi_fee =0;
        var reason ='';
        var delivery_fee =0;
        var account_name = '';
        $.ajax({
            url: "{{ Route('datatable_payment') }}",
            method: "POST",
            dataType: "json",
            data: {
                from_date: from_date,
                to_date: to_date,
                merchant: merchant,
                status: status,
                _token: '{{ csrf_token() }}',
            },
            success: function (data) {
                    var status ='';
                $.each(data, function(index, val) {
                    str = val.delivery_date;
                    st2 = str.split("-");
                    yr = st2[0];
                    mo = st2[1];
                    dy = st2[2];
                    var new_date = dy+'-'+mo+'-'+yr;

                    var total_price = val.total_price;
                    var taxi_fee = 0;
                    var taxi_fee1 = 0;
                    if(val.taxi_status == 1){
                         taxi_fee =   val.taxi_shop_fee  ;
                         taxi_fee1 =   val.taxi_shop_fee  ;
                    }
                    else if(val.taxi_status == 2){
                         taxi_fee =   0;
                         taxi_fee1 =   val.taxi_cust_fee  ;
                    }
                    else{
                         taxi_fee =   0;
                         taxi_fee1 =   0;
                    }

                    if(val.delivery_status == 1){
                         var delivery_fee =  val.delivery_fee ;
                    }
                    else{
                        var delivery_fee =  0;
                    }

                    if(val.extra_fee_type == 1){
                        var extra_fee =  val.extra_fee  ;
                     }
                    else if(val.extra_fee_type == 2) {
                        var extra_fee = 0;
                    }
                    else{
                        var extra_fee = 0;
                    }
                     var service_charge = val.service_charge;
                      total_price  =  total_price -  taxi_fee  - extra_fee  -  delivery_fee-    service_charge ;
                    table += `
                        <tr>
                            <td><input type="checkbox" name="check" class="checkbox" data-export_id="${val.export_stock_id}"></td>
                            <td>${index+1}</td>
                            <td>${new_date}</td>
                            <td>${val.shop_name}</td>
                            <td>${val.driver_name}</td>
                            <td>${val.box_code}</td>
                            <td>${val.name_location}</td>
                            <td>${val.customer_receive}</td>
                            <td>$ ${ parseFloat(val.total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$ ${ parseFloat(taxi_fee1).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$ ${ parseFloat(delivery_fee).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</>
                            <td>$ ${ parseFloat(extra_fee).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$ ${ parseFloat(service_charge).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>$ ${ parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                        </tr>
                    `;
                });
                $('.tbody').empty().append(table);
                $('.show_payall').show();
                $('.buttons-print').show();
                $(".checkbox").prop('checked', true);
                $(".checkbox_all").prop('checked', true);
            }
        });
    }
    $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "{{route('datatable_payment')}}",
        columns:
            [
                {data: 'pay_all'},
                {data: 'DT_RowIndex'},
                {data: 'delivery_date'},
                {data: 'shop_name'},
                {data: 'driver_name'},
                {data: 'box_code'},
                {data: 'name_location'},
                {data: 'customer_receive'},
                {data: 'total_price'},
                {data: 'taxi_fee'},
                {data: 'delivery_fee'},
                {data: 'extra_fee'},
                {data: 'service_charge'},
                {data: 'total'},
            ],
        "initComplete": function (settings, json) {
        }
    });



</script>
@stop



