@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('users.index')}}">{{__('administrator.merchant')}}</a></li>
            <li class="active">{{__('administrator.merchant_edit')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.merchant_edit')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::model($data, ['method' => 'PATCH','route' => ['merchant.update', $data->id],'enctype'=>'multipart/form-data']) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.merchant')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>

                        ​<div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.merchant_type')}} </label>
                            </div>
                            <div class="col-sm-9">
                                <div class="form-check">
                                    <input {{$data->type_of_merchant == 1 ? "checked" : ''}} name="type_of_merchant" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        Is shop Stock In
                                    </label>
                                </div>
                                {{-- <select name="type_of_merchant" id="type_of_merchant" class="form-control chosen-select">
                                    <option value="" >{{__('administrator.please_choose')}}</option>
                                    <option value="1"  {{ $data->type_of_merchant==1?'selected':""}}  >{{__('administrator.customer_in_stock')}}</option>
                                    <option value="2" {{ $data->type_of_merchant==2?'selected':""}}  >{{__('administrator.customer_out_stock')}}</option>
                                </select> --}}
                            </div>
                        </div>

{{--                        <div class="form-group col-sm-6 col-xs-6">--}}
{{--                            <div class="col-sm-3 col-xs-12 ">--}}
{{--                                <label class="required">{{__('administrator.account_name')}} </label>--}}
{{--                            </div>--}}
{{--                            <div class="col-sm-9">--}}
{{--                                <div class="row">--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        {!! Form::text('name', null, array('placeholder' => __('administrator.account_name_usd'),'class' => 'form-control','required')) !!}--}}
{{--                                    </div>--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        {!! Form::text('bank_name_kh', null, array('placeholder' => __('administrator.account_name_riel'),'class' => 'form-control','required')) !!}--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.shop_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('shop_name', null, array('placeholder' => __('administrator.shop_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

{{--                        <div class="form-group col-sm-6 col-xs-6">--}}
{{--                            <div class="col-sm-3 col-xs-12 ">--}}
{{--                                <label class="required">{{__('administrator.bank_account')}} </label>--}}
{{--                            </div>--}}
{{--                            <div class="col-sm-9">--}}
{{--                                <div class="row">--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        <div class="input-group">--}}
{{--                                            {!! Form::text('bank_account', null, array('placeholder' => __('administrator.bank_account'),'class' => 'form-control')) !!}--}}
{{--                                            <div class="input-group-addon">--}}
{{--                                                <span class="aba_symbol">$</span>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                        --}}
{{--                                    </div>--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        <div class="input-group">--}}
{{--                                            {!! Form::text('bank_account_kh', null, array('placeholder' => __('administrator.bank_account'),'class' => 'form-control')) !!}--}}
{{--                                            <div class="input-group-addon">--}}
{{--                                                <span class="aba_symbol">៛</span>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.phone_number')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!!Form::text('phone', null, array('placeholder' => __('administrator.phone') ,'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.facebook_page')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('facebook_page', null, array('placeholder' =>  __('administrator.facebook_page'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.address')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('address', null, array('placeholder' =>__('administrator.address'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.note')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control', 'rows'=>'3'))!!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.currency')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('user_currency', null, array('placeholder' =>__('administrator.currency'),'class' => 'form-control number-only'   )) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.staff_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                <select name="staff_id" id="type_of_merchant" class="form-control chosen-select">
                                    @foreach ($users as $user)
                                        <option value="{{$user->id}}" {{ $user->id == $data->staff_id ? 'selected' : '' }}>{{$user->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.join_date')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('join_date', date('d-m-Y',strtotime($data->join_date)), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.location')}} (Link)</label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('location', null, array('placeholder' => __('administrator.location'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.profile')}}</label>

                            </div>
                            <div class="form-group col-sm-9">
                               <input id="input-44" type="file" name="avartar" class="">
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.category')}}  </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('category_id[]',$category ,$array_cat , array('class' => 'form-control number-only' ,'multiple' )) !!}
                                {{-- <select name="staff_id" id="type_of_merchant" class="form-control chosen-select" multiple>

                                </select> --}}
                            </div>
                        </div>
                       {{--  <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.user')}} </h3>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label >{{__('administrator.email')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('email', null, array('placeholder' => __('administrator.email'),'class' => 'form-control','autocomplete'=>'off')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label >{{__('administrator.password')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::password('password', array('placeholder' => __('administrator.password'),'class' => 'form-control','id' => 'password','autocomplete'=>"off",)) !!}
                            </div>
                        </div>   --}}
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="arrayImg" value="{{$data->avartar}}" id="{{$data->avartar}}">

            {!! Form::close() !!}
            <input type="hidden" name="src" value="{{asset('/images/upload/')}}">

        </div>
    </div>
@endsection
@section('script')
<script type="text/javascript">
    $('#password').val('');
      var src_image = $('input[name="src"]').val();
      $(document).ready(function() {

        var images = [];
        var caption = [];
        $('input[name="arrayImg"]').each(function(i, e){
            var obj = {
                caption: e.id,
                width: '120px'
            };
            images.push(src_image +'/'+e.value);
            caption.push(obj);
        });
        $("#input-44").fileinput({
            initialPreview: images,
            initialPreviewAsData: true,
            initialPreviewConfig: caption,
            uploadUrl: "/",
            maxFilePreviewSize: 10240,
            overwriteInitial: false,
        });
    });
      $(document).on('click', '.kv-file-remove', function(){
        var src = $(this).closest('.kv-preview-thumb').find('img').attr('src');
        $('input[name="arrayImg"]').each(function(){
            var thiss = $(this).val();
            if ( (src_image+'/'+thiss) == src){
                $(this).remove();
            }
        });
        $('input[name="new_arrayImg"]').each(function(){
            var thiss = $(this).val();
            if ( thiss == src){
                $(this).remove();
            }
        });
        $(this).closest('.kv-preview-thumb').remove();
    });

    $(document).on('change', 'input[name="gallery"]', function(){
        readURL(this);
    });
      function readURL(input) {
        for (let i = 0; i < input.files.length; i++) {
            if (input.files) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#appended').append('<input type="text" name="new_arrayImg" value="'+e.target.result+'" id="'+e.target.result+'">')
                }
                reader.readAsDataURL(input.files[i]);
            }
        }


    }
    $(document).on('click', '.fileinput-remove-button', function(){
        $('input[name="arrayImg"]').each(function(){
            $(this).remove();
        });
        $('input[name="new_arrayImg"]').each(function(){
            $(this).remove();
        });
        $('.kv-preview-thumb').each(function(){
            $(this).remove();
        });
    });

</script>
@endsection
