@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('merchant.index')}}">{{__('administrator.merchant')}}</a></li>
            <li class="active">{{__('administrator.create_new')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.merchant')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::open(array('route' => 'merchant.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
            @csrf
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.merchant')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>

                        ​<div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.merchant_type')}} </label>
                            </div>
                            <div class="col-sm-9">
                                <div class="form-check">
                                    <input name="type_of_merchant" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        Is Shop Stock In
                                    </label>
                                </div>
                            </div>
                        </div>

{{--                        <div class="form-group col-sm-6 col-xs-6">--}}
{{--                            <div class="col-sm-3 col-xs-12 ">--}}
{{--                                <label class="required">{{__('administrator.account_name')}} </label>--}}
{{--                            </div>--}}
{{--                            <div class="col-sm-9">--}}
{{--                                <div class="row">--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        {!! Form::text('name', null, array('placeholder' => __('administrator.account_name_usd'),'class' => 'form-control','required')) !!}--}}
{{--                                    </div>--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        {!! Form::text('bank_name_kh', null, array('placeholder' => __('administrator.account_name_riel'),'class' => 'form-control','required')) !!}--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.shop_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('shop_name', null, array('placeholder' => __('administrator.shop_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
{{--                        <div class="form-group col-sm-6 col-xs-6">--}}
{{--                            <div class="col-sm-3 col-xs-12 ">--}}
{{--                                <label class="required">{{__('administrator.bank_account')}} </label>--}}
{{--                            </div>--}}
{{--                            <div class="col-sm-9">--}}
{{--                                <div class="row">--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        <div class="input-group">--}}
{{--                                            {!! Form::text('bank_account', null, array('placeholder' => __('administrator.bank_account'),'class' => 'form-control')) !!}--}}
{{--                                            <div class="input-group-addon">--}}
{{--                                                <span class="aba_symbol">$</span>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

{{--                                    </div>--}}
{{--                                    <div class="col-md-6">--}}
{{--                                        <div class="input-group">--}}
{{--                                            {!! Form::text('bank_account_kh', null, array('placeholder' => __('administrator.bank_account'),'class' => 'form-control')) !!}--}}
{{--                                            <div class="input-group-addon">--}}
{{--                                                <span class="aba_symbol">៛</span>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}

{{--                            </div>--}}
{{--                        </div>--}}
                        {{-- <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.bank_account')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('bank_account', null, array('placeholder' => __('administrator.bank_account'),'class' => 'form-control')) !!}
                            </div>
                        </div> --}}
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.phone_number')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!!Form::text('phone', null, array('placeholder' => __('administrator.phone') ,'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.facebook_page')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('facebook_page', null, array('placeholder' =>  __('administrator.facebook_page'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.address')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('address', null, array('placeholder' =>__('administrator.address'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label >{{__('administrator.note')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control', 'rows'=>'3'))!!}
                            </div>
                        </div>


                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.currency')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('user_currency', null, array('placeholder' =>__('administrator.currency'),'class' => 'form-control number-only'  )) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.staff_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('staff_id', $users,Auth::user()->id, array('placeholder' => __('administrator.please_choose'),'class' => 'form-control chosen-select')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.join_date')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('join_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="">{{__('administrator.location')}} (Link)</label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('location', null, array('placeholder' => __('administrator.location'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.image')}}</label>
                            </div>
                            <div class="form-group col-sm-9">
                                <input id="input-44" type="file" name="image" class="file" data-overwrite-initial="false" >
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.category')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('category_id[]',$category ,null, array('class' => 'form-control number-only' ,'multiple' )) !!}
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
@endsection
