@extends('layouts.app')
@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="{{route('app_dashboard')}}">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('location.index')}}">{{__('administrator.zone')}}</a></li>
            <li><a href="#" class="active">{{__('administrator.location')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            @if(Gate::check('Location Create'))
                                <div class="pull-left">
                                    <h3><span class="fa fa-th"></span> {{__('administrator.location')}}</h3>
                                </div>
                                <div class="pull-right">
                                    <a href="{{route('location.index')}}" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</a>
                                </div>

                                <div class="pull-right">
                                    <a href="#" class="button_sm button_primary pull-right bt_location">
                                    <span class=" fa fa-plus"></span> {{__('administrator.location')}}</a>
                                </div>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <div class="modal fade" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">{{__('administrator.edit_location')}}</h4>
                </div>

                <div class="modal-body">
                    <form id="idForm" method="post" action="{{route('getLocation_edit')}}" class="form-horizontal">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.name_en')}}</label>
                            <div class="col-sm-8">
                                {!! Form::text('name_en', null, array('placeholder' =>__('administrator.name_en'),'class' => 'form-control','required')) !!}
                                {!! Form::hidden('id', null, array('placeholder' =>'','class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.name_km')}}</label>
                            <div class="col-sm-8">
                                {!! Form::text('name_km', null, array('placeholder' =>__('administrator.name_km'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.price')}}</label>
                            <div class="col-sm-8">
                                {!! Form::number('price', null, array('placeholder' =>__('administrator.price'),'class' => 'form-control','required','step'=>'any')) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.currency')}}</label>
                            <div class="col-sm-8">
                                {!! Form::select('currency_symbol', ['$'=>__('administrator.dollars'),'៛'=>__('administrator.riel')],null, array('class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-12 col-xs-12">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button"data-dismiss="modal" aria-hidden="true" class="button_sm button_danger pull-right">
                                    <span class="fa fa-close"></span> {{__('administrator.close')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="add_location" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">{{__('administrator.location')}}</h4>
                </div>

                <div class="modal-body">
                    <form id="idForm" method="post" action="{{route('locationSave')}}" class="form-horizontal">
                        @csrf
                        <input type="hidden" name="pearent_id">
                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.name_en')}}</label>
                            <div class="col-sm-8">
                                {!! Form::text('name_en', null, array('placeholder' =>__('administrator.name_en'),'class' => 'form-control','required')) !!}
                               <input type="hidden" name="pearent_id" value="{{$id}}" >
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.name_km')}}</label>
                            <div class="col-sm-8">
                                {!! Form::text('name_km', null, array('placeholder' =>__('administrator.name_km'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.price')}}</label>
                            <div class="col-sm-8">
                                {!! Form::number('price', null, array('placeholder' =>__('administrator.price'),'class' => 'form-control','required','step'=>'any')) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4">{{__('administrator.currency')}}</label>
                            <div class="col-sm-8">
                                {!! Form::select('currency_symbol', ['$'=>__('administrator.dollars'),'៛'=>__('administrator.riel')],null, array('class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-12 col-xs-12">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button"data-dismiss="modal" aria-hidden="true" class="button_sm button_danger pull-right">
                                    <span class="fa fa-close"></span> {{__('administrator.close')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


@endsection
@section('js')
    <script type="text/javascript">

        $(document).on('click','.bt_location',function(){
            $('#add_location').modal('show');
        });
        $(document).on('click','.delete_location',function(){
            var id = $(this).data('id');

            $('#loading').show();

            if ($.confirm({
                title: '<strong style="color:darkcyan;">{{__('administrator.are_you_sure')}}</strong>',
                content: "<b> {{__('administrator.are_you_sure')}} </b>",
                type: "red",
                buttons: {

                    '{{__('administrator.cancel')}}':
                        {
                            btnClass: 'btn-red',
                            action:
                                function () {
                                }
                        }
                    ,
                    '{{__('administrator.ok')}}':
                        {
                            btnClass: 'btn-blue',
                            action:

                                function () {
                                    $.ajax({
                                        type: "POST",
                                        dataType: "json",
                                        url: '{{route("location_delete")}}',
                                        data: {'id': id,  _token: '{{ csrf_token() }}'},
                                        success: function (data) {
                                            $('#loading').hide();
                                            location.reload();

                                        }

                                    });
                                }
                        }
                }
            }))

                return false;
        });

        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax: "{{route('getLocation')}}",
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'location'},
                    {data: 'price'},
                    {data: 'action'},

                ],

            "initComplete": function (settings, json) {
            }
        });


        $(document).on('click','.edit_location',function(){

            var name_en = $(this).data('name_en');
            var name_km = $(this).data('name_km');
            var price = $(this).data('price');
            var id = $(this).data('id');
            let currency = $(this).data('currency');
            console.log(currency);
            $('#loginModal').modal('show');
            $('input[name="name_en"]').val(name_en);
            $('input[name="name_km"]').val(name_km);
            $('input[name="price"]').val(price);
            $('input[name="id"]').val(id);
            $('select[name="currency_symbol"]').val(currency).change();

        });
    </script>
@endsection




