@extends('layouts.app') @section('content')
 <?php Fun::lang() ?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
      <li><a href="{{route('import-stock.index')}}">{{__('administrator.import_stock')}}</a></li>
      <li class="active"><a href="#">{{__('administrator.add_import_stock')}}</a></li>
    </ol>
</div>

<div class="page-purchases">
    <div class="preview">
        <div class="col-sm-5">
            {{-- <div class="col-sm-6 paddin-5">
                <div class="form-group">
                    {!! Form::text('category', null, array('placeholder' => __('administrator.category') ,'class' => ' category form-control', "autocomplete" => "on")) !!}
                    
                </div>
            </div> --}}
            <div class="col-sm-12 paddin-5">
                <div class="form-group">
                    {!! Form::text('barcode', null, array('placeholder' => __('administrator.search_product_name') ,'class' => ' search_text form-control typeahead', "autocomplete" => "on")) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                    <!-- <span class="btn btn-add btn-search btn-sm"><i class="fa fa-search"></i></span> -->
                </div>
            </div>
            <div class="product-item-list importstock">
                <div class="item-list box-addtocart">
                    <div class="row" id="tag_container">
                       {{-- @include('administrator.import-stock.result-create') --}}
                    </div>
                </div>
            </div>
        </div>
        {!! Form::open(array('route' => 'import-stock.store','method'=>'POST','enctype'=>'multipart/form-data','id'=>'submit_post')) !!}
        <div class="col-sm-7 ">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        @if(\Globals::is_MerchantIn() == 'MerchantIn')
                        {!! Form::select('dd', $merchant, \Auth::user()->id, ['class' => 'form-control merchant_id chosen-select','disabled']) !!}
                        <input type="hidden" name="merchant_id" value="{{\Auth::user()->id}}">
                        @else
                        {!! Form::select('merchant_id', $merchant, null, ['class' => 'form-control merchant_id chosen-select']) !!}
                        @endif
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <input type="text" name="date" value="<?php echo date("d-m-Y")?>" class="form-control date_picker" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {{-- {!! Form::select('drivers_id', $drivers, null, ['class' => 'form-control chosen-select']) !!} --}}
                    </div>
                </div>

            </div>
            <div class="check-bill">
                <div class="row">
                    <div class="check-bill-table">
                        <div class="product-view-table">
                            <div class="tbl-header">
                                <table width="100%" class="table table-striped">
                                    <thead class="text-center">
                                        <tr>
                                            <th width="5% !i">{{__('administrator.no')}}</th>
                                            <th width="15%">{{__('administrator.code')}}<span class="required">*</span></th>
                                            <th width="15%">{{__('administrator.name')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.category')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.quantity')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.price')}}<span class="required">* </span></th>
                                            <th width="15%">{{__('administrator.total')}}<span class="required"></span></th>
                                            <th width="5%">{{__('administrator.action')}}</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <div class="tbl-content importstock">
                                <div class="overflow">
                                    <table width="100%" class="table table-striped">
                                        <tbody class="resultbody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="blog-payment ">
                        <div class="col-sm-12 ">
                            <div class="button_payment pull-right">
                                <button type="button" class="button_warning button_lg" onclick="history.back(1)">{{__('administrator.back')}}</button>
                                <button type="button" class="button_danger remove_all button_lg">{{__('administrator.remove')}}</button>
                                <button type="submit" class="button_info button_lg">{{__('administrator.save')}}</button>

                            </div>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>

    @endsection
    @section('script')
    <script type="text/javascript">


        $(document).ready(function(){
            // get_product_update();
        });

        $('.typeahead').blur(function () {
            if($(this).val() == ""){
                $('#autocomplete').html("");
            }

         });

        $(document).on('change','.merchant_id',function(){
            let shop_id = $(this).val();
            $.get(window.location, {
                shop_id:shop_id ? shop_id : 'null',
            },
                function (data, textStatus, jqXHR) {
                    get_product_update();
                    $('#tag_container').html(data);
                },
                
            );
        });
        
        {{-- //////////////////////////sum total ////////////////////// --}}

        $(document).on('keyup','.number-only',function(){
            var qty = parseFloat($(this).closest("tr").find(".stockin_qty").val());
            var price = parseFloat($(this).closest("tr").find(".price").val());
            var total = qty * price;
            $(this).closest("tr").find(".total").val(total);
        });

        {{-- //////////////////////////autocomplete-search-text////////////////////// --}}

        $('.typeahead').keyup(function () {

            
            $('#ajax-loading').show();
            var value = $(this).val();
            let shop_id = $('.merchant_id').val();
            $.ajax({
                url: "{{ route('autocomplete') }}",
                method: "post",
                data: {
                    value: value,
                    shop_id : shop_id,
                    _token: '{{ csrf_token() }}',
                },
                dataType: 'json',
                success: function (response) {
                    $('#ajax-loading').hide();
                    console.log(response);
                    $('#autocomplete').html(response.html);
                }
            });
        });

        {{-- //////////////////////////autocomplete-search-barcode////////////////////// --}}

        $(".search_text").autocomplete({
            source: function(request, response) {
            var type = $('.search_text').data('type');
            $.ajax({
                url: "{{ Route('get_product') }}",
                dataType: "json",
                method: "get",
                data: {
                 term : request.term,

                },
                success: function(data) {
                   if(data == 'success'){
                       get_product_update();
                       $(".main-spinner").hide();
                       $(".search_text").val('');
                       $(".search_text").focus();
                   }else{
                       $(".search_text").focus();
                   }
                 }
             });

            },
            minLength: 3,
        });



        {{-- //////////////////////////paginate-not-reload////////////////////// --}}

        $(window).on('hashchange', function() {
            if (window.location.hash) {
                var page = window.location.hash.replace('#', '');
                if (page == Number.NaN || page <= 0) {
                    return false;
                }else{
                    getData(page);
                }
            }
        });

        $(document).ready(function(){
            $(document).on('click', '.pagination a',function(event){
                event.preventDefault();
                $('li').removeClass('active');
                $(this).parent('li').addClass('active');
                var myurl = $(this).attr('href');
                var page=$(this).attr('href').split('page=')[1];
                getData(page);
            });
        });

        function getData(page){
            $.ajax({
                url: '?page=' + page,
                type: "get",
                datatype: "html"
            }).done(function(data){
                $("#tag_container").empty().html(data);
                location.hash = page;
            }).fail(function(jqXHR, ajaxOptions, thrownError){
                    alert('No response from server');
            });
        }
    {{-- //////////////////////////add-search-product////////////////////// --}}

        $(document).on('click','.add-product',function(){
            var id = $(this).data('id');
            var type = $(this).data('type');

            var rate = $('.rate').val();
            $.ajax({
                url: "{{ Route('get_product') }}",
                method: "POST",
                dataType: "json",
                data: {
                    id: id,
                    rate: rate,
                    shop_id:$('.shop_id').val() ? $('.shop_id').val() : 'null',
                    _token: '{{ csrf_token() }}',
                },
                success: function (data) {
                    
                    if(data == 'success'){
                        if(type==2){
                            $(".search_text").val('');
                            $(".search_text").focus();
                        }
                        get_product_update();
                    }else{
                        alert(data);
                    }
                }
            });
        });
   {{-- //////////////////////////showProductbeforeselector////////////////////// --}}

        function get_product_update()
        {

            $.ajax({
               url: '{{ route("get_product_upadate") }}',
               method: "get",
               type:'text',
               success: function (data) {
                   $('.resultbody').html(data);
               }
           });
        }

    {{-- //////////////////////////delete product////////////////////// --}}


        $(document).on('click','.btn-remove',function(){
            $(".main-spinner").show();
            var id = $(this).data('id');
            var type = 'remove-one';
            $.ajax({
                url: '{{ route("stock_removecart") }}',
                method: "post",
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                    type: type,
                },
                success: function (data) {
                    get_product_update();
                    $(".main-spinner").hide();
                }
            });
         });

         $(document).on('click','.remove_all',function(){
            $(".main-spinner").show();
            var type = 'remove-all';
            $.ajax({
                url: '{{ route("stock_removecart") }}',
                method: "post",
                data: {
                    _token: '{{ csrf_token() }}',
                    type: type,
                },
                success: function (data) {
                    $('.resultbody').html('');
                    get_product_update();
                    $(".main-spinner").hide();
                }
            });
         });

         $(document).on('blur','.all_key',function(){
            var barcode= [];
            $('.barcode').each(function(){
               var value = $(this).val();
               barcode.push(value);
           });

           var product_name= [];
           $('.product_name').each(function(){
              var value = $(this).val();
              product_name.push(value);
            });

            var category_name= [];
            $('.category_name').each(function(){
                var value = $(this).val();
                category_name.push(value);
            });

            var stockin_qty= [];
            $('.stockin_qty').each(function(){
                var value = $(this).val();
                stockin_qty.push(value);
            });

            var price= [];
            $('.price').each(function(){
            var value = $(this).val();
            price.push(value);
            });

            var total= [];
            $('.total').each(function(){
                var value = $(this).val();
                total.push(value);
            });

            var url = "{{route('import-stock-update')}}";

            $.ajax({
                url: url,
                method: "POST",
                data: {
                    _token: '{{ csrf_token() }}',
                    barcode:barcode,
                    product_name:product_name,
                    category_name:category_name,
                    stockin_qty:stockin_qty,
                    price:price,
                    total:total,

                },
                success: function (response) {
                    get_product_update();
                }
            });

        });



        </script>
@endsection
