
@extends('layouts.app')

@section('content')
<style>
    .table {
        width: 100%;
        max-width: 100%;
        margin-bottom: 10px !important;
    }
    table.dataTable tbody td{padding: 2px !important}
    .dt-button, .button_info, .button_danger,
    .button_success, .button_primary, .button_dark, .button_warning{
        padding: 2px 3px !important;
    }
</style>
<div class="page">
    <div class=container-fluid>
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="pull-right">
                    <div class="title-add">
                        <h2>  {{__('administrator.driver_voucher')}}</h2>
                        <table class="table table-striped">
                            <tr>
                                <td><b class="pull-left">   {{__('administrator.invoice')}}:</b></td>
                                @if(isset($data[0]->inovice))
                                <td><span class="pull-left">{{ $data[0]->inovice }}</span></td>
                                @endif
                            </tr>
                            <tr>
                                <td><b class="pull-left">  {{__('administrator.driver_name')}} :</b></td>
                                @if(isset($data[0]->driver_name))
                                <td><span class="pull-left">{{$data[0]->driver_name}} </span></td>
                                @endif
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="wrapper-table ">
            <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
                <thead>
                <tr>
                    <th width="1%">    #</th>
                    <th width="5%">    {{__('administrator.date')}}            </th>
                    <th width="5%">    {{__('administrator.box_code')}}        </th>
                    <th width="5%">    {{__('administrator.shop_name')}}       </th>
                    <th width="5%">    {{__('administrator.location')}}        </th>
                    <th width="5%">    {{__('administrator.customer_receive')}}</th>
                    {{-- <th width="5%">    {{__('administrator.driver_name')}}     </th> --}}
                    <th width="5%">    {{__('administrator.category')}}        </th>
                    <th width="5%">    {{__('administrator.product_price')}}   </th>
                    <th width="5%">    {{__('administrator.delivery_fee') }}   </th>
                    <th width="5%">    {{__('administrator.other_service_fee') }}</th>
                    <th width="5%">    {{__('administrator.price_of_car')}}    </th>
                    <th width="5%">    {{__('administrator.description')}}     </th>
                    <th width="1%">    <input type="checkbox" name="check" class="checkbox_all"></th>
                    <th width="20%">    <a class="btn btn-success btn-xs fa fa-check-square-o show_all" href="#">  {{__('administrator.done_all')}}</a></th>
                </tr>
                <tbody class="tbody">
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="show_item">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">{{__('administrator.box_code_successful')}}</h4>
            </div>
            <form  method="POST" action="#">
                {{ csrf_field() }}
                    <table class="account-payable table table-bordered table-striped table table-condensed table-hover">
                        <thead>
                            <tr>
                                <th>    {{__('administrator.no')}}                  </th>
                                <th>    {{__('administrator.box_code')}}            </th>
                                <th>    {{__('administrator.location')}}            </th>
                                <th>    {{__('administrator.customer_receive')}}    </th>
                                <th>    {{__('administrator.price')}}               </th>
                                <th>    {{__('administrator.delivery_fee')}}        </th>
                                <th>    {{__('administrator.price_of_car')}}        </th>
                            </tr>
                        </thead>

                        <tbody class="tbody_1">

                        </tbody>
                    </table>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal"> {{__('administrator.close')}}</button>
                    <a href="#" class="fa fa-check btn btn-warning" id="submit"> {{__('administrator.save')}}</a>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">

    $(document).on('change','select[name="extra_fee_type"]',function(){
            $('input[name="currency_usd"]').val( 0);
            $('input[name="currency_rial"]').val(0);
            $('input[name="extra_fee"]').val('');
            $('input[name="total_price"]').val(parseFloat(price));
    });


    $(document).on('keyup','input[name="extra_fee"]',function(){

       var extra_fee_type   = $('select[name="extra_fee_type"]').val();
        var  extra_fee =$(this).val();

        if(extra_fee_type == 2 ){
            var total = parseFloat(extra_fee) + parseFloat(price);
            $('input[name="total_price"]').val(total);
            $('input[name="currency_usd"]').val(0);
        }
        if($(this).val() == ''){
            $('input[name="total_price"]').val(price);
            $('input[name="currency_usd"]').val( 0);
            $('input[name="currency_rial"]').val(0);
            $('input[name="extra_fee"]').val('');
        }
        if(extra_fee_type == '' ){
            $.confirm({
                title: 'សូមជ្រើសរើសថ្លៃសេវាបន្ថែម!',
                theme: 'bootstrap',
                closeIcon: true,
                animation: 'scale',
                type: 'purple',
                content:'',
                buttons: {
                    បិទ: function () {

                    }
                },
            });
        }
    });



    $(document).on('keyup','input[name="currency_usd"]',function(){
        var total_price = $('input[name="total_price"]').val();
        var currency    = $('input[name="currency"]').val();
        var total_dollar  = $(this).val();
        var total_paid  = total_dollar ;
        if(parseFloat(total_paid) > parseFloat(total_price) ){
            alert("បញ្ចូលលុយលើសចំនួន!");
            $('input[name="currency_rial"]').val( 0);
            $(this).val(0);
        }
        else if($.isNumeric(total_dollar) ){
            $('input[name="currency_rial"]').val( ((total_price - total_dollar )* currency));
        }

        else{
            $('input[name="currency_rial"]').val( 0);
        }
    });

    var price;

    $(document).on('click','.edit_price_of_car', function(){
        var id = $(this).data('export_id');
        price= '';
        price = $(this).data('price');
        var delivery_option = $(this).data('delivery_option');
        var currency = $(this).data('currency');
        var taxi_status = $(this).data('taxi_status');
        var taxi_shop_fee = $(this).data('taxi_shop_fee');
        var taxi_cust_fee = $(this).data('taxi_cust_fee');
        var taxi_number = $(this).data('taxi_number');
        var total_riel = $(this).data('total_riel');
        var total_dollar = $(this).data('total_dollar');
        var extra_fee = $(this).data('extra_fee');
        var extra_fee_type = $(this).data('extra_fee_type');
        var user_currency = $(this).data('user_currency');
        var driver_note = $(this).data('driver_note');

        var option = '';
        var selected = '';
        var taxi_price = '';

        if(taxi_status == 1){
            selected = `
                        <option value="1" selected>ហាងចេញ</option>
                        <option value="2">អតិថិជនចេញ</option>`;
            taxi_price = taxi_shop_fee;
        }else if(taxi_status == 2){
            selected = `
                        <option value="1">ហាងចេញ</option>
                        <option value="2" selected>អតិថិជនចេញ</option>`;
            taxi_price = taxi_cust_fee;
        }else{
            selected = `
                        <option value="1">ហាងចេញ</option>
                        <option value="2">អតិថិជនចេញ</option>`;
            taxi_price = '';
        }

        if(extra_fee_type == 0){

            var total_price  = (parseFloat($(this).data('price')));
            selected1 = `<option value="" selected>ថ្លៃសេវាបន្ថែម</option>
                        <option value="1" >ហាងចេញ</option>
                        <option value="2">អតិថិជនចេញ</option>`;
        }else if(extra_fee_type == 1){
            var total_price  = (parseFloat($(this).data('price')));

            selected1 = `<option value="">ថ្លៃសេវាបន្ថែម</option>
                        <option value="1" selected >ហាងចេញ</option>
                        <option value="2"  >អតិថិជនចេញ</option>`;
        }else{
            var total_price  = ( parseFloat( $(this).data('extra_fee'))+parseFloat($(this).data('price')));
            selected1 = `<option value="">ថ្លៃសេវាបន្ថែម</option>
                        <option value="1">ហាងចេញ</option>
                        <option value="2" selected>អតិថិជនចេញ</option>`;

        }



        if( user_currency ){
            user_currency  = "Note: " + user_currency ;
        }
        {{-- $${parseFloat(price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')} --}}


        if(delivery_option == 'No') {
            option  = `
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <select name="extra_fee_type" class="form-control chosen-select"​>
                                    ${selected1}
                            </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="extra_fee" value="${extra_fee}" class="form-control" placeholder="ថ្លៃសេវាបូកបន្ថែម">
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                            <input type="hidden" value="${currency}" name="currency">
                            <input type="hidden" value="no_taxi" name="status">
                            <input type="text" name="" class="form-control " value="$${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}" readonly>
                            <input type="hidden"  name="total_price"   value="${parseFloat(total_price)}" >

                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                            <input type="text" name="currency_usd" class="form-control number-only " value="${ total_riel == 0  && total_dollar == 0 ? 0 : total_dollar }"    step="any">
                            </div>
                        </div>

                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                            <input type="number" name="currency_rial" value="${total_riel}" class="form-control number-only" placeholder="ទទួលបានលុយខ្មែរ" step="any">
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <textarea class="form-control" name="driver_note" rows="2" cols="50">${driver_note}</textarea>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <span> ${user_currency}  </span>
                            </div>
                        </div>
                        `;



        }else{
            option  =`

                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <select name="taxi_status" class="form-control chosen-select"​>
                                   ${selected}
                               </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="hidden" value="${currency}" name="currency">
                                <input type="hidden" value="have_taxi" name="status">
                                <input type="number" name="taxi_fee" value="${taxi_price}" class="form-control" step="any" placeholder="តម្លៃសេវាឡាន">
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <input type="text" name="taxi_number" value="${taxi_number}" class="form-control" placeholder="លេខឡាន">
                            </div>
                        </div>

                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <select name="extra_fee_type" class="form-control chosen-select"​>
                                    ${selected1}
                               </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="extra_fee" value="${extra_fee}" class="form-control" placeholder="ថ្លៃសេវាបូកបន្ថែម">
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                            <input type="text" name="" class="form-control " value="$${parseFloat(total_price).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}" readonly>
                            <input type="hidden"  name="total_price"   value="${parseFloat(total_price)}" >

                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <input type="text" name="currency_usd" class="form-control number-only" value="${total_riel == 0  && total_dollar == 0 ? 0 : total_dollar}"    step="any">

                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                            <input type="number" name="currency_rial" value="${total_riel}" class="form-control number-only" placeholder="ទទួលបានលុយខ្មែរ" step="any">
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group">
                                <textarea class="form-control" name="driver_note" rows="2" cols="50">${driver_note}</textarea>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <div class="form-group">
                                <span> ${user_currency}  </span>
                            </div>
                        </div>`;

        }

        $.confirm({
            title: 'កែសម្រួលតម្លៃ!',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'purple',
            content: `
                <form action="" class="formName">
                    <div class="row">
                        ${option}
                    </div>
                </form>`,
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    var data = [];
                    var status              = this.$content.find('input[name="status"]').val();
                    var driver_note              = this.$content.find('textarea[name="driver_note"]').val();
                    if(status == 'no_taxi'){
                        var currency_usd    = this.$content.find('input[name="currency_usd"]').val();
                        var currency_rial   = this.$content.find('input[name="currency_rial"]').val();
                        var extra_fee       = this.$content.find('input[name="extra_fee"]').val();
                        var extra_fee_type  = this.$content.find('select[name="extra_fee_type"]').val();
                        data = [
                          currency_usd,
                          currency_rial,
                          status,
                          extra_fee,
                          extra_fee_type,
                          driver_note
                        ];

                    }else{
                        var taxi_status     = this.$content.find('select[name="taxi_status"]').val();
                        var taxi_fee        = this.$content.find('input[name="taxi_fee"]').val();
                        var taxi_number     = this.$content.find('input[name="taxi_number"]').val();
                        var currency_usd    = this.$content.find('input[name="currency_usd"]').val();
                        var currency_rial   = this.$content.find('input[name="currency_rial"]').val();
                        var extra_fee       = this.$content.find('input[name="extra_fee"]').val();
                        var extra_fee_type  = this.$content.find('select[name="extra_fee_type"]').val();

                        data = [
                          currency_usd,
                          currency_rial,
                          status,
                          taxi_status,
                          taxi_fee,
                          taxi_number,
                          extra_fee,
                          extra_fee_type,
                          driver_note
                        ];
                    }
                    location.href = "/nso/delivery-action-edit-price-car/"+id+"/"+data;
                },

            },
        });
    });
    $('.show_all').on('click', function(e) {
        var export_id = [];
        var tbody_1 = '';
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });
        export_id = export_id.join(",");
        $.ajax({
            url: "{{route('delivery_payable_show')}}",
            type: 'GET',
            dataType: 'json',
            data: {
                export_id: export_id,
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                $('.tbody_1').empty();
                var export_id = '';
                $.each(data,function(index,val){
                    export_id += val.export_id+',';
                    if(val.taxi_status == 1){
                        var buy_fee =   val.taxi_shop_fee;
                    }
                    else{
                        var buy_fee =     val.taxi_cust_fee;
                    }
                    tbody_1 += `
                        <tr>
                            <td>${(index+1)}</td>
                            <td>${val.box_code}
                            <td>${val.name_location}</td>
                            <td>${val.customer_receive}</td>
                            <td>$${val.price}</td>
                            <td>$${val.delivery_fee}</td>
                            <td>$`+buy_fee+`</td>
                        </tr>
                    `;
                });
                $('.tbody_1').append(tbody_1);
                $('#submit').attr('href',"/nso/delivery-order-action/"+export_id+"/1");
                $('#show_item').modal('show');
            }
        });
    });

    $('.checkbox_all').on('click', function(e) {
        if ($(this).is(':checked', true)) {
            $(".checkbox").prop('checked', true);
        } else {
            $(".checkbox").prop('checked', false);
        }
    });


    $(document).on('click','.bt_done', function(){
        var  export_id = $(this).data('export_id')+',';
        var status = $(this).data('status');
        $.confirm({
            icon: 'fa fa-smile-o',
            theme: 'modern',
            title: 'កញ្ចប់នឹងជោកជ័យ!',
            closeIcon: true,
            content: ' ',
            animation: 'scale',
            type: 'green',
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    location.href = "/nso/delivery-order-action/"+export_id+"/"+status;
                },
            }
        });
    });
    $(document).on('click','.bt_pending', function(){
        var  export_id = $(this).data('export_id');
        var status = $(this).data('status');
        $.confirm({
            title: 'កញ្ចប់នឹងមិនជោកជ័យ!',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'blue',
            content: `
                <form action="" class="formName">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-sm-6 col-xs-6">
                                <label for="r1"><input type="radio" name="reason" value="យកស្អែក"> យកស្អែក<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r2"><input type="radio" name="reason" value="ដូរថ្ងៃ"> ដូរថ្ងៃ<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r3"><input type="radio" name="reason" value="រវល់ចេញទៅក្រៅ"> រវល់ចេញទៅក្រៅ<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r4"><input type="radio" name="reason" value="មិនលើកទូរស័ព្ទ"> មិនលើកទូរស័ព្ទ<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r5"><input type="radio" name="reason" value="ខលមិនចូល"> ខលមិនចូល<br></label>
                            </div>
                            <div class="col-sm-6 col-xs-6">
                                <label for="r6"><input type="radio" name="reason" value="មិនយក"> មិនយក<br></label>
                            </div>
                            <div class="col-sm-12 col-xs-12">
                                {!! Form::text('other',null, array('placeholder' => 'ផ្សេងៗ','class' => 'form-control')) !!}
                            </div>
                        </div>
                    </div>
                </form>`,
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    var reason = this.$content.find('input[name="reason"]:checked').val();
                    var other = this.$content.find('input[name="other"]').val();
                    if(!reason){
                        reason = '';
                        if(!other){
                            $.alert('មិនយកដោយសារមូលហេតុអ្វី?');
                            other = '';
                            return false;
                        }
                    }
                    var why = reason +' ' + other;
                    location.href = "/nso/delivery-order-action/"+export_id+"/"+status+"/"+why;
                },

            },
        });
    });

    $(document).on('click','.bt_cencel', function(){
        var  export_id = $(this).data('export_id');
        var status = $(this).data('status');
        $.confirm({
            title: 'កញ្ចប់នឹងមិនយកទេ!',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'orange',
            content: `
                <form action="" class="formName">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                {!! Form::text('reason',null, array('placeholder' => 'មូលហេតុ','class' => 'form-control')) !!}
                            </div>
                        </div>
                    </div>
                </form>`,
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    var reason = this.$content.find('input[name="reason"]').val();
                    if(!reason){
                        $.alert('មិនយកដោយសារមូលហេតុអ្វី?');
                        return false;
                    }
                    var why = reason;
                    location.href = "/nso/delivery-order-action/"+export_id+"/"+status+"/"+why;
                },

            },
        });
});

    $('#datatable_location').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst"    : "{{__('administrator.first')}}",
                "sLast"     : "{{__('administrator.last')}}",
                "sNext"     : "{{__('administrator.next')}}",
                "sPrevious" : "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        searching:false,
        bLengthChange:false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "{{route('datable_delivery_order_list')}}",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'delivery_date'},
                {data: 'box_code'},
                {data: 'shop_name'},
                {data: 'name_location'},
                {data: 'customer_receive'},
                {{-- {data: 'driver_name'}, --}}
                {data: 'category_name'},
                {data: 'total_price'},
                {data: 'delivery_fee'},
                {data: 'other_services_fee'},
                {data: 'buy_fee'},
                {data: 'description'},
                {data: 'pay_all',},
                {data: 'action'},
            ],
        "initComplete": function (settings, json) {
        }
    });
</script>
@stop

