@extends('layouts.app')
@section('content')
<?php Fun::lang()?>


<style>
   thead input {
        width: 100%;
    }
    input[type=text]{
        color: black;
    }
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
        width: 60px !important;
        padding: 1px 1px 1px 1px !important;
        box-shadow: none !important;

    }
    .dt-button{
        color: black !important;
    }
</style>

<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.history_driver_list')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                {!! Form::open(array('route' => 'history_driver_print','method'=>'POST')) !!}
                <div class="form-search">
                    @if(\Globals::is_Administrator() == 'Administrator')

                    <div class="form-group col-sm-2 col-xs-2">
                        <div class="form-group"> 
                            <label>Driver</label> 
                            {!! Form::select('drivers', getDriver(), null, ['class' => 'form-control']) !!}
                       </div>
                   </div>
                    @endif

                    <div class="form-group col-sm-2 col-xs-2">
                         <div class="form-group"> 
                             <label>Type Clear</label> 
                             <select name="clear" id="" class="form-control chosen-select" >
                                <option value=""> {{__('administrator.please_choose')}} </option>
                                <option value="clear">  {{__('administrator.clear')}}</option> 
                                <option value="not_clear">  {{__('administrator.not_clear')}}</option> 
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-sm-2 col-xs-2">
                        <div class="form-group"> 
                            <label>Type Status</label> 
                            <select name="status[]" id="" multiple="multiple" class="form-control chosen-select" >
                                <option value=""> {{__('administrator.please_choose')}} </option>
                                <option value="1">  {{__('administrator.processing')}}</option>
                                <option value="2">  {{__('administrator.padding')}} </option>
                                <option value="3"> {{__('administrator.done')}} </option>
                                <option value="4"> {{__('administrator.cancel')}} </option>
                            </select>
                       </div>
                   </div>


                   <div class="form-group col-sm-2 col-xs-2">
                        <div class="form-group"> 
                            <label>From Date</label> 
                            {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                        </div>
                    </div>
 
                    <div class="form-group col-sm-2 col-xs-2">
                        <div class="form-group"> 
                            <label>To Date</label> 
                            {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                        </div>
                    </div>
                 


                    <div class="form-group col-sm-2 col-xs-2">
                        <div class="form-group"> 
                            <label>Driver Voucher</label> 
                            {!! Form::text('driver_voucher',null, array('placeholder' => __('administrator.driver_voucher'),'class' => 'form-control')) !!}
                        </div>
                    </div>
                
                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right " id="search"  type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"  style='display: none'><span class="fa fa-print"></span>{{__('administrator.print')}} </button>
                        </div>
                    </div>

                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th width="2%">{{__('administrator.no')}}</th>
                    <th width="5%">
                        <div>
                            <span class="btn btn-success btn-xs fa fa-check-square-o approve bt-clear">  Clear</span> 
                             <input type="checkbox" name="check" class="checkbox_all">
                        </div>
                     </th>
                    <th width="5%">{{__('administrator.clear_by')}}</th>
                    <th width="5%">{{__('administrator.date')}}</th>
                    <th width="7%">{{__('administrator.driver_voucher')}}</th>
                    <th width="5%">{{__('administrator.driver')}}</th>
                    <th width="5%">{{__('administrator.shop_name')}}</th>
                    <th width="5%">{{__('administrator.box_code')}}</th>
                    <th width="5%">{{__('administrator.location')}}</th>
                    <th width="7%">{{__('administrator.customer_receive')}}</th>
                    <th width="5%">{{__('administrator.price')}}</th>
                    <th width="5%">{{__('administrator.price_of_car')}}</th>
                    <th width="5%">{{__('administrator.price_of_service')}}</th>
                    <th width="5%">{{__('administrator.extra_fee')}}</th>
                    <th width="5%">{{__('administrator.total')}}</th>
                    <th width="5%">{{__('administrator.reason')}}</th>
                    <th width="5%">{{__('administrator.status')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


@endsection



@section('script')
<script type="text/javascript">


    $('.bt-clear').on('click', function() {

        var export_id = [];
        $(".checkbox:checked").each(function() {
            export_id.push($(this).attr('data-export_id'));
        });

        export_id = export_id.join(",");
            $.confirm({
              icon: 'fa fa-check',
              theme: 'modern',
              closeIcon: true,
              animation: 'scale',
              type: 'blue',
              title:'Approve',
              buttons: {
                cancel: function () {
                  
                },
                somethingElse: {
                    text: 'Confirmed',
                    btnClass: 'btn-blue',
                    keys: ['enter', 'shift'],
                    action: function(){

                        $.ajax({
                            url: "{{route('driver.clear_box')}}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                export_id,export_id,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(response) {
                                if (response.success == true) {
                                    dataTableAjax();
                                } else {
                                    $.alert({
                                        title: "Error",
                                        content: response.error,
                                        buttons: {
                                            formSubmit: {
                                                text: 'Submit',
                                                btnClass: 'btn-blue',
                                                action: function () {
                                                    dataTableAjax();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        });
    });



    $(document).on('change','select[name="drivers"]',function(){
        if($(this).val() != ''){
            $('.buttons-print').show();
        }
        else{
            $('.buttons-print').hide();

        }
    });

    $('.checkbox_all').on('click', function(e) {
        if ($(this).is(':checked', true)) {
            $(".checkbox").prop('checked', true);
        } else {
            $(".checkbox").prop('checked', false);
        }
    });


 
    $(document).ready(function(){
        dataTableAjax();
    });
    $(document).on('click', '#search', function(){
        dataTableAjax();
    });

    function dataTableAjax(){
 

    var from_date       = $('input[name="from_date"]').val();
    var to_date         = $('input[name="to_date"]').val();
    var drivers         = $('select[name="drivers"]').val();
    var clear          = $('select[name="clear"]').val();
    var status          = $('select[name="status[]"]').val();
    var driver_voucher  = $('input[name="driver_voucher"]').val();

    $('#datatable_income').DataTable().destroy();
    
    var table  = $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[50, 200, 500, 1000,-1], [50, 200, 500, 1000,'All']],

        ajax:{
            url: "{{ route('driver-task.index') }}",
            data:{
                from_date:from_date,
                to_date:to_date,
                drivers:drivers,
                status:status,
                driver_voucher:driver_voucher,
                clear:clear
            }
        },
        columns:
            [
                {data: 'DT_RowIndex',       'searchable': false},
                {data: 'clear_box_code',     'searchable': false},
                {data: 'clear_by',     'searchable': false},
                {data: 'delivery_date',     'searchable': false},
                {data: 'driver_voucher',    name:'nso007_delivery_order.inovice',       'searchable': true},
                {data: 'driver_name',       name:'nso007_delivery_order.driver_name',   'searchable': true},
                {{--  {data: 'shop_name',         'searchable': false},  --}}
                {{--  {data: 'box_code',          name:'nso007_export_stock.box_code',        'searchable': true},  --}}
                {{--  {data: 'location_name',     'searchable': false},  --}}
                {{--  {data: 'customer_receive',  name:'nso007_export_stock.customer_receive','searchable': true},  --}}
                {{--  {data: 'price',             'searchable': false},  --}}
                {{--  {data: 'taxi_fee',          'searchable': false},  --}}
                {{--  {data: 'delivery_fee',      'searchable': false},  --}}
                {{--  {data: 'extra_fee',         'searchable': false},  --}}
                {{--  {data: 'total',             'searchable': false},  --}}
                {{--  {data: 'reason',            'searchable': false},  --}}
                {{--  {data: 'status',            'searchable': false},  --}}
            ],
            orderCellsTop: true,
            fixedHeader: true,
    });
}
</script>
@stop