@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
      <li><a href="/">{{__('administrator.dashboard')}}</a></li>
	  <li><a href="{{route('delivery-order.create')}}">{{__('administrator.new_order')}}</a></li>
	  <li class="active">{{__('administrator.pending')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.pending')}}</h3>
	                </div>
	                <div class="pull-right">
                    {{--  <a href="{{route('out-stock.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>  --}}
	                </div>
	            </div>
	        </div>
	    </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th>    {{__('administrator.no')}}          </th>
                <th>    {{__('administrator.date')}}        </th>
                <th >   {{__('administrator.box_code')}}    </th>
                <th >   {{__('administrator.shop_name')}}   </th>
                <th>    {{__('administrator.location')}}    </th>
                <th>    {{__('administrator.customer_receive')}}  </th>
                <th>    {{__('administrator.driver')}}      </th>
                <th>    {{__('administrator.driver_number')}}  </th>
                <th>    {{__('administrator.price')}}       </th>
                <th>    {{__('administrator.delivery_fee') }}</th>
                <th>    {{__('administrator.price_of_car')}}</th>
                <th>    {{__('administrator.reason')}}      </th>
                <th>    {{__('administrator.action')}}      </th>

            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>
<div class="modal fade" id="myModal_cencel" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content custom-pupup">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">&times;</span>
					<span class="sr-only">Close</span>
				</button>
				<h4 class="modal-title" id="myModalLabel">  {{__('administrator.cancel')}} </h4>
			</div>
			<div class="modal-body">
				<p class="statusMsg"></p>
				<form  method="POST" action="{{route('delivery_order_cencel')}}">
					{{csrf_field()}}
						<div class="row">
                            <div class="col-sm-12 col-xs-12">

                                <div class="col-sm-3 col-xs-12 ">
                                    <label for="name">{{__('administrator.description')}}</label>
                                </div>
                                <div class="col-sm-9 col-xs-12">
                                    {!! Form::textarea('reason',null, array('placeholder' =>__('administrator.description'),'class' => 'form-control', 'rows'=>'2')) !!}
                                    <input type="hidden" name="delivery_order_detail_pendding_id" class="form-control" required>
                                    <input type="hidden" name="export_id" class="form-control" required>
                                </div>
                            </div>

						</div>
					<div class="modal-footer">
						<button type="submit" class="btn btn-primary submitBtn btn-sm"> {{__('administrator.submit')}} </button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="myModal_add_to_stock" role="dialog">
	<div class="modal-dialog">
        <form  method="POST" action="{{route('add_to_stock')}}">
            	{{csrf_field()}}
            <div class="modal-content custom-pupup">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                        <span class="sr-only">Close</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel"> {{__('administrator.move_to_stock')}}</h4>
                    <input type="hidden" name="delivery_order_detail_pendding_id_1" class="form-control" required>
                    <input type="hidden" name="export_id_1" class="form-control" required>
                </div>
                <div class="modal-body">
                    <div class="modal-footer">
                        <button type="button" class="btn btn-warning submitBtn btn-sm" data-dismiss="modal" aria-hidden="true">  {{__('administrator.cancel')}} </button>
                        <button type="submit" class="btn btn-primary submitBtn btn-sm"> {{__('administrator.submit')}}</button>
                    </div>
                </div>
            </div>
		</form>
	</div>
</div>
@endsection

@section('script')
<script type="text/javascript">
    $(document).on('click', '.bt_cencel', function() {
        var  delivery_order_detail_pendding_id = $(this).data('delivery_order_detail_pendding_id');
        var  export_id = $(this).data('export_id');
        $('input[name="delivery_order_detail_pendding_id"]').val(delivery_order_detail_pendding_id);
        $('input[name="export_id"]').val(export_id);
        $('#myModal_cencel').modal('show');
    });

    $(document).on('click', '.bt_add_to_stock', function() {
        var  delivery_order_detail_pendding_id = $(this).data('delivery_order_detail_pendding_id');
        var  export_id = $(this).data('export_id');
        $('input[name="delivery_order_detail_pendding_id_1"]').val(delivery_order_detail_pendding_id);
        $('input[name="export_id_1"]').val(export_id);
        $('#myModal_add_to_stock').modal('show');
    });

    $('#datatable_location').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "{{route('list_delivery_padding')}}",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'date'},
                {data: 'box_code'},
                {data: 'shop_name'},
                {data: 'name_location'},
                {data: 'customer_receive'},
                {data: 'driver_name'},
                {data: 'phone'},
                {data: 'price'},
                {data: 'delivery_fee'},
                {data: 'bus_fee'},
                {data: 'reason'},
                {data: 'action'},
            ],

        "initComplete": function (settings, json) {
        }
    });

</script>
@stop



