@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="/">{{__('administrator.dashboard')}}</a></li>
	  <li class="active"> {{__('administrator.delivery')}}</li>
	  <li class="active">{{__('administrator.clear_invoice_history')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.clear_invoice_history')}}</h3>
	                </div>
	            </div>
	        </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="">{{__('administrator.driver')}}</label>
                    {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control','placeholder'=>__('administrator.please_select')]) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="exampleInputEmail1">{{ __('administrator.from') }}</label>
                    <input type="text" class="form-control date-year" id="from_date"
                           placeholder="{{ __('administrator.from') }}" value="{{date("Y-m-d")}}">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="exampleInputEmail1">{{ __('administrator.to') }}</label>
                    <input type="text" class="form-control date-year" id="to_date"
                           placeholder="{{ __('administrator.to') }}" value="{{date("Y-m-d")}}">
                </div>
            </div>
	    </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th style="width: 5% !important">{{__('administrator.no')}}</th>
                <th>{{__('administrator.date')}}</th>
                <th>{{__('administrator.clear_invoice')}}</th>
                <th>{{__('administrator.driver')}}</th>
                <th>{{__('administrator.action')}}</th>
            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>
</div>

@endsection

@section('script')
<script type="text/javascript">

    $(document).ready(function () {

        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url:'{{route('clear-driver-voucher-history')}}',
                data:function(d){
                    d.driver_id = $('select[name=driver_id]').val()
                    d.from_date = $('#from_date').val()
                    d.to_date = $('#to_date').val()
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex','searchable':false},
                    {data: 'delivery_date'},
                    {data: 'clear_box_code'},
                    {data: 'driver_name'},
                    {data: 'action','searchable':false},

                ],

            "initComplete": function (settings, json) {
            }
        });
    });
    $(document).on('change','select[name=driver_id],#from_date,#to_date',function(){
        $('#datatable_location').DataTable().ajax.reload();
    })
    $('.date-year').datepicker({
        changeMonth: true,
        changeYear: true,

        onClose: function(dateText, inst) {

        }
    });

</script>
@stop



