<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
    <div class="panel panel-default">
    <div class="panel-heading active" role="tab" id="headingOne">
        <h4 class="panel-title">
        <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapse_padding" aria-expanded="true" aria-controls="collapse_padding">
                Filtering
        </a>
        <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse_padding" aria-expanded="true" aria-controls="collapse_padding">
                <i class="fa fa-arrow-down"></i>
        </a>
        </h4>
    </div>
    <div id="collapse_padding" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
        <div class="panel-body" style="padding: 0 !important;border: none !important;">
            
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf
                <div class="form-search" style="margin: 0 !important">
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">{{__('administrator.shop_name')}}</label>
                    {!! Form::select('merchant', $merchant_show, null, ['class' => 'form-control pad_merchant']) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">City / Province</label>
                    <select name="province_or_city[]" id="pad_province_or_city" class="form-control chosen-select">
                        <option value="">  {{__('administrator.please_choose')}} </option>
                        <option value="pp">  Phnom Penh </option>
                        <option value="No">  Provice </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">From Date</label>
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control pad_from_date date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">To Date</label>
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control pad_to_date date_picker')) !!}
                </div>

                {{-- <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button id='search' class="button_sm button_info pull-right" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>

                    </div>
                </div> --}}
                </div>
            </form>
        </div>
    </div>
    </div>

</div>
<div class="wrapper-table ">
    <table id="table_padding" width="100%" class="table table-striped hover">
        <thead>
        <tr>
            <th>    {{__('administrator.no')}}          </th>
            <th>    {{__('administrator.date')}}        </th>
            <th >   {{__('administrator.box_code')}}    </th>
            <th >   {{__('administrator.shop_name')}}   </th>
            <th>    {{__('administrator.location')}}    </th>
            <th>    {{__('administrator.customer_receive')}}  </th>
            <th>    {{__('administrator.driver')}}      </th>
            <th>    {{__('administrator.driver_number')}}  </th>
            <th>    {{__('administrator.price')}}       </th>
            <th>    {{__('administrator.delivery_fee') }}</th>
            <th>    {{__('administrator.price_of_car')}}</th>
            <th>    {{__('administrator.reason')}}      </th>
            <th>    {{__('administrator.action')}}      </th>

        </tr>
        <tbody class="tbody">

        </tbody>

    </table>
</div>


<script>
    $(document).ready(function () {
        paddingAjax();
        function paddingAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city='',driver_id){
            $('#table_padding').DataTable().destroy();
            $('#table_padding').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.prevoius')}}"
                    },
                },
                ordering: false,
                serverSide: true,
                lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
                ajax:{
                        url: "{{ route('list_delivery_padding') }}",
                        data:{
                            driver_id:driver_id, 
                            from_date:from_date,
                            to_date:to_date,
                            merchant:merchant,
                            status:status,
                            pro_or_city:pro_or_city
                        }
                    },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'date'},
                        {data: 'box_code'},
                        {data: 'shop_name'},
                        {data: 'name_location'},
                        {data: 'customer_receive'},
                        {data: 'driver_name'},
                        {data: 'phone'},
                        {data: 'price'},
                        {data: 'delivery_fee'},
                        {data: 'bus_fee'},
                        {data: 'reason'},
                        {data: 'action'},
                    ],

                "initComplete": function (settings, json) {
                }
            });
        }
        $(document).on('change','.pad_merchant,#pad_province_or_city,.pad_from_date,.pad_to_date',function(){
            let from_date = $('.pad_from_date').val();
            let to_date = $('.pad_to_date').val();
            let merchant = $('.pad_merchant').val();
            let provice = $('#pad_province_or_city').val();
            paddingAjax(from_date,to_date,merchant,'',provice);
        });
});
</script>