<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
    <div class="panel panel-default">
    <div class="panel-heading active" role="tab" id="headingOne">
        <h4 class="panel-title">
        <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                Filtering
        </a>
        <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                <i class="fa fa-arrow-down"></i>
        </a>
        </h4>
    </div>
    <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
        <div class="panel-body" style="padding: 0 !important;border: none !important;">
            
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf
                <div class="form-search" style="margin: 0 !important">
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">{{__('administrator.shop_name')}}</label>
                    {!! Form::select('merchant', $merchant_show, null, ['class' => 'form-control in_stock_merchant']) !!}
                </div>
                
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">City / Province</label>
                    <select name="province_or_city[]" id="in_stock_province_or_city" class="form-control chosen-select">
                        <option value="">  {{__('administrator.please_choose')}} </option>
                        <option value="pp">  Phnom Penh </option>
                        <option value="No">  Provice </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">From Date</label>
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control in_stock_from_date date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">To Date</label>
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control in_stock_to_date date_picker')) !!}
                </div>

                {{-- <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button id='search' class="button_sm button_info pull-right" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>

                    </div>
                </div> --}}
                </div>
            </form>
        </div>
    </div>
    </div>

</div>
<div class="wrapper-table ">
    <table id="datatable_in_stock_delivery" width="100%" class="table table-striped hover">
        <thead>
        <tr>
            <th>{{__('administrator.no')}}</th>
            {{-- <th width="1%"><input type="checkbox" name="check" class="checkbox_all"></th> --}}
            <th>{{__('administrator.driver_name')}}</th>
            {{-- <th>{{__('administrator.created_at')}}</th>
            <th>{{__('administrator.created_by')}}</th> --}}
            <th>{{__('administrator.day_delivery')}}</th>
            <th>{{__('administrator.box_code')}}</th>
            <th>{{__('administrator.shop_name')}}</th>
            <th>{{__('administrator.customer_receive')}}</th>
            <th>{{__('administrator.location')}}</th>
            <th>{{__('administrator.price')}}</th>
            <th>{{__('administrator.delivery_fee')}}</th>
            <th>{{__('administrator.delivery_option')}}</th>
            {{-- <th>{{__('administrator.description')}}</th> --}}
            <th>{{__('administrator.status')}}</th>
            <th>{{__('administrator.action')}}</th>
        </tr>
        <tbody class="tbody">
        </tbody>
    </table>
</div>



<script>
    $(document).ready(function () {
        dataTableAjax();
        function dataTableAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city=''){
            $('#datatable_in_stock_delivery').DataTable().destroy();
            $('#datatable_in_stock_delivery').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.prevoius')}}"
                    },
                },
                ordering: false,
                serverSide: true,
                ajax:{
                    url: '{{route('in_stock_delivery')}}',
                    data:{
                        from_date:from_date,
                        to_date:to_date,
                        merchant:merchant,
                        status:status,
                        pro_or_city:pro_or_city
                    }
                },
            

                lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                columns:
                    [
                        {data: 'DT_RowIndex'            ,  'searchable': false},
                        // {data: 'share_link'             ,  'searchable': false},
                        {data: 'driver_name'             ,  'searchable': false},
                        // {data: 'export_date'            ,  'searchable': false},
                        // {data: 'create_by_name'         , name:  'nso007_export_stock.create_by_name'   ,  'searchable': true},
                        {data: 'delivery_date'          ,  'searchable': false},
                        {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                        {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                        {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                        {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                        {data: 'total_price'            ,  'searchable': false},
                        {data: 'delivery_fee'           ,  'searchable': false},
                        {data: 'delivery_option'        ,  'searchable': false},
                        // {data: 'description'            ,  'searchable': false},
                        {data: 'status'                 ,  'searchable': false},
                        {data: 'action'                 ,  'searchable': false},
                    ],
                "initComplete": function (settings, json) {
                    
                }
            });
        }
        $(document).on('change','.in_stock_merchant,#in_stock_province_or_city,.in_stock_from_date,.in_stock_to_date',function(){
            let from_date = $('.in_stock_from_date').val();
            let to_date = $('.in_stock_to_date').val();
            let merchant = $('.in_stock_merchant').val();
            let provice = $('#in_stock_province_or_city').val();
            dataTableAjax(from_date,to_date,merchant,'',provice);
        });
        $(document).on('click','.bt-print',function () {
        var href = $(this).data('href');
            $.ajax({
                url: href,
                success: function (data) {
                    var content_ = (data);
                    $.confirm({
                        title: '',
                        content: content_,
                        boxWidth: '50%',
                        useBootstrap: false,
                        buttons: {
                            close: {
                                text: '{{__('administrator.close')}}',
                                btnClass: 'button_warning',
                                keys: ['esc'],
                                action: function () {

                                }
                            },
                            print: {
                                text: '{{__('administrator.print')}}',
                                btnClass: 'button_info button_info_',
                                keys: ['enter'],
                                action: function () {
                                    $('.container1').printThis({
                                        loadCSS: "{{asset('assets/print_this/pos-invoice.css')}}",
                                        afterPrint: function () {


                                        }
                                    });
                                }
                            },
                        }
                    });
                    $('.loading_btn').hide();
                    $('input[type=submit]').show();
                    $('button[type=submit]').show();
                }
            });
            setTimeout(function(){
                let aa =$(document).find('.button_info_').trigger('click');
            },500);
    });
        $(document).on('click','.bt-delete',function () {
            var href = $(this).data('href');
            var this_ = $(this);
            $.confirm({
                icon: 'fa fa-trash',
                theme: 'modern',
                title: 'Delete!',
                closeIcon: true,
                animation: 'scale',
                type: 'red',buttons: {
                    cancel: function () {

                    },
                    confirm: {
                        text: 'Confirm',
                        btnClass: 'btn-red',
                        keys: ['enter', 'shift'],
                        action: function(){
                            $.ajax({
                                url: href,
                                success: function (response) {
                                    if (response.success == true) {
                                        this_.closest('tr').remove();
                                    } else {
                                        $.alert({
                                            title: "Error",
                                            content: response.error,
                                            buttons: {
                                                formSubmit: {
                                                    text: 'Submit',
                                                    btnClass: 'btn-blue',
                                                    action: function () {
                                                    
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                }
            });
        });
    });
</script>