<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
    <div class="panel panel-default">
    <div class="panel-heading active" role="tab" id="headingOne">
        <h4 class="panel-title">
        <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapse_in_process" aria-expanded="true" aria-controls="collapse_in_process">
                Filtering
        </a>
        <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse_in_process" aria-expanded="true" aria-controls="collapse_in_process">
                <i class="fa fa-arrow-down"></i>
        </a>
        </h4>
    </div>
    <div id="collapse_in_process" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
        <div class="panel-body" style="padding: 0 !important;border: none !important;">
            
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                @csrf
                <div class="form-search" style="margin: 0 !important">
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">{{__('administrator.shop_name')}}</label>
                    {!! Form::select('merchant', $merchant_show, null, ['class' => 'form-control pro_merchant']) !!}
                </div>
               
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">City / Province</label>
                    <select name="province_or_city[]" id="pro_province_or_city" class="form-control chosen-select">
                        <option value="">  {{__('administrator.please_choose')}} </option>
                        <option value="pp">  Phnom Penh </option>
                        <option value="No">  Provice </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">From Date</label>
                    {!! Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control pro_from_date date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">To Date</label>
                    {!! Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control pro_to_date date_picker')) !!}
                </div>

                {{-- <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button id='search' class="button_sm button_info pull-right" type="button"><span class="fa fa-search"></span> {{__('administrator.searching')}} </button>

                    </div>
                </div> --}}
                </div>
            </form>
        </div>
    </div>
    </div>

</div>
<div class="">
    <table id="table_proccessing" width="100%" class="table table-striped table-hover">
        <thead>
        <tr>
            <th width="1%">#</th>
            <th >{{__('administrator.date')}}                </th>
            <th >{{__('administrator.box_code')}}            </th>
            <th >{{__('administrator.driver_name')}}         </th>
            <th >{{__('administrator.shop_name')}}           </th>
            <th >{{__('administrator.location')}}            </th>
            <th >{{__('administrator.customer_receive')}}    </th>
            <th >{{__('administrator.category')}}            </th>
            <th >{{__('administrator.product_price')}}       </th>
            <th >{{__('administrator.delivery_fee') }}     </th>
            <th >{{__('administrator.price_of_car')}}        </th>
            <th >{{__('administrator.description')}}         </th>
            <th style="max-width: 10px">
            </th>
        </tr>
        <tbody class="tbody">

        </tbody>

    </table>
</div>


<script>
    $(document).ready(function () {
        proccessingAjax();
        function proccessingAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city='',driver_id){
                $('#table_proccessing').DataTable().destroy();
                $('#table_proccessing').DataTable({
                    "oLanguage": {
                        "sSearch": "{{__('administrator.search')}}:",
                        "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                        "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                        "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                        "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                        "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                        "oPaginate": {
                            "sFirst"    : "{{__('administrator.first')}}",
                            "sLast"     : "{{__('administrator.last')}}",
                            "sNext"     : "{{__('administrator.next')}}",
                            "sPrevious" : "{{__('administrator.prevoius')}}"
                        },
                    },
                    ordering: false,
                    bLengthChange:false,
                    "autoWidth" : false,
                    serverSide: true,
                    lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
                    ajax:{
                        url: "{{ route('in_processing') }}",
                        data:{
                            driver_id:driver_id, 
                            from_date:from_date,
                            to_date:to_date,
                            merchant:merchant,
                            status:status,
                            pro_or_city:pro_or_city
                        }
                    },
                    columns:
                        [
                            {data: 'DT_RowIndex'                    ,  'searchable': false},
                            {data: 'delivery_date'                  ,   name:  'nso007_delivery_order.delivery_date'            ,  'searchable': true},
                            {data: 'box_code'                       ,   name:  'nso007_export_stock.box_code'                   ,  'searchable': true},
                            {data: 'driver_name'                    ,   name:  'nso007_delivery_order.driver_name'              ,  'searchable': true},
                            {data: 'shop_name'                      ,   name:  'nso007_export_stock.shop_name'                  ,  'searchable': true},
                            {data: 'location_name'                  ,   name:  'nso007_export_stock.location_name'              ,  'searchable': true},
                            {data: 'customer_receive'               ,   name:  'nso007_export_stock.customer_receive'           ,  'searchable': true},
                            {data: 'category_name'                  ,  'searchable': false},
                            {data: 'total_price'                    ,  'searchable': false},
                            {data: 'delivery_fee'                   ,  'searchable': false},
                            {data: 'buy_fee'                        ,  'searchable': false},
                            {data: 'description'                    ,  'searchable': false},
                            {data: 'action'                         ,  'searchable': false},
                        ],
                    "initComplete": function (settings, json) {
                    }
                });
            }
            $(document).on('change','.pro_merchant,#pro_province_or_city,.pro_from_date,.pro_to_date',function(){
                let from_date = $('.pro_from_date').val();
                let to_date = $('.pro_to_date').val();
                let merchant = $('.pro_merchant').val();
                let provice = $('#pro_province_or_city').val();
                proccessingAjax(from_date,to_date,merchant,'',provice);
            });
    });
</script>
