@extends('layouts.app')
@section('content')
<script type="application/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>
<?php Fun::lang()?>
<style>
    .buttons-html5{background: coral !important;}
    div.dt-button-collection{
            width: 80px;
    }
    div.dt-button-collection span{
            color:black;
    }
    div.dt-button-collection {
        width: 182px;

    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 99999999;
    }
    .nav-item.active a{
        background: green !important;
    }
</style>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.delivery')}} List</li>
	</ol>
</div>
<ul class="nav nav-tabs" id="myTab" role="tablist">
    <li class="nav-item in-stock-delivery active" >
      <a class="nav-link tab" data-status="1" id="home-tab" data-toggle="tab" href="#in-stock-delivery" role="tab" aria-controls="home" aria-selected="true">{{__('administrator.in_stock_delivery')}} {{Cookie::get('status')}}</a>
    </li>
    <li class="nav-item proccessing">
      <a class="nav-link tab" data-status="2" id="proccessing-tab" data-toggle="tab" href="#proccessing" role="tab" aria-controls="home" aria-selected="true">{{__('administrator.in_processing')}} {{Cookie::get('status')}}</a>
    </li>
    <li class="nav-item done" >
      <a class="nav-link tab" data-status="3" id="done-tab" data-toggle="tab" href="#done" role="tab" aria-controls="profile" aria-selected="true">{{__('administrator.completed')}}</a>
    </li>
    <li class="nav-item pendding" >
      <a class="nav-link tab" data-status="4" id="pending-tab" data-toggle="tab" href="#pending" role="tab" aria-controls="contact" aria-selected="true">{{__('administrator.pending')}}</a>
    </li>
    <li class="nav-item cancel" >
      <a class="nav-link tab" data-status="5" id="cancel-tab" data-toggle="tab" href="#cancel" role="tab" aria-controls="contact" aria-selected="true">{{__('administrator.cancel')}}</a>
    </li>
    <li class="nav-item return_to_shop" >
      <a class="nav-link tab" data-status="7" id="return_to_shop-tab" data-toggle="tab" href="#return_to_shop" role="tab" aria-controls="contact" aria-selected="true">{{__('administrator.return_to_shop')}}</a>
    </li>
    <li class="nav-item return_to_shop_print" >
      <a class="nav-link tab" data-status="8" id="return_to_shop_print-tab" data-toggle="tab" href="#return_to_shop_print" role="tab" aria-controls="contact" aria-selected="true">{{__('administrator.return_to_shop_print')}}</a>
    </li>
  </ul>
  <div class="tab-content" id="myTabContent">
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default">
                <div class="panel-heading active" role="tab" id="headingOne">
                    <h4 class="panel-title">
                    <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Filtering
                    </a>
                    <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            <i class="fa fa-arrow-down"></i>
                    </a>
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body" style="padding: 0 !important;border: none !important;">

                        <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                            @csrf
                            <div class="form-search" style="margin: 0 !important">
                            <div class="form-group col-sm-3 col-xs-3">
                                <label for="">{{__('administrator.shop_name')}}</label>
                                {!! Form::select('merchant', $merchant_show, null, ['class' => 'form-control in_stock_merchant']) !!}
                            </div>

                            <div class="form-group col-sm-3 col-xs-3">
                                <label for="">City / Province</label>
                                <select name="province_or_city[]" id="in_stock_province_or_city" class="form-control chosen-select">
                                    <option value="">  {{__('administrator.please_choose')}} </option>
                                    <option value="pp">  Phnom Penh </option>
                                    <option value="No">  Provice </option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3 col-xs-3">
                                <label for="">From Date</label>
                                {!! Form::text('from_date', date("d-m-Y",strtotime("-1 week")), array('placeholder' => __('administrator.from_date'),'class' => 'form-control in_stock_from_date date_picker')) !!}
                            </div>
                            <div class="form-group col-sm-3 col-xs-3">
                                <label for="">To Date</label>
                                {!! Form::text('to_date',date("d-m-Y"), array('placeholder' => __('administrator.to_date'),'class' => 'form-control in_stock_to_date date_picker')) !!}
                            </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade active in" id="in-stock-delivery" role="tabpanel" aria-labelledby="home-tab">
            <div class="wrapper-table ">
                <table id="datatable1" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="proccessing" role="tabpanel" aria-labelledby="proccessing-tab">
            <div class="wrapper-table ">
                <table id="proccessing_datatable" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="done" role="tabpanel" aria-labelledby="done-tab">
            <div class="wrapper-table ">
                <table id="done_datatable" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="pending" role="tabpanel" aria-labelledby="pending-tab">
            <div class="wrapper-table ">
                <table id="pending_datatable" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th style="width: 2% !important">{{__('administrator.no')}}</th>
                        <th style="width: 2% !important">
                            <input type="checkbox" name="check" class="check-all-box">
                        </th>
                        <th style="width: 9% !important">{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="cancel" role="tabpanel" aria-labelledby="cancel-tab">
            <div class="wrapper-table ">
                <table id="cancel_datatable" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="return_to_shop" role="tabpanel" aria-labelledby="return_to_shop-tab">
            <div class="wrapper-table ">
                <table id="return_to_shop_datatable" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="return_to_shop_print" role="tabpanel" aria-labelledby="return_to_shop_print-tab">
            <div class="wrapper-table ">
                <table id="return_to_shop_print_datatable" width="100%" class="table table-striped hover">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.driver_name')}}</th>
                        <th id="export_date_change">{{__('administrator.export_date')}}</th>
                        <th>{{__('administrator.box_code')}}</th>
                        <th>{{__('administrator.shop_name')}}</th>
                        <th>{{__('administrator.customer_receive')}}</th>
                        <th>{{__('administrator.location')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.delivery_fee')}}</th>
                        <th>{{__('administrator.delivery_option')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th id="reason_change">{{__('administrator.description')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
  </div>
  <div class="modal fade" id="myModal_cencel_for_padding" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content custom-pupup">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">
					<span aria-hidden="true">&times;</span>
					<span class="sr-only">Close</span>
				</button>
				<h4 class="modal-title" id="myModalLabel">  {{__('administrator.cancel')}} </h4>
			</div>
			<div class="modal-body">
				<p class="statusMsg"></p>
				<form  method="POST" action="{{route('delivery_order_cencel')}}">
					{{csrf_field()}}
						<div class="row">
                            <div class="col-sm-12 col-xs-12">

                                <div class="col-sm-3 col-xs-12 ">
                                    <label for="name">{{__('administrator.description')}}</label>
                                </div>
                                <div class="col-sm-9 col-xs-12">
                                    {!! Form::textarea('reason',null, array('placeholder' =>__('administrator.description'),'class' => 'form-control', 'rows'=>'2')) !!}
                                    <input type="hidden" name="delivery_order_detail_pendding_id" class="form-control" required>
                                    <input type="hidden" name="export_id" class="form-control" required>
                                </div>
                            </div>

						</div>
					<div class="modal-footer">
						<button type="submit" class="btn btn-primary submitBtn btn-sm"> {{__('administrator.submit')}} </button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="myModal_add_to_stock" role="dialog">
	<div class="modal-dialog">
        <form  method="POST" action="{{route('add_to_stock')}}">
            	{{csrf_field()}}
            <div class="modal-content custom-pupup">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                        <span class="sr-only">Close</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel"> {{__('administrator.move_to_stock')}}</h4>
                    <input type="hidden" name="delivery_order_detail_pendding_id_1" class="form-control" required>
                    <input type="hidden" name="export_id_1" class="form-control" required>
                </div>
                <div class="modal-body">
                    <div class="modal-footer">
                        <button type="button" class="btn btn-warning submitBtn btn-sm" data-dismiss="modal" aria-hidden="true">  {{__('administrator.cancel')}} </button>
                        <button type="submit" class="btn btn-primary submitBtn btn-sm"> {{__('administrator.submit')}}</button>
                    </div>
                </div>
            </div>
		</form>
	</div>
</div>
<span style="width: 100%; margin-bottom: 70px;float: left;"></span>
@endsection
@section('script')

<script type="text/javascript">
            $(document).ready(function () {
                $(document).on('click','.tab',function(){
                    $.cookie("status", $(this).data('status'), { expires : 0.001 });
                    let from_date = $('input[name=from_date]').val();
                    let to_date = $('input[name=to_date]').val();
                    let merchant = $('select[name=merchant]').val();
                    let status = $('.nav-tabs .nav-item.active .tab').data('status');
                    let pro_or_city = $('select[name="province_or_city[]"]').val();
                    if($(this).attr('href') == "#proccessing"){
                        inproccessing(merchant,pro_or_city,status,from_date,to_date);
                    }else if($(this).attr('href') == "#in-stock-delivery"){
                        datatables(merchant,pro_or_city,status,from_date,to_date);
                    }else if($(this).attr('href') == "#done"){
                        done(merchant,pro_or_city,status,from_date,to_date);
                    }else if($(this).attr('href') == "#pending"){
                        pending(merchant,pro_or_city,status,from_date,to_date);
                    }else if($(this).attr('href') == "#cancel"){
                        cancel(merchant,pro_or_city,status,from_date,to_date);
                    }else if($(this).attr('href') == "#return_to_shop"){
                        return_to_shop(merchant,pro_or_city,status,from_date,to_date);
                    }else if($(this).attr('href') == "#return_to_shop_print"){
                        return_to_shop_print(merchant,pro_or_city,status,from_date,to_date);
                    }
                });
                $(document).on('change','.in_stock_merchant,#in_stock_province_or_city,.in_stock_from_date,.in_stock_to_date',function(){
                    let from_date = $('input[name=from_date]').val();
                    let to_date = $('input[name=to_date]').val();
                    let merchant = $('select[name=merchant]').val();
                    let status = $('.nav-tabs .nav-item.active .tab').data('status');
                    let pro_or_city = $('select[name="province_or_city[]"]').val();
                    switch(status){
                        case 1 :
                            datatables(merchant,pro_or_city,status,from_date,to_date);
                            break;
                        case 2 :
                            inproccessing(merchant,pro_or_city,status,from_date,to_date);
                            break;
                        case 3 :
                            done(merchant,pro_or_city,status,from_date,to_date);
                            break;
                        case 4 :
                            pending(merchant,pro_or_city,status,from_date,to_date);
                            break;
                        case 5 :
                            cancel(merchant,pro_or_city,status,from_date,to_date);
                            break;
                        case 7 :
                            return_to_shop(merchant,pro_or_city,status,from_date,to_date);
                            break;
                        case 8 :
                            return_to_shop_print(merchant,pro_or_city,status,from_date,to_date);
                            break;

                    }
                });
                $(document).on('change','.check-all-box',function(){
                    if($('.check-all-box').prop('checked')){
                        $('.check-export-id').prop('checked',true);
                    }else{
                        $('.check-export-id').prop('checked',false);
                    }
                });
                $(document).on('click','.multi-order',function(){
                    let table_id = $(this).data('table_id');
                    let export_id = [];
                    let from_status = [];
                    let check = false;
                    $.each($('.check-export-id'), function (indexInArray, valueOfElement) {
                        if($(this).prop('checked')){
                            check = true;
                            export_id.push($(this).val());
                            from_status.push($(this).data('status'));
                        }
                    });
                    if(!check){
                        $.alert("Please Check First");
                        return false;
                    }
                    $.confirm({
                        title:"Return to Order",
                        columnClass: 'small',
                        buttons: {
                            Cancel: function () {

                            },
                            ok: {
                                text: 'Return to Order',
                                action: function () {
                                    $.ajax({
                                        type: "POST",
                                        url: "{{route('add-to-stock-multi')}}",
                                        data: {
                                            'export_id':export_id,
                                            'from_status':from_status,
                                            _token:"{{csrf_token()}}"
                                        },
                                        dataType: "JSON",
                                        success: function (response) {
                                            $('#'+table_id).DataTable().ajax.reload(null,false);
                                        }
                                    });
                                }
                            }
                        }
                    });
                });
                $(document).on('click','.multi-shop',function(){
                    let table_id = $(this).data('table_id');
                    let export_id = [];
                    let from_status = [];
                    let check = false;
                    let type = "request";
                    $.each($('.check-export-id'), function (indexInArray, valueOfElement) {
                        if($(this).prop('checked')){
                            check = true;
                            export_id.push($(this).val());
                            from_status.push($(this).data('status'));
                        }
                    });
                    if(!check){
                        $.alert("Please Check First");
                        return false;
                    }
                    $.confirm({
                        title:"Return to Shop",
                        columnClass: 'small',
                        buttons: {
                            Cancel: function () {

                            },
                            ok: {
                                text: 'Return to Shop',
                                action: function () {
                                    $.ajax({
                                        type: "POST",
                                        url: "{{route('return-to-shop-multi')}}",
                                        data: {
                                            'export_id':export_id,
                                            'from_status':from_status,
                                            'type':type,
                                            _token:"{{csrf_token()}}",
                                        },
                                        dataType: "JSON",
                                        success: function (response) {
                                            if(type == "request"){
                                                $.alert("Request Return to Shop Successfully.")
                                            }
                                            $('#'+table_id).DataTable().ajax.reload(null,false);
                                        }
                                    });
                                }
                            }
                        }
                    });
                });
                $(document).on('click','.multi-process',function(){
                    let table_id = $(this).data('table_id');
                    let export_id = [];
                    let from_status = [];
                    let check = false;
                    $.each($('.check-export-id'), function (indexInArray, valueOfElement) {
                        if($(this).prop('checked')){
                            check = true;
                            export_id.push($(this).val());
                            from_status.push($(this).data('status'));
                        }
                    });
                    if(!check){
                        $.alert("Please Check First");
                        return false;
                    }
                    $.confirm({
                        title:"Back to Processing",
                        columnClass: 'small',
                        buttons: {
                            Cancel: function () {

                            },
                            ok: {
                                text: 'Back to Processing',
                                action: function () {
                                    $.ajax({
                                        type: "POST",
                                        url: "{{route('back-to-processing-multi')}}",
                                        data: {
                                            'export_id':export_id,
                                            'from_status':from_status,
                                            _token:"{{csrf_token()}}"
                                        },
                                        dataType: "JSON",
                                        success: function (response) {
                                            $('#'+table_id).DataTable().ajax.reload(null,false);
                                        }
                                    });
                                }
                            }
                        }
                    });
                });
                datatables();
                function datatables(merchant='',pro_or_city='',status="1",from_date='',to_date=''){
                    $('#datatable1').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        "destroy": true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:1,
                                pro_or_city:pro_or_city
                            }
                        },


                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {
                            if(status == 1){
                                $('#export_date_change').text('{{__('administrator.export_date')}}');
                            }else{
                                $('#export_date_change').text('{{__('administrator.day_delivery')}}');
                            }
                            status == 4 || status == 5 || status == 7 ? $('#reason_change').text('{{__('administrator.reason')}}') : $('#reason_change').text('{{__('administrator.description')}}');
                        }
                    });
                }
                function inproccessing(merchant='',pro_or_city='',status="2",from_date='',to_date=''){
                    $('#proccessing_datatable').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        destroy:true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:2,
                                pro_or_city:pro_or_city
                            }
                        },


                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {
                        }
                    });
                }
                function done(merchant='',pro_or_city='',status="3",from_date='',to_date=''){
                    $('#done_datatable').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        destroy:true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:3,
                                pro_or_city:pro_or_city
                            }
                        },


                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {

                        }
                    });
                }
                function pending(merchant='',pro_or_city='',status="4",from_date='',to_date=''){
                    $('#pending_datatable').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        destroy:true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:4,
                                pro_or_city:pro_or_city
                            }
                        },
                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'checkall'             ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {
                            $(".dataTables_filter").prepend('<span class="btn btn-sm btn-primary multi-process" data-table_id="pending_datatable">Back to Process</span> <span class="btn btn-sm btn-primary multi-shop" data-table_id="pending_datatable">Return to Shop</span> <span class="btn btn-sm btn-primary multi-order" data-table_id="pending_datatable">Return to Order</span> ');
                        }
                    });
                }
                function cancel(merchant='',pro_or_city='',status="5",from_date='',to_date=''){
                    $('#cancel_datatable').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        destroy:true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:5,
                                pro_or_city:pro_or_city
                            }
                        },


                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {

                        }
                    });
                }
                function return_to_shop(merchant='',pro_or_city='',status="7",from_date='',to_date=''){
                    $('#return_to_shop_datatable').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        destroy:true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:7,
                                pro_or_city:pro_or_city
                            }
                        },


                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {

                        }
                    });
                }
                function return_to_shop_print(merchant='',pro_or_city='',status="8",from_date='',to_date=''){
                    $('#return_to_shop_print_datatable').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.prevoius')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        buttons: [
                            {
                                extend: 'pdf',
                                autoFilter: true,
                                className: 'pull-right',
                                filename: 'Top Up Request',
                                title: 'Top Up Request',
                                sheetName: 'Top Up Request',
                                footer:true,
                                header: true,
                                text: '{{__('auth.save_as_pdf')}}',
                            },
                        ],
                        destroy:true,
                        ajax:{
                            url: window.location,
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:8,
                                pro_or_city:pro_or_city
                            }
                        },


                        lengthMenu: [[50, 100, 150, 200,1000, -1], [50, 100, 150, 200,1000, 'All']],
                        columns:
                            [
                                {data: 'DT_RowIndex'            ,  'searchable': false},
                                {data: 'driver_name'             ,  'searchable': false},
                                {data: status == 1 ? 'export_date' : 'delivery_date'          ,  'searchable': false},
                                {data: 'box_code'               , name:  'nso007_export_stock.box_code'         ,  'searchable': true},
                                {data: 'shop_name'              , name:  'nso007_export_stock.shop_name'        ,  'searchable': true},
                                {data: 'customer_receive'       , name:  'nso007_export_stock.customer_receive'        ,  'searchable': true},
                                {data: 'location_name'          , name:  'nso007_export_stock.location_name'        ,  'searchable': true},
                                {data: 'total_price'            ,  'searchable': false},
                                {data: 'delivery_fee'           ,  'searchable': false},
                                {data: 'delivery_option'        ,  'searchable': false},
                                {data: 'status'                 ,  'searchable': false},
                                {data: status == 4 || status == 5 || status == 7  ? 'reason' : 'description'                 ,  'searchable': false,"className": "reason"},
                                {data: 'action'                 ,  'searchable': false},
                            ],
                        "initComplete": function (settings, json) {

                        }
                    });
                    $(".dataTables_filter").prepend("<span class='btn btn-sm btn-primary print-all-box' style='margin-right:20px'>{{__('administrator.print')}}</span>");
                }
            });
            $(document).on('click','.print-all-box',function(){
                $.cookie("status", $(this).data('status'), { expires : 0.001 });
                let from_date = $('input[name=from_date]').val();
                let to_date = $('input[name=to_date]').val();
                let merchant = $('select[name=merchant]').val();
                let pro_or_city = $('select[name="province_or_city[]"]').val();
                let route = '{{route('return-in-shop-excel')}}?merchant='+merchant+'&pro_or_city='+pro_or_city+'&to_date='+to_date+'&from_date='+from_date+'&status='+8;
                $.confirm({

                    title: "Print Return To Shop",

                    columnClass: "xl",

                    closeIcon: true,

                    type: "blue",

                    theme: "bootstrap",

                    content: function() {

                        let jc = this;

                        return $.ajax({

                            url:"{{route('print-return-to-shop')}}",
                            data:{
                                from_date:from_date,
                                to_date:to_date,
                                merchant:merchant,
                                status:8,
                                pro_or_city:pro_or_city
                            },
                        }).done(function(response) {

                            jc.setContent(response.content);

                        });

                    },

                    buttons: {
                        cancel: function () {

                        },
                        printThis: {
                            text: 'Print',
                            btnClass: 'btn-blue',
                            action: function() {
                                document.title='Return-To-Shop-{{date("d-m-Y")}}';
                                $('#tblData').printThis({
                                    beforePrint: function () {

                                    },
                                    afterPrint: function () {

                                    }
                                });
                            },
                        },
                        somethingElse: {
                            text: 'Excel',
                            btnClass: 'btn-success',
                            keys: ['enter', 'shift'],
                            action: function() {
                                window.open(route, '_blank');
                            },
                        },
                    },

                    onOpenBefore: function() {

                        let jc = this;

                        jc.buttons.cancel.setText('Cancel');

                    },

                    onContentReady: function() {

                        let jc = this;

                        jc.$content.find('input[name="file"]').on('change', function() {

                            var filename = $(this).val().replace(/C:\\fakepath\\/i, '');

                            $(this).closest('label').find('span').text(filename);

                        });

                    }

                });

            });

            $(document).on('click','.change-driver',function(){
                let _this = $(this);
                let processing = $('.nav-item.proccessing.active').text();
                let in_stock = $('.nav-item.in-stock-delivery.active').text();

                let complete = $('.nav-item.complete.active').text();
                let export_id = $(this).data('export_id');
                let driver_id = $(this).data('driver_id');
                let time = $(this).data('time') == undefined ? 1 : $(this).data('time');
                let delivery_date = $(this).data('delivery_date');
                let old_driver_id = driver_id;
                $.confirm({
                    title: 'Change Driver!',
                    content: '' +
                    '<form action="" class="formName">' +
                        '<div class="form-group">' +
                            '<label>Select Driver</label>' +
                            `
                                {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control chosen-select select2','id'=>'driver_id','required']) !!}
                            ` +
                        '</div>' +

                    '</form>',

                    buttons: {
                        cancel: function () {
                            //close
                        },
                        formSubmit: {
                            text: 'Submit',
                            btnClass: 'btn-blue',
                            action: function () {
                                var driver_id = this.$content.find('#driver_id').val();
                                var time_policy = this.$content.find('#time_policy').val();
                                if(!driver_id){
                                    $.alert('provide a valid driver_id');
                                    return false;
                                }
                                $.ajax({
                                    url: "{{route('delivery.change-driver')}}",
                                    type: 'POST',
                                    dataType: 'json',
                                    data: {
                                        driver_id: driver_id,
                                        delivery_date,delivery_date,
                                        export_id,export_id,
                                        old_driver_id:old_driver_id,time_policy,
                                        _token: '{{ csrf_token() }}',
                                    },
                                    success: function(response) {
                                        if (response.success == true) {
                                            $('#'+_this.closest('table').attr('id')).DataTable().ajax.reload();
                                        } else {
                                            $.alert({
                                                title: "Error",
                                                content: response.error,
                                                buttons: {
                                                    formSubmit: {
                                                        text: 'Submit',
                                                        btnClass: 'btn-blue',
                                                        action: function () {
                                                            $('#'+_this.closest('table').attr('id')).DataTable().ajax.reload();
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        },
                    },
                    onContentReady: function () {
                        // bind to events
                        var jc = this;
                            jc.$content.find('.select2').select2({
                                dropdownParent:$('.jconfirm')
                            });
                        let change_driver = driver_id+'||'+time;
                        this.$content.find('#driver_id').val(change_driver).trigger('change');
                        this.$content.find('form').on('submit', function (e) {
                            e.preventDefault();
                            jc.$$formSubmit.trigger('click'); // reference the button and click it
                        });
                    }
                });
            });

            $(document).on('change','select[name="extra_fee_type"]',function(){
                $('input[name="currency_usd"]').val( 0);
                $('input[name="currency_rial"]').val(0);
                $('input[name="extra_fee"]').val('');
                $('input[name="total_price"]').val(parseFloat(price));
            });

            $(document).on('keyup','input[name="extra_fee"]',function(){

                var extra_fee_type   = $('select[name="extra_fee_type"]').val();
                var  extra_fee =$(this).val();

                if(extra_fee_type == 2 ){
                    var total = parseFloat(extra_fee) + parseFloat(price);
                    $('input[name="total_price"]').val(total);
                    $('input[name="currency_usd"]').val(0);
                }
                if($(this).val() == ''){
                    $('input[name="total_price"]').val(price);
                    $('input[name="currency_usd"]').val( 0);
                    $('input[name="currency_rial"]').val(0);
                    $('input[name="extra_fee"]').val('');
                }
                if(extra_fee_type == '' ){
                    $.confirm({
                        title: 'សូមជ្រើសរើសថ្លៃសេវាបន្ថែម!',
                        theme: 'bootstrap',
                        closeIcon: true,
                        animation: 'scale',
                        type: 'purple',
                        content:'',
                        buttons: {
                            បិទ: function () {

                            }
                        },
                    });
                }
            });

            $('.show_all').on('click', function(e) {
                var export_id = [];
                var tbody_1 = '';
                $(".checkbox:checked").each(function() {
                    export_id.push($(this).attr('data-export_id'));
                });
                export_id = export_id.join(",");
                $.ajax({
                    url: "{{route('delivery_payable_show')}}",
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        export_id: export_id,
                        _token: '{{ csrf_token() }}',
                    },
                    success: function(data) {
                        $('.tbody_1').empty();
                        var export_id = '';
                        $.each(data,function(index,val){
                            export_id += val.export_id+',';
                            if(val.taxi_status == 1){
                                var buy_fee =   val.taxi_shop_fee;
                            }
                            else{
                                var buy_fee =     val.taxi_cust_fee;
                            }
                            tbody_1 += `
                                <tr>
                                    <td>${(index+1)}</td>
                                    <td>${val.box_code}
                                    <td>${val.name_location}</td>
                                    <td>${val.customer_receive}</td>
                                    <td>$${val.price}</td>
                                    <td>$${val.delivery_fee}</td>
                                    <td>$`+buy_fee+`</td>
                                </tr>
                            `;
                        });
                        $('.tbody_1').append(tbody_1);
                        $('#submit').attr('href',"/nso/delivery-order-action/"+export_id+"/1");
                        $('#show_item').modal('show');
                    }
                });
            });

            $('.checkbox_all').on('click', function(e) {
                if ($(this).is(':checked', true)) {
                    $(".checkbox").prop('checked', true);
                } else {
                    $(".checkbox").prop('checked', false);
                }
            });


            $(document).on('click','.bt_done', function(){
                var  export_id = $(this).data('export_id')+',';
                var status = $(this).data('status');
                $.confirm({
                    icon: 'fa fa-smile-o',
                    theme: 'modern',
                    title: 'កញ្ចប់នឹងជោកជ័យ!',
                    closeIcon: true,
                    content: ' ',
                    animation: 'scale',
                    type: 'green',
                    buttons: {
                        បិទ: function () {

                        },
                        យល់ព្រម: function () {
                            location.href = "/nso/delivery-order-action/"+export_id+"/"+status;
                        },
                    }
                });
            });
</script>
@stop



