@extends('layouts.app')

@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
                  <li><a href="#">{{__('administrator.manage_setting')}}</a></li>
            <li><a href="{{route('currency.index')}}">{{__('administrator.currency')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>Currency histories</h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped table-hover  ">
                <thead>
                <tr>
                    <th width="5%">#</th>
                    <th>US</th>
                    <th>Riel</th>
                    <th>Date</th>
                </tr>
                </thead>
                <tbody style="text-align: center">
                    @foreach($history as $key => $row)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>${{number_format($row->dollar, 2)}}</td>
                            <td>៛{{number_format($row->riel, 2)}}</td>
                            <td>{{$row->date}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable();
        });
    </script>
@endsection
