@extends('layouts.app')
@section('content')
    <?php Fun::lang(); ?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="{{ route('app_dashboard') }}">{{ __('administrator.dashboard') }}</a></li>
            <li><a href="#" class="active">{{ __('administrator.category') }}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{ __('administrator.category') }}</h3>
                            </div>
                            <div class="pull-right" style="margin-top: 20px">
                                @if (Gate::check('Create Category'))
                                    <a href="{{ route('category.create') }}" class="button_sm button_info"><span
                                            class="fa fa-plus"></span> {{ __('administrator.create_new') }}</a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="table-responsive" style="float: left;">
                <table width="100%" class="table table-striped table-hover datatable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{__('administrator.image')}}</th>
                            <th>{{__('administrator.created_at')}}</th>
                            <th>{{__('administrator.name_km')}}</th>
                            <th>{{__('administrator.name_en')}}</th>
                            <th>{{__('administrator.description')}}</th>
                            <th>{{__('administrator.action')}}</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    @endsection



    @section('script')
        <script type="text/javascript">
            $(function() {
                $('.datatable').DataTable({
                    "oLanguage": {
                        "sSearch": "{{ __('administrator.search') }}:",
                        "sLengthMenu": "{{ __('administrator.display') }} _MENU_ {{ __('administrator.record_per_page') }}",
                        "sZeroRecords": "{{ __('administrator.Nothing_foundsorry') }}",
                        "sInfo": "{{ __('administrator.showing') }} _START_ {{ __('administrator.to') }} _END_ {{ __('administrator.of') }} _TOTAL_ {{ __('administrator.record') }}",
                        "sInfoEmpty": "{{ __('administrator.showing') }} 0 {{ __('administrator.to') }} 0 {{ __('administrator.of') }} 0 {{ __('administrator.record') }}",
                        "sInfoFiltered": "({{ __('administrator.filter_form') }} _MAX_ {{ __('administrator.total_records') }})",
                        "oPaginate": {
                            "sFirst": "{{ __('administrator.first') }}",
                            "sLast": "{{ __('administrator.last') }}",
                            "sNext": "{{ __('administrator.next') }}",
                            "sPrevious": "{{ __('administrator.prevoius') }}"
                        },
                    },
                    ordering: false,
                    serverSide: true,
                    responsive: true,
                    lengthMenu: [
                        [10,100, 200, 500, 1000, -1],
                        [10,100, 200, 500, 1000, 'All']
                    ],
                    ajax: window.location,
                    columns: [
                        {
                            data: 'DT_RowIndex',
                            "searchable": false
                        },
                        {
                            data: 'image',
                            "searchable": false
                        },
                        {
                            data: 'created_at'
                        },
                        {
                            data: 'name_km'
                        },
                        {
                            data: 'name_en'
                        },
                        {
                            data: 'description'
                        },
                        {
                            data: 'action'
                        },


                    ],

                    "initComplete": function(settings, json) {



                    },
                    "drawCallback": function(settings) {
                        $('.toggle').bootstrapToggle({
                            on: 'Enabled',
                            off: 'Disabled',
                            size: 'small',
                            offstyle: 'danger'
                        });
                        $('.toggle').click(function() {
                            console.log(2);
                            let toggle = $(this).find('.dis_and_en');
                            let value = parseInt(toggle.val()) == 0 ? parseInt(toggle.val()) + 1 :
                                parseInt(toggle.val()) - 1;
                            toggle.val(value);
                            let route = toggle.data('route');
                            let type = toggle.data('type');
                            $.ajax({
                                type: "DELETE",
                                url: route,
                                data: {
                                    _token: '{{ csrf_token() }}',
                                    type: type,
                                    status: value
                                },
                                success: function(response) {

                                }
                            });
                        })
                    }
                });
                $('.select2').select2({
                    theme: 'bootstrap4'
                });
            });
        </script>
    @stop
