@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
    <ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active">{{__('administrator.driver')}}</li>
    </ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3><span class="fa fa-th"></span> {{__('administrator.branch')}}</h3>
                    </div>
                    <div class="pull-right">
                    <a href="{{route('branch.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.branch')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th>#</th>
                <th>{{__('administrator.image')}}</th>
                <th>{{__('administrator.company_name')}}</th>
                <th>{{__('administrator.email')}}</th>
                <th>{{__('administrator.facebook_page')}}</th>
                <th>{{__('administrator.phone')}}</th>
                <th>{{__('administrator.address')}}</th>
                <th>{{__('administrator.action')}}</th>
            </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
</div>
@endsection



@section('script')
<script type="text/javascript">

    $(document).on('click', '.bt_action', function() {
        var id = $(this).find('.data-id').data('id');
        var status = $(this).hasClass( "off" ) == true ? 1 : 0;
        $.ajax({
                type: "GET",
                dataType: "json",
                url: '/nso/branch-status',
                data: {'status': status, 'id': id, "_token": "{{ csrf_token() }}"},
                success: function(data){
                console.log(data.success)
                }
            });

        $(this).toggleClass("off");
    });

    $('#datatable_location').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
        ajax: "{{route('branch.index')}}",
        columns:
            [
            {data: 'DT_RowIndex'},
            {data: 'image'},
            {data: 'company_name'},
            {data: 'email'},
            {data: 'facebook_page'},
            {data: 'phone'},
            {data: 'address'},
            {data: 'action'},


            ],

        "initComplete": function (settings, json) {
        }
    });




</script>
@stop



