@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('driver.index')}}">{{__('administrator.driver')}}</a></li>
            <li class="active">{{__('administrator.create_driver')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.create_driver')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::model($data, ['method' => 'PATCH','route' => ['branch.update', $data->id],'enctype'=>'multipart/form-data']) !!}

            @csrf
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.create_driver')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.company_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('company_name', null, array('placeholder' => __('administrator.company_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.email')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('email', null, array('placeholder' => __('administrator.email'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.facebook_page')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('facebook_page', null, array('placeholder' => __('administrator.facebook_page'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.phone')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('phone', null, array('placeholder' => __('administrator.phone'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.address')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::textarea('address',null, array('placeholder' =>__('administrator.address'),'class' => 'form-control', 'rows'=>'2')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.profile')}}</label>

                            </div>
                            <div class="form-group col-sm-9">
                               <input id="input-44" type="file" name="avartar" class="">
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </div>
                        </div>


                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="arrayImg" value="{{$data->logo}}" id="{{$data->logo}}">
            {!! Form::close() !!}
            <input type="hidden" name="src" value="{{asset('/images/upload/')}}">

        </div>
    </div>
@endsection

@section('script')
<script type="text/javascript">
    $(document).ready(function(){
        var share_fee_type = $('.share_fee_type').val();
        if(share_fee_type==2){
            $(".toggle").removeClass("btn-danger");
            $(".toggle").addClass("btn-success off");
        }
    });

    var src_image = $('input[name="src"]').val();
    $(document).ready(function() {
      var images = [];
      var caption = [];
      $('input[name="arrayImg"]').each(function(i, e){
          var obj = {
              caption: e.id,
              width: '120px'
          };
          images.push(src_image +'/'+e.value);
          caption.push(obj);
      });
      $("#input-44").fileinput({
          initialPreview: images,
          initialPreviewAsData: true,
          initialPreviewConfig: caption,
          uploadUrl: "/",
          maxFilePreviewSize: 10240,
          overwriteInitial: false,
      });
  });
    $(document).on('click', '.kv-file-remove', function(){
      var src = $(this).closest('.kv-preview-thumb').find('img').attr('src');
      $('input[name="arrayImg"]').each(function(){
          var thiss = $(this).val();
          if ( (src_image+'/'+thiss) == src){
              $(this).remove();
          }
      });
      $('input[name="new_arrayImg"]').each(function(){
          var thiss = $(this).val();
          if ( thiss == src){
              $(this).remove();
          }
      });
      $(this).closest('.kv-preview-thumb').remove();
  });

  $(document).on('change', 'input[name="gallery"]', function(){
      readURL(this);
  });
    function readURL(input) {
      for (let i = 0; i < input.files.length; i++) {
          if (input.files) {
              var reader = new FileReader();
              reader.onload = function (e) {
                  $('#appended').append('<input type="text" name="new_arrayImg" value="'+e.target.result+'" id="'+e.target.result+'">')
              }
              reader.readAsDataURL(input.files[i]);
          }
      }
  }
  $(document).on('click', '.fileinput-remove-button', function(){
      $('input[name="arrayImg"]').each(function(){
          $(this).remove();
      });
      $('input[name="new_arrayImg"]').each(function(){
          $(this).remove();
      });
      $('.kv-preview-thumb').each(function(){
          $(this).remove();
      });
  });

</script>
@stop



