@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.history_driver_list')}}</li>
	</ol>
</div>
<style>
    table#table_2 thead th {
        background: #aec2d7;
    }
    #table_2 {

        width: 98% !important;
        margin-left: 1%;
    }
    table#table_2 tbody th {
        background: #681f29;
    }

    table.dataTable tbody tr {
        background-color: #666060;
    }

    td.details-control {
        background:   url('{{ asset('images/details_open.png')}}')  no-repeat center center;
        cursor: pointer;
    }
    tr.details td.details-control {
        background:     url('{{ asset('images/details_close.png')}}')   no-repeat center center;
    }
</style>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        {{-- <div class="row">
            <div class="col-sm-12">
                {!! Form::open(array('route' => 'assign-to-driver.store','method'=>'POST')) !!}
                <div class="form-search">
                <div class="form-group col-sm-2 col-xs-2">
                    {!! Form::select('merchant', $merchant, null, ['class' => 'form-control merchant','required']) !!}
                </div>

                <div class="form-group col-sm-2 col-xs-2">

                    {!! Form::select('driver_id', $driver, null, ['class' => 'form-control merchant','required']) !!}
                </div>
                <div class="form-group col-sm-2 col-xs-2">
                    {!! Form::text('exchange_rate', $exchange_rate->currency_exchange_to, array('placeholder' =>__('administrator.description'),'class' => 'form-control','required')) !!}

                </div>
                <div class="form-group col-sm-2 col-xs-2">

                    {!! Form::text('date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    {!! Form::text('description', null, array('placeholder' =>__('administrator.description'),'class' => 'form-control')) !!}
                </div>

                <div class="col-sm-12 col-xs-12">
                    <div class="form-group footer-save">
                        <button type="submit" class="button_sm button_primary pull-right"><span class=" "></span>   {{__('administrator.save')}}</button>
                    </div>
                </div>


                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div> --}}

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>{{__('administrator.no')}}</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.box_qty')}}</th>
                    <th>{{__('administrator.description')}}</th>
                    <th>{{__('administrator.driver_pickup')}}</th>
                    <th>{{__('administrator.invoice_pickup')}}</th>
                    <th>{{__('administrator.type_of_pickup')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">New message</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form>
            <div class="form-group">
              <label for="recipient-name" class="col-form-label">Recipient:</label>
              <input type="text" class="form-control" id="recipient-name">
            </div>
            <div class="form-group">
              <label for="message-text" class="col-form-label">Message:</label>
              <textarea class="form-control" id="message-text"></textarea>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary">Send message</button>
        </div>
      </div>
    </div>
  </div>

@endsection
@section('script')
<script type="text/javascript">

    $(document).on('click','.bt_to_order', function(){
        var  list_id = $(this).data('list_id');
        $.confirm({
            title: 'Assign To Order ',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'orange',
            content: '',
            buttons: {
                បិទ: function () {   },
                យល់ព្រម: function () {
                    location.href = "/nso/assign-to-order/"+list_id;
                },
            },
        });
    });




    $(document).on('click','.bt_assign', function(){
        var  list_id = $(this).data('list_id');
        $.confirm({
            title: 'Assign To Driver ',
            theme: 'bootstrap',
            closeIcon: true,
            animation: 'scale',
            type: 'orange',
            content: `
                <form action="" class="formName">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                {!! Form::select('driver', $driver, null, ['class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>
                </form>`,
            buttons: {
                បិទ: function () {

                },
                យល់ព្រម: function () {
                    var driver =$('select[name="driver"]').val();
                    if(driver == ''){
                        $.alert('Select To Driver');
                        return false;
                    }
                    location.href = "/nso/assign-driver-pickup/"+list_id+"/"+driver;
                },
            },
        });
    });

    $(document).on('click','.bt_delete_main',function(){
        var id = $(this).data('id');
        var this_  = $(this);
        $.confirm({
            icon: 'fa fa-smile-o',
            title: 'លុប!',
            closeIcon: true,
            content: ' ',
            animation: 'scale',
            type: 'green',
            buttons: {
		        បិទ: function () {

		        },
		        យល់ព្រម: function () {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route("box_pickup_delete_main") }}',
                        dataType:'text',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,
                        },
                        success: function (data) {
                            this_.closest( "tr").remove();

                        }
                    });
		        },
		    }
        });
    });

    $(document).on('click','.bt_delete',function(){
        var id = $(this).data('id');
        $.confirm({
            icon: 'fa fa-smile-o',
            title: 'លុប!',
            closeIcon: true,
            content: ' ',
            animation: 'scale',
            type: 'green',
            buttons: {
		        បិទ: function () {

		        },
		        យល់ព្រម: function () {
                    $.ajax({
                        type: 'POST',
                        url: '{{ route("box_pickup_delete") }}',
                        dataType:'json',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,
                        },
                        success: function (data) {
                            $('.delete_'+id).remove();
                        }
                    });
		        },
		    }
        });
    });

    function format ( d ) {
        var tbody_1  ='';
        $.ajax({
            url: "{{route('assign_show')}}",
            type: 'GET',
            async: false,
            dataType: 'json',
            data: {
                driver_pick_up_id: d.driver_pick_up_id,
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                $('.tbody_1').empty();
                $total = 0;
                $.each(data, function(index, val) {
                    var delivery_option ='';
                    if(val.delivery_option != null){
                          delivery_option = val.delivery_option ;
                    }

                    var description ='';
                    if(val.description != null){
                        description = val.description ;
                    }
                    var delete1 ='';
                    if(d.status == 1 || d.status == 2 || d.status == 3){
                        delete1 =  ' <button class="button_sm button_danger bt_delete" data-id="'+val.id+'" type="button"><span class=" "></span> Delete </button> '
                    }
                    tbody_1 += `
                        <tr class="delete_${val.id}">
                            <td>${index+1}</td>
                            <td>${val.customer_receive}</td>
                            <td>${val.location_name}</td>
                            <td>${val.category_name}</td>
                            <td>${val.price}</td>
                            <td>${val.delivery_fee}</td>
                            <td>${delivery_option}</td>
                            <td>${description}</td>
                            <td>${delete1}</td>
                        </tr>
                    `;
                });
            }
        });

        var div = '<table  class="table"  id="table_2" >'+
            '<thead>'+
                '   <tr>'+
                    '  <th>No</th>'+
                    '  <th>{{__('administrator.customer_receive')}}</th>'+
                    '  <th>{{__('administrator.location')}}</th>'+
                    '  <th>{{__('administrator.category')}}</th>'+
                    '  <th>{{__('administrator.price')}}</th>'+
                    '  <th>{{__('administrator.delivery_fee')}}</th>'+
                    '  <th>{{__('administrator.delivery_option')}}</th>'+
                    '  <th>{{__('administrator.description')}}</th>'+
                    '  <th>{{__('administrator.action')}}</th>'+
                ' </tr>'+
            '</thead>'+
            tbody_1+
            '</tbody>'+

        '</table>';
        return div;
    }

    var dt =  $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "{{route('assign-to-driver.index')}}",
        columns:
            [ 
                {data: 'DT_RowIndex'},
                {data: 'date_pickup'},
                {data: 'shop_name'},
                {data: 'count_'},
                {data: 'description'},
                {data: 'driver_name'},
                {data: 'invoice_pickup'},
                {data: 'status'},
                {data: 'action'},
            ],
        "initComplete": function (settings, json) {
        }
    });
    var detailRows = [];
    $('#datatable_income tbody').on( 'click', 'tr td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = dt.row( tr );
        var idx = $.inArray( tr.attr('id'), detailRows );

        if ( row.child.isShown() ) {
            tr.removeClass( 'details' );
            row.child.hide();

            // Remove from the 'open' array
            detailRows.splice( idx, 1 );
        }
        else {
            tr.addClass( 'details' );
            row.child( format( row.data() ) ).show();

            // Add to the 'open' array
            if ( idx === -1 ) {
                detailRows.push( tr.attr('id') );
            }
        }
    } );

    dt.on( 'draw', function () {
        $.each( detailRows, function ( i, id ) {
            $('#'+id+' td.details-control').trigger( 'click' );
        } );
    } );



</script>
@stop



