@extends('layouts.app')
@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.system')}}</a></li>
            <li><a href="#">{{__('administrator.manage_setting')}}</a></li>
            <li><a class="active">{{__('administrator.appearance')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>

            {!! Form::model($branch, ['method' => 'POST','route' => ['admin.appearance.update', $branch->id]]) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form " id="show_animate">

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Nav Bar</label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('navbar',[''=>'Please select','top'=>'Top Nav bar','left'=>'Left Nav bar'], $branch->menu_layout, array('class' => 'form-control select2','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Animation Duration </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('animation_duration', null, array('placeholder' => 'Animation Duration','class' => 'form-control number-only','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Animation </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('animation',$animation, $branch->animation, array('class' => 'form-control select2','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Primary Color </label>
                            </div>
                            <div class="col-sm-9 color_picker">
                                @foreach($color as $key => $row)
                                    <label style="background: {{$row->name}}">
                                        {!! Form::radio('primary_text', $row->value, array('placeholder' => 'Primary Background','class' => 'form-control')) !!}
                                        {{$row->name}}
                                    </label>
                                    @if($key == 9)
                                        <br>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Primary Background </label>
                            </div>
                            <div class="col-sm-9 color_picker">
                                @foreach($color as $key => $row)
                                    <label style="background: {{$row->name}}">
                                        {!! Form::radio('primary_background', $row->value, array('placeholder' => 'Primary Background','class' => 'form-control')) !!}
                                        {{$row->name}}
                                    </label>
                                    @if($key == 9)
                                        <br>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Secondary Color </label>
                            </div>
                            <div class="col-sm-9 color_picker">
                                @foreach($color as $key => $row)
                                    <label style="background: {{$row->name}}">
                                        {!! Form::radio('secondary_text', $row->value, array('placeholder' => 'Primary Background','class' => 'form-control')) !!}
                                        {{$row->name}}
                                    </label>
                                    @if($key == 9)
                                        <br>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Secondary Background </label>
                            </div>
                            <div class="col-sm-9 color_picker">
                                @foreach($color as $key => $row)
                                    <label style="background: {{$row->name}}">
                                        {!! Form::radio('secondary_background', $row->value, array('placeholder' => 'Primary Background','class' => 'form-control')) !!}
                                        {{$row->name}}
                                    </label>
                                    @if($key == 9)
                                        <br>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Hover Color </label>
                            </div>
                            <div class="col-sm-9 color_picker">
                                @foreach($color as $key => $row)
                                    <label style="background: {{$row->name}}">
                                        {!! Form::radio('hover_text', $row->value, array('placeholder' => 'Primary Background','class' => 'form-control')) !!}
                                        {{$row->name}}
                                    </label>
                                    @if($key == 9)
                                        <br>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required" for="name">Hover Background </label>
                            </div>
                            <div class="col-sm-9 color_picker">
                                @foreach($color as $key => $row)
                                    <label style="background: {{$row->name}}">
                                        {!! Form::radio('hover_bg', $row->value, array('placeholder' => 'Primary Background','class' => 'form-control')) !!}
                                        {{$row->name}}
                                    </label>
                                    @if($key == 9)
                                        <br>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span
                                            class="fa fa-save"></span> {{__('administrator.update')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)"
                                        class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $('select[name=animation]').on('change', function () {
                var animation = $(this).val() + ' ' + $('input[name=animation_duration]').val() + 's ease';
                $('#show_animate').removeAttr('class');
                $('#show_animate').addClass('master-form ' + $(this).val());
                $('.' + $(this).val()).css('animation', animation);
            });
            $('input[name=primary_background]').on('click', function () {
                $('.navbar,.menu li').css('background', '#'+$(this).val());
                $('.navbar,.menu li').css('transition', '0.5s');
            });
            $('input[name=secondary_background]').on('click', function () {
                $('.breadcrumb').css('background', '#'+$(this).val());
                $('.breadcrumb').css('transition', '0.5s');
            });
            $('input[name=primary_text]').on('click', function () {
                $('.nav > li > a').css('color', '#'+$(this).val());
                $('.nav > li > a').css('transition', '0.5s');
            });
            $('input[name=secondary_text]').on('click', function () {
                $('body').css('color', '#'+$(this).val());
                $('body').css('transition', '0.5s');
            });
            $('input[name=hover_bg]').on('click', function () {
                var color =  '#'+$(this).val();
                $(".nav > li > a,.cursor").hover(function () {
                    $(this).css("background", color);
                    $(this).css('transition', '0.5s');
                }, function () {
                    $(this).css("background", "");
                    $(this).css('transition', '0.5s');
                });
            });
            $('input[name=hover_text]').on('click', function () {
                var color =  '#'+$(this).val();
                $(".nav > li > a,.cursor").hover(function () {
                    $(this).css("color", color);
                    $(this).css('transition', '0.5s');
                }, function () {
                    $(this).css("color", "");
                    $(this).css('transition', '0.5s');
                });
            });
        })
    </script>

@endsection




