@extends('layouts.print') @section('content')
<?php Fun::lang();$branch = DB::table('nso007_branch')->find(1);?>

    <div class="page-purchases">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="pull-left mr-bt">
                        <img src="{{asset('images/logo.png')}}" width="200">
                    </div>
                    <div class="pull-right">
                        <div class="title-add">
                            <h2>{{__('administrator.report_expense')}}</h2>
                            <table class="table table-striped">
                                <tr>
                                    <td><b class="pull-left">Company :</b></td>
                                    <td><span class="pull-left">{{ $branch->company_name }}</span></td>
                                </tr>
                                <tr>
                                    <td><b class="pull-left">Address :</b></td>
                                    <td><span class="pull-left">{{ $branch->address }}</span></td>
                                </tr>
                                <tr>
                                    <td><b class="pull-left">Phone :</b></td>
                                    <td><span class="pull-left">{{ $branch->phone }}</span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            @if(empty($from_date) && empty($to_date))
            <p>From date /..................../ To date /..................../</p>
            @else
            <p>From date / {{date('d-m-Y',strtotime($from_date))}} / To date / {{date('d-m-Y',strtotime($to_date))}} /</p>
            @endif
            <div class="wrapper-table">
                <table width="100%" class="table table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{__('administrator.date')}}</th>
                            <th>{{__('administrator.account_name')}}</th>
                            <th>{{__('administrator.description')}}</th>
                            <th>{{__('administrator.reference')}}</th>
                            <th>{{__('administrator.amount')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $total = 0; ?>
                        @foreach($data as $key => $value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{date('d-m-Y',strtotime($value->journal_paydate))}}</td>
                            <td>{{$value->account_code}} {{$value->acc_name_en}}</td>
                            <td>{{$value->journal_des}}</td>
                            <td>{{$value->journal_invoice}}</td>
                            <td>${{number_format($value->journal_credit,2)}}</td>
                        </tr>
                        <?php
                            $total += $value->journal_credit;
                        ?>
                        @endforeach
                    </tbody>
                    <tfoot class="label-right customize-tfoot">
                        <tr>
                            <td colspan="5" class="label-right"><b>សរុប :</b></td>
                            <td class="purchase_total">${{number_format($total,2)}}</td>
                        </tr>

                    </tfoot>
                </table>
            </div>
                
        </div>
    </div>
    @endsection