@extends('layouts.app') @section('content')
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li class="active">{{__('administrator.report_income')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12">
                        {!! Form::open(array('route' => 'reportIncomeStatementPrint','method'=>'POST')) !!}
                        <div class="form-search">
                            <div class="form-group col-sm-6 col-xs-6">
                                {!! Form::text('from_date', date('d-m-Y',strtotime('first day of this month')), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                            </div>
                            <div class="form-group col-sm-6 col-xs-6">
                                {!! Form::text('to_date',date('d-m-Y',strtotime('last day of this month')), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                            </div>
                            <div class="col-sm-12 col-xs-12">
                                <div class="form-group footer-save">
                                    <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> Searching</button>
                                    <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> Print</button> 
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>

            <div class="container-fluid">
                <div class="income-statement">
                    <div class="list">
                        <div class="left">
                            <div class="col-sm-6">
                                <h2 class="statement_blue">Income</h2>
                            </div>
                            <div class="col-sm-6">
                                <h2 class="statement_blue total_income">${{number_format($total_income,2)}}</h2>
                            </div>
                        </div>
                        <div class="incomes">
                            @foreach($statement['income'] as $key => $income)
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-6">
                                        <h4>{{$income->journal_acccode}} {{$income->acc_name_en}} {{$income->acc_name_km}}</h4>
                                    </div>
                                    <div class="col-sm-6">
                                        <h4>${{number_format($income->in_total,2)}}</h4>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="list">
                        <div class="left">
                            <div class="col-sm-6">
                                <h2 class="statement_red ">Expense</h2>
                            </div>
                            <div class="col-sm-6">
                                <h2 class="statement_red total_expense">${{number_format($total_expense,2)}}</h2>
                            </div>
                        </div>
                        <div class="expenses">
                            @foreach($statement['expense'] as $key => $exp)
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-6">
                                        <h4>{{$exp->journal_acccode}} {{$exp->acc_name_en}} {{$exp->acc_name_km}}</h4>
                                    </div>
                                    <div class="col-sm-6">
                                        <h4>${{number_format($exp->ex_total,2)}}</h4>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="list">
                        <div class="left">
                            <div class="col-sm-6">
                                <h2 class="statement_green">Income Statement</h2>
                            </div>
                            <div class="col-sm-6">
                                <h2 class="statement_green total">${{number_format($total_income-$total_expense,2)}}</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @endsection @section('script')
        <script type="text/javascript">
            function searching() {
                var from_date = $('input[name="from_date"]').val();
                var to_date = $('input[name="to_date"]').val();
                var account_code = $('select[name="account_code"]').val();
                var incomes = '', expenses = '';
                var total_income = 0 , total_expense = 0;
                $.ajax({
                    url: "{{ Route('IncomeStatement') }}",
                    method: "POST",
                    dataType: "json",
                    data: { from_date: from_date,
                            to_date: to_date,
                            _token: '{{ csrf_token() }}',
                    },
                    success:function (data) {
                        $.each(data['income'], function(index, val) {
                            total_income += parseFloat(val.in_total);
                            incomes += `
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-6">
                                                <h4>${val.journal_acccode} ${val.acc_name_en} ${val.acc_name_km}</h4>
                                            </div>
                                            <div class="col-sm-6">
                                                <h4>$${parseFloat(val.in_total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</h4>
                                            </div>
                                        </div>
                                    </div>`;
                        });
                        $.each(data['expense'], function(index, val) {
                            total_expense += parseFloat(val.ex_total);
                            expenses += `
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="col-sm-6">
                                                    <h4>${val.journal_acccode} ${val.acc_name_en} ${val.acc_name_km}</h4>
                                                </div>
                                                <div class="col-sm-6">
                                                    <h4>$${parseFloat(val.ex_total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</h4>
                                                </div>
                                            </div>
                                        </div>`;
                        });
                        $('.total_income').text('$'+parseFloat(total_income).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                        $('.total_expense').text('$'+parseFloat(total_expense).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                        $('.statement_green .total').text('$'+parseFloat(total_income-total_expense).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,'));
                        $('.incomes').empty().append(incomes);
                        $('.expenses').empty().append(expenses);
                    }
                });
            }
        </script>
        @stop
