@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.account_receivable')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.account_receivable')}}</h3>
	                </div>
	                <div class="pull-right">
	                   <a href="{{route('account-receivable.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>
	                </div>
	            </div>
	        </div>
	    </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_account_receivable" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.shop_name')}}</th>
                    <th>{{__('administrator.phone')}}</th>
                    <th>{{__('administrator.reference')}}</th>
                    <th>{{__('administrator.description')}}</th>
                    <th>{{__('administrator.receivable_amount')}}</th>
                    <th>{{__('administrator.receivable_refunds')}}</th>
                    <th>{{__('administrator.receivable_remain')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
            </thead>
        </table>
    </div>
</div>


@endsection



@section('script')
<script type="text/javascript">

    $('#datatable_account_receivable').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "{{route('account-receivable.index')}}",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'receivable_date'},
                {data: 'customer_name'},
                {data: 'phone'},
                {data: 'receivable_invoice'},
                {data: 'description'},
                {data: 'receivable_amount'},
                {data: 'receivable_refunds'},
                {data: 'receivable_remain'},
                {data: 'action'},
            ],

        "initComplete": function (settings, json) {
        }
    });


</script>
@stop



