@extends('layouts.app')

@section('content')
<?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('account-chart.index')}}">{{__('administrator.account_chart')}}</a></li>
            <li class="active">{{__('administrator.edit')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.account_chart')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::model($account_chart, ['method' => 'PATCH','route' => ['account-chart.update', $account_chart->id]]) !!}
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.account_chart')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div>

                        ​<div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.account_type')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::select('acctype', $account_type, null, ['class' => 'form-control chosen-select']) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.account_name')}}(En) </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('acc_name_en', null, array('placeholder' => __('administrator.account_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.account_name')}}(KM) </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('acc_name_km', null, array('placeholder' => __('administrator.account_name'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.description')}}</label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('acc_des', null, array('placeholder' => __('administrator.description'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>


                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::close() !!}

        </div>
    </div>
@endsection

