$(document).ready(function() {
    $('#table_journal').DataTable({
        "aaSorting": [],
        "pagingType": "full_numbers",
        "lengthMenu": [
            [20, 50, 100, 250, 500],
            [20, 50, 100, 250, 500]
        ],
        ajax: "/accounting/get-journal-list",
        columns: [
            {
                data: 'checkbox'
            },
            {
                data: 'id'
            },
            {
                data: 'journal_paydate'
            },
            {
                data: 'voucher'
            },
            {
                data: 'voucher_ref'
            },
            {
                data: 'account_code'
            },
            {
                data: 'journal_invoice'
            },
            {
                data: 'invoice_type'
            },
            {
                data: 'journal_des'
            },
            {
                data: 'journal_debit'
            },
            {
                data: 'journal_credit'
            },
        ],
        "initComplete": function(settings, json) {
            $('.main-spinner').hide();
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            var Total_Owned = api
                .column( 9 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
            var Total_Received = api
                .column( 10 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
            var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
            $( api.column( 9 ).footer() ).html(currentcyFormat(Total_Owned));
            $( api.column( 10 ).footer() ).html(currentcyFormat(Total_Received));
          },
    });

    $.fn.dataTable.ext.errMode = 'throw';
});