<?php

namespace App;

use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use Notifiable;
    use HasRoles;
    use HasApiTokens;
//facebook_id
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
	protected $table = 'users';
	protected $primaryKey = 'id';
    protected $fillable = [
        'name', 'email', 'password','gender','role','user_type','phone','address','avartar','create_by_name'
    ];


    protected  $casts = [
        'educate' => 'array',
        'language' => 'array',
        'emergency_contact' => 'array',
        'family' => 'array',
        'family_full' => 'array',
        'work_experience' => 'array'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    public function group(){
        return $this->belongsTo('App\UserGroupModel','group_id','id');
    }
    public function department(){
        return $this->belongsTo('App\DepartmentModel','department_id','id');
    }
    public function job(){
        return $this->belongsTo('App\HrJobModel','job_id','id');
    }
    public function employment(){
        return $this->belongsTo('App\HrEmploymentStatusModel','employment_id','id');
    }


    public function get_seller_wallets(){
        return $this->belongsTo('App\WalletModel','id','user_id');
    }



}
