<?php

namespace App\Providers;


use App\BranchModel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use View;
use Auth;
use DB;
use App\CategoryModel;
use App\WarehouseModel;
use App\CurrencyModel;
use App\ExportStockModel;
use App\HistoryCurrentcy;
use Carbon\Carbon;
use App\MerchantPendingPickup;
use App\RequestPickup;
class AppServiceProvider extends ServiceProvider
{

    public function register()
    {
        
    }

    public function boot()
    {
        Schema::defaultStringLength(191);
        View::composer('layouts.app', function($view)
        {
            $requestpickup = RequestPickup::
            join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')

            ->select('nso007_request_pickup.*',
                    'shop.shop_name AS shop_name',
                    'driver.name AS driver_name',
                    'nso007_request_pickup.id AS request_pickup_id'
            )
            ->where('nso007_request_pickup.status',1)
            ->groupBy('nso007_request_pickup.id')
            ->groupBy('nso007_request_pickup.date')
            ->orderBy('nso007_request_pickup.id','desc')
            ->get();
            $requestpickup_count = 0;
            if($requestpickup->count()){
                $requestpickup_count = $requestpickup->count() ;
            }  
            $from_date    = date('Y-m-d');
            $to_date        =  date('Y-m-d', strtotime("+1 day", strtotime(date('Y-m-d')) ));
            
            $date_delivery = ExportStockModel::
            Join('nso007_location','nso007_location.id','nso007_export_stock.location') 
            ->where('nso007_export_stock.status',1) 
            ->where('nso007_export_stock.date_delivery','<=',$to_date) 
            ->orderBy('nso007_export_stock.date_delivery','asc')
            ->get();  
            
            $view->with(compact('requestpickup','requestpickup_count','date_delivery'));
        });


        View::composer('layouts.frontend', function($view)
        {
            
            
        });

        View::composer(['layouts.app'], function($view){
           
        });


    }
}
