<?php

namespace App\Imports;

use App\LocationModel;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Validators\Failure;
use phpDocumentor\Reflection\Location;

class LocationImport implements ToModel, WithHeadingRow, SkipsOnError, SkipsOnFailure,WithValidation
{
    use Importable, SkipsErrors, SkipsFailures;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if ($row['name_en'] != null) {
            return new LocationModel([
                'name_en'     =>$row['name_en'],
                'name_km'     =>$row['name_km'],
                'price'     =>$row['price'],
                'status'     =>1,
                'type'     =>'location',
            ]);
        }
        
    }
    public function rules(): array
    {
        return [
            '*.name_en' => ['unique:nso007_location'],
        ];
    }
    public function onFailure(Failure ...$failures)
    {
        // TODO: Implement onFailure() method.
    }
}
